package com.devicenative.dna.utils;

import android.app.Service;
import android.content.Intent;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.webkit.WebSettings;
import android.os.IBinder;
import android.webkit.WebView;

public class DNAConfigBuilder extends Service {
    private static final String WEBVIEW_DIR_SUFFIX = "dna_cfg";
    private static boolean isRunning = false;

    @Override
    public void onCreate() {
        super.onCreate();
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.P) {
            WebView.setDataDirectorySuffix(WEBVIEW_DIR_SUFFIX);
        }
    }

    @Override
    public int onStartCommand(Intent intent, int flags, int startId) {
        if (isRunning) {
            try {
                stopSelf();
            } catch (Exception e) {
                DNALogger.i("DNAConfigFilter: Error while stopping service: " + e.getMessage());
            }
            return START_NOT_STICKY;
        }

        isRunning = true;

        new Handler(Looper.getMainLooper()).post(new Runnable() {
            @Override
            public void run() {
                try {
                    String webViewUserAgent = WebSettings.getDefaultUserAgent(getApplicationContext());
                    DNALogger.i("DNAConfigFilter: User Agent: " + webViewUserAgent);

                    DNAPreferences.setUserAgent(getApplicationContext(), webViewUserAgent);
                    DNALogger.i("DNAConfigFilter: User Agent saved to SharedPreferences");
                } catch (Exception e) {
                    DNALogger.i("DNAConfigFilter: Error while collecting User Agent: " + e.getMessage());
                } finally {
                    new Handler(Looper.getMainLooper()).postDelayed(new Runnable() {
                        @Override
                        public void run() {
                            stopSelf();
                            isRunning = false;
                            android.os.Process.killProcess(android.os.Process.myPid());
                        }
                    }, 1000);
                }
            }
        });

        return START_NOT_STICKY;
    }

    @Override
    public IBinder onBind(Intent intent) {
        return null;
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        isRunning = false;
    }
}

