package com.devicenative.dna.network;

import android.content.Context;

import com.devicenative.dna.db.DNAAdRecord;
import com.devicenative.dna.db.DNADatabaseInterface;
import com.devicenative.dna.db.DNAEventRecord;
import com.devicenative.dna.db.DNAShortcutRecord;
import com.devicenative.dna.utils.DNAConstants;
import com.devicenative.dna.utils.DNALogger;
import com.devicenative.dna.utils.DNAPreferences;
import com.devicenative.dna.utils.DNAStatsLogger;
import com.devicenative.dna.utils.DNAUtils;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class DNANetworkRequestStats extends DNANetworkRequest {

    long startTime;

    List<Long> statsIdsToDelete;

    /**
     * <p>Create an instance of {@link DNANetworkRequestStats} to sync the stat events.</p>
     *
     * @param context     Current context
     */
    public DNANetworkRequestStats(Context context) {
        super(context, DNAConstants.RequestPath.STATS);
        try {
            setPost(new JSONObject());
        } catch (JSONException ex) {
            DNALogger.e("DNANetworkRequestSync: " + ex.getMessage());
        }
    }

    @Override
    public void onPreExecute() {
        super.onPreExecute();
        startTime = System.currentTimeMillis();
        JSONObject postBody = new JSONObject();
        try {
            // put all the keys
            postBody.put(DNAConstants.RequestParams.DEVICE_KEY, prefHelper_.getDeviceKey());
            postBody.put(DNAConstants.RequestParams.APP_VERSION, prefHelper_.getAppVersion());
            postBody.put(DNAConstants.RequestParams.APP_PACKAGE_NAME, prefHelper_.getAppPackageName());
            postBody.put(DNAConstants.RequestParams.SDK_VERSION, DNAConstants.DNA_SDK_VERSION);
            postBody.put(DNAConstants.RequestParams.OS_VERSION, prefHelper_.getAndroidVersion());
            postBody.put(DNAConstants.RequestParams.PLATFORM, prefHelper_.getDeviceModel());
            postBody.put(DNAConstants.RequestParams.CARRIER, prefHelper_.getCarrierValue());
            postBody.put(DNAConstants.RequestParams.LAST_SYNC_TIME, prefHelper_.getLastApiSyncTime());
            postBody.put(DNAConstants.RequestParams.BUILD_TIME, prefHelper_.getDeviceStartTime());
            postBody.put(DNAConstants.RequestParams.CPU_COUNT, prefHelper_.getCPUCount());
            postBody.put(DNAConstants.RequestParams.MAX_MEMORY, prefHelper_.getMaxMemory());
            postBody.put(DNAConstants.RequestParams.SESSION_ID, prefHelper_.getSessionID());
            postBody.put(DNAConstants.RequestParams.CODE_VERSION_KEY, prefHelper_.getCodeVersionID());
            postBody.put(DNAConstants.RequestParams.ADS_VERSION_KEY, prefHelper_.getAdBundleID());
            postBody.put(DNAConstants.RequestParams.METADATA_VERSION_KEY, prefHelper_.getMetadataVersionID());
            postBody.put(DNAConstants.RequestParams.BLACKLIST_VERSION_KEY, prefHelper_.getBlacklistVersionID());
            if (prefHelper_.getConfigCountryOverride() != null && !prefHelper_.getConfigCountryOverride().isEmpty()) {
                postBody.put(DNAConstants.RequestParams.COUNTRY_OVERRIDE, prefHelper_.getConfigCountryOverride());
            }

            postBody.put(DNAConstants.RequestParams.CONFIG_GAID_DISABLED, prefHelper_.getConfigGAIDDisabled());
            postBody.put(DNAConstants.RequestParams.CONFIG_USAGE_DISABLED, prefHelper_.getConfigAppUsageDisabled());
            postBody.put(DNAConstants.RequestParams.CONFIG_ADS_DISABLED, prefHelper_.getConfigAdsDisabled());
            postBody.put(DNAConstants.RequestParams.CONFIG_SEARCH_ADS_DISABLED, prefHelper_.getSearchAdsDisabled());
            postBody.put(DNAConstants.RequestParams.CONFIG_SEARCH_INSTALL_DISABLED, prefHelper_.getSearchInstallAdsDisabled());
            postBody.put(DNAConstants.RequestParams.CONFIG_REC_ADS_DISABLED, prefHelper_.getRecomAdsDisabled());
            postBody.put(DNAConstants.RequestParams.CONFIG_REC_INSTALL_ADS_DISABLED, prefHelper_.getRecomInstallAdsDisabled());

            List<DNAEventRecord> eventRecords = DNADatabaseInterface.getAllStats(context_.get());

            statsIdsToDelete = new ArrayList<>();
            JSONArray statsArray = new JSONArray();
            for (DNAEventRecord eventRecord : eventRecords) {
                statsArray.put(eventRecord.getJSONObject());
                statsIdsToDelete.add(eventRecord.dbId);
            }

            // add the stats object
            postBody.put(DNAConstants.RequestParams.STATS_KEY, statsArray);

            DNALogger.i("DNANetworkRequestSync: onPreExecute: " + postBody);

            setPost(postBody);
        } catch (JSONException ex) {
            DNALogger.e("DNANetworkRequestSync: " + ex.getMessage());
        }
    }

    @Override
    public void onRequestSucceeded(DNANetworkResponse resp) {
        try {
            // after sending stats, clear them locally
            DNADatabaseInterface.deleteStats(context_.get(), statsIdsToDelete);

            JSONObject statsMetadata = new JSONObject();
            try {
                statsMetadata.put("sId", prefHelper_.getSessionID());
                statsMetadata.put("status", 200);
            } catch (Exception je) {
                DNALogger.e("DeviceNativeAds: Unable to create stats metadata");
            }
            long endTime = System.currentTimeMillis();
            DNAStatsLogger.logInternal(context_.get(), "Stats Sync", (int)(endTime - startTime), statsMetadata);
        } catch (Exception ex) {
            DNALogger.e("DNANetworkRequestStats: " + ex.getMessage());
        }
    }

    @Override
    public void handleFailure(int statusCode, String causeMsg) {
        DNALogger.e("DNANetworkRequestStats: handleFailure: " + statusCode + " : " + causeMsg);
        DNAPreferences prefs = DNAPreferences.getInstance(context_.get());
        JSONObject statsMetadata = new JSONObject();
        try {
            statsMetadata.put("sId", prefs.getSessionID());
            statsMetadata.put("loc", "DNANetworkRequestStats.handleFailure");
            statsMetadata.put("m", causeMsg);
        } catch (Exception je) {
            DNALogger.e("DeviceNativeAds: Unable to create stats metadata");
        }
        DNAStatsLogger.logInternal(context_.get(), "Error", statusCode, statsMetadata);
    }

    @Override
    public boolean isGetRequest() {
        return false;
    }

}
