package com.devicenative.dna.datasource.loader;

import android.content.Context;

import com.devicenative.dna.network.DNANetworkInterfaceHTTPConnection;
import com.devicenative.dna.network.DNANetworkRequest;
import com.devicenative.dna.network.DNANetworkResponse;
import com.devicenative.dna.utils.DNAError;
import com.devicenative.dna.utils.DNALogger;

import org.json.JSONObject;

public class DNAServerPOSTLoader extends DNALoader {
    private final DNANetworkRequest request_;
    public DNAServerPOSTLoader(Context context, DNANetworkRequest request) {
        super(context);
        request_ = request;
    }

    @Override
    public void run() {
        long start = System.currentTimeMillis();

        request_.onPreExecute();

        DNANetworkInterfaceHTTPConnection httpConn = new DNANetworkInterfaceHTTPConnection();
        DNANetworkResponse response = httpConn.executePost(request_.getPost(), request_.getRequestUrl());

        if (response.getStatusCode() == 200) {
            try {
                JSONObject body = response.getBody();
                if (body.has("success") && !body.getBoolean("success")) {
                    request_.handleFailure(DNAError.ERR_DNA_INVALID_REQUEST, body.getString("message"));
                } else {
                    request_.onRequestSucceeded(response);
                }
            } catch (Exception e) {
                DNALogger.e("DNAServerPOSTLoader: " + e.getMessage());
                request_.handleFailure(DNAError.ERR_DNA_INVALID_REQUEST, "No success or message fields in response. Something went wrong on the server.");
            }
        } else {
            request_.handleFailure(response.getStatusCode(), response.getMessage());
        }

        long end = System.currentTimeMillis();
        DNALogger.i("DNAServerPOSTLoader: " + (end - start) + " milliseconds to complete network request");

        runnableFinished();
    }
}
