package com.devicenative.dna.datasource.loader;

import android.content.Context;
import java.lang.ref.WeakReference;

import com.devicenative.dna.datasource.DNADataSource;

public abstract class DNALoader implements Runnable {
    final WeakReference<Context> context;

    private WeakReference<DNADataSource> dataSource;

    DNALoader(Context context) {
        super();
        this.context = new WeakReference<>(context);
    }


    public void setProvider(DNADataSource source) {
        this.dataSource = new WeakReference<>(source);
    }

    public void runnableFinished() {
        if (dataSource != null) {
            dataSource.get().loadingComplete();
        }
    }
}
