/*
 * Decompiled with CFR 0.152.
 */
package com.developer.bsince.log;

import android.util.Log;
import com.developer.bsince.log.ILog;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AndroidLogger
implements ILog.TagLog {
    private static final int MAX_LOG_LENGTH = 4000;
    private static final Pattern ANONYMOUS_CLASS = Pattern.compile("\\$\\d+$");
    private static final ThreadLocal<String> NEXT_TAG = new ThreadLocal();

    private static String createTag() {
        String tag = NEXT_TAG.get();
        if (tag != null) {
            NEXT_TAG.remove();
            return tag;
        }
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        if (stackTrace.length < 6) {
            throw new IllegalStateException("Synthetic stacktrace didn't have enough elements: are you using proguard?");
        }
        tag = stackTrace[5].getClassName();
        Matcher m = ANONYMOUS_CLASS.matcher(tag);
        if (m.find()) {
            tag = m.replaceAll("");
        }
        return tag.substring(tag.lastIndexOf(46) + 1);
    }

    static String formatString(String message, Object ... args) {
        return args.length == 0 ? message : String.format(message, args);
    }

    @Override
    public void v(String message, Object ... args) {
        this.printLog(2, AndroidLogger.formatString(message, args), null);
    }

    @Override
    public void v(Throwable t, String message, Object ... args) {
        this.printLog(2, AndroidLogger.formatString(message, args), t);
    }

    @Override
    public void d(String message, Object ... args) {
        this.printLog(3, AndroidLogger.formatString(message, args), null);
    }

    @Override
    public void d(Throwable t, String message, Object ... args) {
        this.printLog(3, AndroidLogger.formatString(message, args), t);
    }

    @Override
    public void i(String message, Object ... args) {
        this.printLog(4, AndroidLogger.formatString(message, args), null);
    }

    @Override
    public void i(Throwable t, String message, Object ... args) {
        this.printLog(4, AndroidLogger.formatString(message, args), t);
    }

    @Override
    public void w(String message, Object ... args) {
        this.printLog(5, AndroidLogger.formatString(message, args), null);
    }

    @Override
    public void w(Throwable t, String message, Object ... args) {
        this.printLog(5, AndroidLogger.formatString(message, args), t);
    }

    @Override
    public void e(String message, Object ... args) {
        this.printLog(6, AndroidLogger.formatString(message, args), null);
    }

    @Override
    public void e(Throwable t, String message, Object ... args) {
        this.printLog(6, AndroidLogger.formatString(message, args), t);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void printLog(int priority, String message, Throwable t) {
        if (message == null || message.length() == 0) {
            if (t == null) return;
            message = Log.getStackTraceString((Throwable)t);
        } else if (t != null) {
            message = message + "\n" + Log.getStackTraceString((Throwable)t);
        }
        String tag = AndroidLogger.createTag();
        if (message.length() < 4000) {
            Log.println((int)priority, (String)tag, (String)message);
            return;
        }
        int length = message.length();
        for (int i = 0; i < length; ++i) {
            int end;
            int newline = message.indexOf(10, i);
            newline = newline != -1 ? newline : length;
            do {
                end = Math.min(newline, i + 4000);
                Log.println((int)priority, (String)tag, (String)message.substring(i, end));
            } while ((i = end) < newline);
        }
    }

    @Override
    public void tag(String tag) {
        NEXT_TAG.set(tag);
    }
}

