/*
 * Decompiled with CFR 0.152.
 */
package com.devdoo.rxpermissions;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import com.devdoo.rxpermissions.Permission;
import com.devdoo.rxpermissions.PermissionUtils;
import com.devdoo.rxpermissions.Permissions;
import com.devdoo.rxpermissions.RxPermission$$Lambda$1;
import com.devdoo.rxpermissions.RxPermission$$Lambda$4;
import com.devdoo.rxpermissions.RxPermission$$Lambda$5;
import com.devdoo.rxpermissions.RxPermission$$Lambda$6;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import rx.Observable;
import rx.subjects.PublishSubject;

@TargetApi(value=11)
public class RxPermission
extends Fragment {
    public static final String NO_PERMISSONS_EXCEPTION = "RxPermissions request requires at least one input permission";
    private static final String TAG = RxPermission.class.getSimpleName();
    private static final int REQUEST_PERMISSIONS_CODE = 10;
    private PublishSubject<Boolean> attachedSubject;
    private Map<String, PublishSubject<Permission>> mSubjects = new HashMap<String, PublishSubject<Permission>>();

    public RxPermission() {
        this.attachedSubject = PublishSubject.create();
    }

    public static RxPermission with(FragmentManager fragmentManager) {
        RxPermission rxPermission = (RxPermission)fragmentManager.findFragmentByTag(TAG);
        if (rxPermission == null) {
            rxPermission = new RxPermission();
            fragmentManager.beginTransaction().add((Fragment)rxPermission, TAG).commit();
        }
        return rxPermission;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setRetainInstance(true);
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        this.attachedSubject.onNext((Object)true);
        this.attachedSubject.onCompleted();
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.attachedSubject.onNext((Object)true);
        this.attachedSubject.onCompleted();
    }

    @TargetApi(value=23)
    public void requestPermission(String ... permissions) {
        this.requestPermissions(permissions, 10);
    }

    public Observable<Permission> requestEach(String ... permissions) {
        if (permissions == null || permissions.length == 0) {
            throw new IllegalArgumentException(NO_PERMISSONS_EXCEPTION);
        }
        if (!this.isAdded()) {
            return this.attachedSubject.flatMap(RxPermission$$Lambda$1.lambdaFactory$(this, permissions));
        }
        return this.createRequestEach(permissions);
    }

    private Observable<Permission> createRequestEach(String[] permissionArray) {
        Permissions permissions = this.toPermission(permissionArray);
        return this.createPermissionRequest(permissions.getDenied()).mergeWith(Observable.from(permissions.getGranted()));
    }

    public Observable<Boolean> request(String ... permission) {
        if (permission == null || permission.length == 0) {
            throw new IllegalArgumentException(NO_PERMISSONS_EXCEPTION);
        }
        if (!this.isAdded()) {
            return this.attachedSubject.flatMap(RxPermission$$Lambda$4.lambdaFactory$(this, permission));
        }
        return this.createRequest(permission);
    }

    private Observable<Boolean> createRequest(String ... permissionArray) {
        Permissions permissions = this.toPermission(permissionArray);
        return this.createPermissionRequest(permissions.getDenied()).mergeWith(Observable.from(permissions.getGranted())).toList().map(RxPermission$$Lambda$5.lambdaFactory$());
    }

    @TargetApi(value=23)
    private Observable<Permission> createPermissionRequest(List<Permission> permissions) {
        ArrayList<PublishSubject> list = new ArrayList<PublishSubject>(permissions.size());
        ArrayList<String> unrequestedPermissions = new ArrayList<String>();
        for (Permission permission : permissions) {
            PublishSubject subject = this.mSubjects.get(permission.name);
            if (subject == null) {
                subject = PublishSubject.create();
                this.mSubjects.put(permission.name, (PublishSubject<Permission>)subject);
                unrequestedPermissions.add(permission.name);
            }
            list.add(subject);
        }
        if (!unrequestedPermissions.isEmpty()) {
            this.requestPermission(unrequestedPermissions.toArray(new String[1]));
        }
        if (this.isAdded()) {
            return Observable.concat((Observable)Observable.from(list));
        }
        return this.attachedSubject.flatMap(RxPermission$$Lambda$6.lambdaFactory$(list));
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        int size = permissions.length;
        for (int i = 0; i < size; ++i) {
            PublishSubject<Permission> subject = this.mSubjects.get(permissions[i]);
            if (subject == null) {
                return;
            }
            this.mSubjects.remove(permissions[i]);
            boolean granted = grantResults[i] == 0;
            subject.onNext((Object)new Permission(permissions[i], granted));
            subject.onCompleted();
        }
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
    }

    private Permissions toPermission(String[] permissionArray) {
        if (PermissionUtils.isMarshmallow()) {
            return PermissionUtils.toPermissions(this.getContext(), permissionArray);
        }
        return PermissionUtils.toPermissions(permissionArray);
    }

    private static /* synthetic */ Observable lambda$createPermissionRequest$3(List list, Boolean isAttached) {
        return Observable.concat((Observable)Observable.from((Iterable)list));
    }

    private static /* synthetic */ Boolean lambda$createRequest$2(List permissionList) {
        for (Permission p : permissionList) {
            if (p.isGranted) continue;
            return false;
        }
        return true;
    }

    private /* synthetic */ Observable lambda$request$1(String[] stringArray, Boolean isAttached) {
        return this.createRequest(stringArray);
    }

    private /* synthetic */ Observable lambda$requestEach$0(String[] stringArray, Boolean isAttached) {
        return this.createRequestEach(stringArray);
    }

    static /* synthetic */ Observable access$lambda$0(RxPermission rxPermission, String[] stringArray, Boolean bl) {
        return rxPermission.lambda$requestEach$0(stringArray, bl);
    }

    static /* synthetic */ Observable access$lambda$1(RxPermission rxPermission, String[] stringArray, Boolean bl) {
        return rxPermission.lambda$request$1(stringArray, bl);
    }

    static /* synthetic */ Boolean access$lambda$2(List list) {
        return RxPermission.lambda$createRequest$2(list);
    }

    static /* synthetic */ Observable access$lambda$3(List list, Boolean bl) {
        return RxPermission.lambda$createPermissionRequest$3(list, bl);
    }
}

