/*
 * Decompiled with CFR 0.152.
 */
package com.devdoo.rxpermissions;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import com.devdoo.rxpermissions.Permission;
import com.devdoo.rxpermissions.Permissions;

public class PermissionUtils {
    public static boolean isMarshmallow() {
        return Build.VERSION.SDK_INT >= 23;
    }

    @TargetApi(value=23)
    public static Permissions toPermissions(Context context, String ... permissions) {
        Permissions perms = new Permissions();
        for (String permission : permissions) {
            if (context.checkSelfPermission(permission) == 0) {
                perms.addGranted(new Permission(permission, true));
                continue;
            }
            perms.addDenied(new Permission(permission, false));
        }
        return perms;
    }

    public static Permissions toPermissions(String ... permissions) {
        Permissions perms = new Permissions();
        for (String permission : permissions) {
            perms.addGranted(new Permission(permission, true));
        }
        return perms;
    }
}

