/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.fallback;

import android.net.Uri;
import androidx.annotation.OptIn;
import androidx.media3.common.MediaItem;
import androidx.media3.common.Timeline;
import androidx.media3.common.util.UnstableApi;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0017\u001a\u00020\u0018H\u0016J \u0010\n\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u0005H\u0016J\b\u0010\u001b\u001a\u00020\u0018H\u0016J \u0010\u0014\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020!2\u0006\u0010\u001c\u001a\u00020\u0018H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u001b\u0010\u0012\u001a\u00020\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\r\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006#"}, d2={"Lcom/devbrackets/android/exomedia/fallback/FallbackTimeline;", "Landroidx/media3/common/Timeline;", "mediaUri", "Landroid/net/Uri;", "mediaDurationUs", "", "<init>", "(Landroid/net/Uri;J)V", "window", "Landroidx/media3/common/Timeline$Window;", "getWindow", "()Landroidx/media3/common/Timeline$Window;", "window$delegate", "Lkotlin/Lazy;", "periodUid", "Ljava/util/UUID;", "kotlin.jvm.PlatformType", "Ljava/util/UUID;", "period", "Landroidx/media3/common/Timeline$Period;", "getPeriod", "()Landroidx/media3/common/Timeline$Period;", "period$delegate", "getWindowCount", "", "windowIndex", "defaultPositionProjectionUs", "getPeriodCount", "periodIndex", "setIds", "", "getIndexOfPeriod", "uid", "", "getUidOfPeriod", "library_release"})
@OptIn(markerClass={UnstableApi.class})
public final class FallbackTimeline
extends Timeline {
    @NotNull
    private final Uri mediaUri;
    private final long mediaDurationUs;
    @NotNull
    private final Lazy window$delegate;
    private final UUID periodUid;
    @NotNull
    private final Lazy period$delegate;

    public FallbackTimeline(@NotNull Uri mediaUri, long mediaDurationUs) {
        Intrinsics.checkNotNullParameter((Object)mediaUri, (String)"mediaUri");
        this.mediaUri = mediaUri;
        this.mediaDurationUs = mediaDurationUs;
        this.window$delegate = LazyKt.lazy(() -> FallbackTimeline.window_delegate$lambda$1(this));
        this.periodUid = UUID.randomUUID();
        this.period$delegate = LazyKt.lazy(() -> FallbackTimeline.period_delegate$lambda$3(this));
    }

    private final Timeline.Window getWindow() {
        Lazy lazy = this.window$delegate;
        return (Timeline.Window)lazy.getValue();
    }

    private final Timeline.Period getPeriod() {
        Lazy lazy = this.period$delegate;
        return (Timeline.Period)lazy.getValue();
    }

    public int getWindowCount() {
        return 1;
    }

    @NotNull
    public Timeline.Window getWindow(int windowIndex, @NotNull Timeline.Window window, long defaultPositionProjectionUs) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        return window;
    }

    public int getPeriodCount() {
        return 1;
    }

    @NotNull
    public Timeline.Period getPeriod(int periodIndex, @NotNull Timeline.Period period, boolean setIds) {
        Intrinsics.checkNotNullParameter((Object)period, (String)"period");
        return period;
    }

    public int getIndexOfPeriod(@NotNull Object uid) {
        Intrinsics.checkNotNullParameter((Object)uid, (String)"uid");
        return Intrinsics.areEqual((Object)uid, (Object)this.periodUid) ? 0 : -1;
    }

    @NotNull
    public Object getUidOfPeriod(int periodIndex) {
        UUID uUID = this.periodUid;
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"periodUid");
        return uUID;
    }

    private static final Timeline.Window window_delegate$lambda$1(FallbackTimeline this$0) {
        Timeline.Window window;
        Timeline.Window $this$window_delegate_u24lambda_u241_u24lambda_u240 = window = new Timeline.Window();
        boolean bl = false;
        $this$window_delegate_u24lambda_u241_u24lambda_u240.set(Timeline.Window.SINGLE_WINDOW_UID, MediaItem.fromUri((Uri)this$0.mediaUri), null, -9223372036854775807L, -9223372036854775807L, -9223372036854775807L, true, false, null, 0L, this$0.mediaDurationUs, 0, 0, 0L);
        return window;
    }

    private static final Timeline.Period period_delegate$lambda$3(FallbackTimeline this$0) {
        Timeline.Period period;
        Timeline.Period $this$period_delegate_u24lambda_u243_u24lambda_u242 = period = new Timeline.Period();
        boolean bl = false;
        $this$period_delegate_u24lambda_u243_u24lambda_u242.set((Object)this$0.periodUid, (Object)this$0.periodUid, 0, $this$period_delegate_u24lambda_u243_u24lambda_u242.durationUs, 0L);
        return period;
    }
}

