/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.core.video.layout;

import android.content.Context;
import android.util.AttributeSet;
import android.util.Size;
import android.view.View;
import android.widget.FrameLayout;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\t\u0018\u00002\u00020\u0001B\u001d\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0014J\u001e\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aJ\u0018\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J\u0018\u0010\u001c\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J\u0018\u0010\u001d\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J\u0018\u0010\u001e\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J\u0018\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u0014H\u0002J\b\u0010\"\u001a\u00020\u0012H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006#"}, d2={"Lcom/devbrackets/android/exomedia/core/video/layout/AspectRatioLayout;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "ratioSize", "Landroid/util/Size;", "value", "", "honorAspectRatio", "getHonorAspectRatio", "()Z", "setHonorAspectRatio", "(Z)V", "onMeasure", "", "widthMeasureSpec", "", "heightMeasureSpec", "setAspectRatio", "width", "height", "pixelWidthHeightRatio", "", "measureExact", "measureExactWidth", "measureExactHeight", "measureDefault", "coerceSize", "size", "measureSpec", "refreshLayout", "library_release"})
public final class AspectRatioLayout
extends FrameLayout {
    @NotNull
    private Size ratioSize;
    private boolean honorAspectRatio;

    @JvmOverloads
    public AspectRatioLayout(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        this.ratioSize = new Size(0, 0);
    }

    public /* synthetic */ AspectRatioLayout(Context context, AttributeSet attributeSet, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            attributeSet = null;
        }
        this(context, attributeSet);
    }

    public final boolean getHonorAspectRatio() {
        return this.honorAspectRatio;
    }

    public final void setHonorAspectRatio(boolean value) {
        this.honorAspectRatio = value;
        this.refreshLayout();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (!this.honorAspectRatio || this.ratioSize.getWidth() <= 0 || this.ratioSize.getHeight() <= 0) {
            return;
        }
        int widthSpecMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightSpecMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        Size size = widthSpecMode == 0x40000000 && heightSpecMode == 0x40000000 ? this.measureExact(widthMeasureSpec, heightMeasureSpec) : (widthSpecMode == 0x40000000 ? this.measureExactWidth(widthMeasureSpec, heightMeasureSpec) : (heightSpecMode == 0x40000000 ? this.measureExactHeight(widthMeasureSpec, heightMeasureSpec) : this.measureDefault(widthMeasureSpec, heightMeasureSpec)));
        int newWidthSpec = View.MeasureSpec.makeMeasureSpec((int)size.getWidth(), (int)0x40000000);
        int newHeightSpec = View.MeasureSpec.makeMeasureSpec((int)size.getHeight(), (int)0x40000000);
        super.onMeasure(newWidthSpec, newHeightSpec);
    }

    public final void setAspectRatio(int width, int height, float pixelWidthHeightRatio) {
        this.ratioSize = new Size((int)((float)width * pixelWidthHeightRatio), height);
        this.refreshLayout();
    }

    private final Size measureExact(int widthMeasureSpec, int heightMeasureSpec) {
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int widthByRatio = height * this.ratioSize.getWidth() / this.ratioSize.getHeight();
        int heightByRatio = width * this.ratioSize.getHeight() / this.ratioSize.getWidth();
        if (widthByRatio > width) {
            return new Size(width, heightByRatio);
        }
        return new Size(widthByRatio, height);
    }

    private final Size measureExactWidth(int widthMeasureSpec, int heightMeasureSpec) {
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int height = this.coerceSize(width * this.ratioSize.getHeight() / this.ratioSize.getWidth(), heightMeasureSpec);
        return new Size(width, height);
    }

    private final Size measureExactHeight(int widthMeasureSpec, int heightMeasureSpec) {
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int width = this.coerceSize(height * this.ratioSize.getWidth() / this.ratioSize.getHeight(), widthMeasureSpec);
        return new Size(width, height);
    }

    private final Size measureDefault(int widthMeasureSpec, int heightMeasureSpec) {
        int width = this.ratioSize.getWidth();
        int height = this.ratioSize.getHeight();
        if (View.MeasureSpec.getMode((int)heightMeasureSpec) == Integer.MIN_VALUE && height > View.MeasureSpec.getSize((int)heightMeasureSpec)) {
            height = View.MeasureSpec.getSize((int)heightMeasureSpec);
            width = height * this.ratioSize.getWidth() / this.ratioSize.getHeight();
        }
        if (View.MeasureSpec.getMode((int)widthMeasureSpec) == Integer.MIN_VALUE && width > View.MeasureSpec.getSize((int)widthMeasureSpec)) {
            width = View.MeasureSpec.getSize((int)widthMeasureSpec);
            height = width * this.ratioSize.getHeight() / this.ratioSize.getWidth();
        }
        return new Size(width, height);
    }

    private final int coerceSize(int size, int measureSpec) {
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        if (View.MeasureSpec.getMode((int)measureSpec) == Integer.MIN_VALUE && size > specSize) {
            return specSize;
        }
        return size;
    }

    private final void refreshLayout() {
        if (!this.isInLayout()) {
            this.requestLayout();
        }
    }

    @JvmOverloads
    public AspectRatioLayout(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 2, null);
    }
}

