/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.core.audio;

import android.net.Uri;
import androidx.annotation.IntRange;
import androidx.media3.common.AudioAttributes;
import androidx.media3.common.Timeline;
import androidx.media3.common.TrackSelectionParameters;
import androidx.media3.exoplayer.drm.DrmSessionManagerProvider;
import androidx.media3.exoplayer.source.MediaSource;
import androidx.media3.exoplayer.source.TrackGroupArray;
import com.devbrackets.android.exomedia.core.ListenerMux;
import com.devbrackets.android.exomedia.core.audio.AudioPlayerApi;
import com.devbrackets.android.exomedia.core.audio.MediaItem;
import com.devbrackets.android.exomedia.core.listener.MetadataListener;
import com.devbrackets.android.exomedia.core.renderer.RendererType;
import com.devbrackets.android.exomedia.listener.OnBufferUpdateListener;
import com.devbrackets.android.exomedia.nmp.ExoMediaPlayerImpl;
import com.devbrackets.android.exomedia.nmp.config.PlayerConfig;
import com.devbrackets.android.exomedia.nmp.manager.window.WindowInfo;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0016\u0018\u00002\u00020\u0001:\u0001rB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010L\u001a\u00020M2\b\u0010N\u001a\u0004\u0018\u00010OH\u0016J\b\u0010P\u001a\u00020MH\u0016J\u0012\u0010Q\u001a\u00020M2\b\b\u0001\u0010R\u001a\u00020)H\u0016J\b\u0010S\u001a\u00020MH\u0016J\b\u0010T\u001a\u00020MH\u0016J\b\u0010U\u001a\u00020MH\u0016J\b\u0010V\u001a\u00020\u0019H\u0016J\b\u0010W\u001a\u00020MH\u0016J\u0010\u0010X\u001a\u00020\u00192\u0006\u0010Y\u001a\u00020\u001fH\u0016J\u0010\u0010Z\u001a\u00020\u00192\u0006\u0010[\u001a\u00020\u001fH\u0016J\u0010\u0010\\\u001a\u00020M2\u0006\u0010]\u001a\u00020^H\u0016J\u0010\u0010_\u001a\u00020M2\u0006\u0010`\u001a\u00020/H\u0016J\b\u0010a\u001a\u00020\u0019H\u0016J\u0010\u0010b\u001a\u00020M2\u0006\u0010c\u001a\u00020dH\u0016J \u0010e\u001a\u00020M2\u0006\u0010f\u001a\u00020B2\u0006\u0010g\u001a\u00020/2\u0006\u0010h\u001a\u00020/H\u0016J\u0018\u0010i\u001a\u00020/2\u0006\u0010f\u001a\u00020B2\u0006\u0010g\u001a\u00020/H\u0016J\u0010\u0010j\u001a\u00020M2\u0006\u0010f\u001a\u00020BH\u0016J\u0018\u0010k\u001a\u00020M2\u0006\u0010f\u001a\u00020B2\u0006\u0010l\u001a\u00020\u0019H\u0016J\u0010\u0010m\u001a\u00020\u00192\u0006\u0010f\u001a\u00020BH\u0016J\u0010\u0010n\u001a\u00020M2\u0006\u0010o\u001a\u00020\rH\u0016J\u0010\u0010p\u001a\u00020M2\u0006\u0010q\u001a\u00020/H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0012\u001a\u00060\u0013R\u00020\u0000X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0019X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR$\u0010 \u001a\u00020\u001f2\u0006\u0010\u001e\u001a\u00020\u001f8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0007R\u0014\u0010'\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u001bR\u0014\u0010(\u001a\u00020)8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u0014\u0010,\u001a\u00020)8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010+R\u0014\u0010.\u001a\u00020/8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u0016\u00102\u001a\u0004\u0018\u0001038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00105R\u0014\u00106\u001a\u0002078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u00109R\u0014\u0010:\u001a\u00020/8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b;\u00101R\u0014\u0010<\u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b=\u0010\"R\u0014\u0010>\u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b?\u0010\"R\"\u0010@\u001a\u0010\u0012\u0004\u0012\u00020B\u0012\u0004\u0012\u00020C\u0018\u00010A8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bD\u0010ER(\u0010G\u001a\u0004\u0018\u00010F2\b\u0010\u001e\u001a\u0004\u0018\u00010F8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bH\u0010I\"\u0004\bJ\u0010K\u00a8\u0006s"}, d2={"Lcom/devbrackets/android/exomedia/core/audio/ExoAudioPlayer;", "Lcom/devbrackets/android/exomedia/core/audio/AudioPlayerApi;", "config", "Lcom/devbrackets/android/exomedia/nmp/config/PlayerConfig;", "<init>", "(Lcom/devbrackets/android/exomedia/nmp/config/PlayerConfig;)V", "getConfig", "()Lcom/devbrackets/android/exomedia/nmp/config/PlayerConfig;", "corePlayer", "Lcom/devbrackets/android/exomedia/nmp/ExoMediaPlayerImpl;", "getCorePlayer", "()Lcom/devbrackets/android/exomedia/nmp/ExoMediaPlayerImpl;", "mux", "Lcom/devbrackets/android/exomedia/core/ListenerMux;", "getMux", "()Lcom/devbrackets/android/exomedia/core/ListenerMux;", "setMux", "(Lcom/devbrackets/android/exomedia/core/ListenerMux;)V", "internalListeners", "Lcom/devbrackets/android/exomedia/core/audio/ExoAudioPlayer$InternalListeners;", "getInternalListeners", "()Lcom/devbrackets/android/exomedia/core/audio/ExoAudioPlayer$InternalListeners;", "setInternalListeners", "(Lcom/devbrackets/android/exomedia/core/audio/ExoAudioPlayer$InternalListeners;)V", "playRequested", "", "getPlayRequested", "()Z", "setPlayRequested", "(Z)V", "value", "", "volume", "getVolume", "()F", "setVolume", "(F)V", "playerConfig", "getPlayerConfig", "isPlaying", "duration", "", "getDuration", "()J", "currentPosition", "getCurrentPosition", "bufferedPercent", "", "getBufferedPercent", "()I", "windowInfo", "Lcom/devbrackets/android/exomedia/nmp/manager/window/WindowInfo;", "getWindowInfo", "()Lcom/devbrackets/android/exomedia/nmp/manager/window/WindowInfo;", "timeline", "Landroidx/media3/common/Timeline;", "getTimeline", "()Landroidx/media3/common/Timeline;", "audioSessionId", "getAudioSessionId", "playbackSpeed", "getPlaybackSpeed", "playbackPitch", "getPlaybackPitch", "availableTracks", "", "Lcom/devbrackets/android/exomedia/core/renderer/RendererType;", "Landroidx/media3/exoplayer/source/TrackGroupArray;", "getAvailableTracks", "()Ljava/util/Map;", "Landroidx/media3/exoplayer/drm/DrmSessionManagerProvider;", "drmSessionManagerProvider", "getDrmSessionManagerProvider", "()Landroidx/media3/exoplayer/drm/DrmSessionManagerProvider;", "setDrmSessionManagerProvider", "(Landroidx/media3/exoplayer/drm/DrmSessionManagerProvider;)V", "setMedia", "", "mediaItem", "Lcom/devbrackets/android/exomedia/core/audio/MediaItem;", "reset", "seekTo", "milliseconds", "start", "pause", "stop", "restart", "release", "setPlaybackSpeed", "speed", "setPlaybackPitch", "pitch", "setAudioAttributes", "attributes", "Landroidx/media3/common/AudioAttributes;", "setWakeLevel", "levelAndFlags", "trackSelectionAvailable", "setTrackSelectionParameters", "parameters", "Landroidx/media3/common/TrackSelectionParameters;", "setSelectedTrack", "type", "groupIndex", "trackIndex", "getSelectedTrackIndex", "clearSelectedTracks", "setRendererEnabled", "enabled", "isRendererEnabled", "setListenerMux", "listenerMux", "setRepeatMode", "repeatMode", "InternalListeners", "library_release"})
public class ExoAudioPlayer
implements AudioPlayerApi {
    @NotNull
    private final PlayerConfig config;
    @NotNull
    private final ExoMediaPlayerImpl corePlayer;
    @Nullable
    private ListenerMux mux;
    @NotNull
    private InternalListeners internalListeners;
    private boolean playRequested;

    public ExoAudioPlayer(@NotNull PlayerConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        this.corePlayer = new ExoMediaPlayerImpl(this.config);
        this.internalListeners = new InternalListeners();
        this.corePlayer.setMetadataListener(this.internalListeners);
        this.corePlayer.setBufferUpdateListener(this.internalListeners);
    }

    @NotNull
    protected final PlayerConfig getConfig() {
        return this.config;
    }

    @NotNull
    protected final ExoMediaPlayerImpl getCorePlayer() {
        return this.corePlayer;
    }

    @Nullable
    protected final ListenerMux getMux() {
        return this.mux;
    }

    protected final void setMux(@Nullable ListenerMux listenerMux) {
        this.mux = listenerMux;
    }

    @NotNull
    protected final InternalListeners getInternalListeners() {
        return this.internalListeners;
    }

    protected final void setInternalListeners(@NotNull InternalListeners internalListeners) {
        Intrinsics.checkNotNullParameter((Object)internalListeners, (String)"<set-?>");
        this.internalListeners = internalListeners;
    }

    protected final boolean getPlayRequested() {
        return this.playRequested;
    }

    protected final void setPlayRequested(boolean bl) {
        this.playRequested = bl;
    }

    @Override
    public float getVolume() {
        return this.corePlayer.getVolume();
    }

    @Override
    public void setVolume(float value) {
        this.corePlayer.setVolume(value);
    }

    @Override
    @NotNull
    public PlayerConfig getPlayerConfig() {
        return this.config;
    }

    @Override
    public boolean isPlaying() {
        return this.corePlayer.getPlayWhenReady();
    }

    @Override
    public long getDuration() {
        ListenerMux listenerMux = this.mux;
        Intrinsics.checkNotNull((Object)listenerMux);
        return !listenerMux.isPrepared() ? 0L : this.corePlayer.getDuration();
    }

    @Override
    public long getCurrentPosition() {
        ListenerMux listenerMux = this.mux;
        Intrinsics.checkNotNull((Object)listenerMux);
        return !listenerMux.isPrepared() ? 0L : this.corePlayer.getCurrentPosition();
    }

    @Override
    public int getBufferedPercent() {
        return this.corePlayer.getBufferedPercent();
    }

    @Override
    @Nullable
    public WindowInfo getWindowInfo() {
        return this.corePlayer.getWindowInfo();
    }

    @Override
    @NotNull
    public Timeline getTimeline() {
        return this.corePlayer.getTimeline();
    }

    @Override
    public int getAudioSessionId() {
        return this.corePlayer.getAudioSessionId();
    }

    @Override
    public float getPlaybackSpeed() {
        return this.corePlayer.getPlaybackSpeed();
    }

    @Override
    public float getPlaybackPitch() {
        return this.corePlayer.getPlaybackPitch();
    }

    @Override
    @Nullable
    public Map<RendererType, TrackGroupArray> getAvailableTracks() {
        return this.corePlayer.getAvailableTracks();
    }

    @Override
    @Nullable
    public DrmSessionManagerProvider getDrmSessionManagerProvider() {
        return this.corePlayer.getDrmSessionManagerProvider();
    }

    @Override
    public void setDrmSessionManagerProvider(@Nullable DrmSessionManagerProvider value) {
        this.corePlayer.setDrmSessionManagerProvider(value);
    }

    @Override
    public void setMedia(@Nullable MediaItem mediaItem) {
        ListenerMux listenerMux = this.mux;
        if (listenerMux != null) {
            listenerMux.setNotifiedPrepared(false);
        }
        this.corePlayer.seekTo(0L);
        MediaItem mediaItem2 = mediaItem;
        if (mediaItem2 != null && (mediaItem2 = mediaItem2.getMediaSource()) != null) {
            MediaItem it = mediaItem2;
            boolean bl = false;
            this.corePlayer.setMediaSource((MediaSource)it);
            ListenerMux listenerMux2 = this.mux;
            if (listenerMux2 != null) {
                listenerMux2.setNotifiedCompleted(false);
            }
            this.corePlayer.prepare();
            return;
        }
        MediaItem mediaItem3 = mediaItem;
        if (mediaItem3 != null && (mediaItem3 = mediaItem3.getUri()) != null) {
            MediaItem it = mediaItem3;
            boolean bl = false;
            this.corePlayer.setMediaUri((Uri)it);
            ListenerMux listenerMux3 = this.mux;
            if (listenerMux3 != null) {
                listenerMux3.setNotifiedCompleted(false);
            }
            this.corePlayer.prepare();
            return;
        }
        this.corePlayer.setMediaSource(null);
    }

    @Override
    public void reset() {
    }

    @Override
    public void seekTo(@IntRange(from=0L) long milliseconds) {
        this.corePlayer.seekTo(milliseconds);
    }

    @Override
    public void start() {
        this.corePlayer.setPlayWhenReady(true);
        ListenerMux listenerMux = this.mux;
        if (listenerMux != null) {
            listenerMux.setNotifiedCompleted(false);
        }
        this.playRequested = true;
    }

    @Override
    public void pause() {
        this.corePlayer.setPlayWhenReady(false);
        this.playRequested = false;
    }

    @Override
    public void stop() {
        this.corePlayer.stop();
        this.playRequested = false;
    }

    @Override
    public boolean restart() {
        block2: {
            if (!this.corePlayer.restart()) {
                return false;
            }
            ListenerMux listenerMux = this.mux;
            if (listenerMux != null) {
                listenerMux.setNotifiedCompleted(false);
            }
            ListenerMux listenerMux2 = this.mux;
            if (listenerMux2 == null) break block2;
            listenerMux2.setNotifiedPrepared(false);
        }
        return true;
    }

    @Override
    public void release() {
        this.corePlayer.release();
    }

    @Override
    public boolean setPlaybackSpeed(float speed) {
        this.corePlayer.setPlaybackSpeed(speed);
        return true;
    }

    @Override
    public boolean setPlaybackPitch(float pitch) {
        this.corePlayer.setPlaybackPitch(pitch);
        return true;
    }

    @Override
    public void setAudioAttributes(@NotNull AudioAttributes attributes) {
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        this.corePlayer.setAudioAttributes(attributes);
    }

    @Override
    public void setWakeLevel(int levelAndFlags) {
        this.corePlayer.setWakeLevel(levelAndFlags);
    }

    @Override
    public boolean trackSelectionAvailable() {
        return true;
    }

    @Override
    public void setTrackSelectionParameters(@NotNull TrackSelectionParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        this.corePlayer.setTrackSelectionParameters(parameters);
    }

    @Override
    public void setSelectedTrack(@NotNull RendererType type, int groupIndex, int trackIndex) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.corePlayer.setSelectedTrack(type, groupIndex, trackIndex);
    }

    @Override
    public int getSelectedTrackIndex(@NotNull RendererType type, int groupIndex) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return this.corePlayer.getSelectedTrackIndex(type, groupIndex);
    }

    @Override
    public void clearSelectedTracks(@NotNull RendererType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.corePlayer.clearSelectedTracks(type);
    }

    @Override
    public void setRendererEnabled(@NotNull RendererType type, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.corePlayer.setRendererEnabled(type, enabled);
    }

    @Override
    public boolean isRendererEnabled(@NotNull RendererType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return this.corePlayer.isRendererEnabled(type);
    }

    @Override
    public void setListenerMux(@NotNull ListenerMux listenerMux) {
        Intrinsics.checkNotNullParameter((Object)listenerMux, (String)"listenerMux");
        ListenerMux listenerMux2 = this.mux;
        if (listenerMux2 != null) {
            ListenerMux oldListenerMux = listenerMux2;
            boolean bl = false;
            this.corePlayer.removeListener(oldListenerMux);
            this.corePlayer.removeAnalyticsListener(oldListenerMux);
        }
        this.mux = listenerMux;
        this.corePlayer.addListener(listenerMux);
        this.corePlayer.addAnalyticsListener(listenerMux);
    }

    @Override
    public void setRepeatMode(int repeatMode) {
        this.corePlayer.setRepeatMode(repeatMode);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0084\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u00020\u00062\b\b\u0001\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/devbrackets/android/exomedia/core/audio/ExoAudioPlayer$InternalListeners;", "Lcom/devbrackets/android/exomedia/core/listener/MetadataListener;", "Lcom/devbrackets/android/exomedia/listener/OnBufferUpdateListener;", "<init>", "(Lcom/devbrackets/android/exomedia/core/audio/ExoAudioPlayer;)V", "onMetadata", "", "metadata", "Landroidx/media3/common/Metadata;", "onBufferingUpdate", "percent", "", "library_release"})
    protected final class InternalListeners
    implements MetadataListener,
    OnBufferUpdateListener {
        @Override
        public void onMetadata(@NotNull androidx.media3.common.Metadata metadata) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
                ListenerMux listenerMux = ExoAudioPlayer.this.getMux();
                if (listenerMux == null) break block0;
                listenerMux.onMetadata(metadata);
            }
        }

        @Override
        public void onBufferingUpdate(@IntRange(from=0L, to=100L) int percent) {
            block0: {
                ListenerMux listenerMux = ExoAudioPlayer.this.getMux();
                if (listenerMux == null) break block0;
                listenerMux.onBufferingUpdate(percent);
            }
        }
    }
}

