/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.ui.widget.attr;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.Log;
import androidx.annotation.StyleableRes;
import com.devbrackets.android.exomedia.R;
import com.devbrackets.android.exomedia.core.video.scale.ScaleType;
import com.devbrackets.android.exomedia.nmp.config.PlayerConfigProvider;
import com.devbrackets.android.exomedia.ui.widget.attr.VideoViewAttributeParser;
import com.devbrackets.android.exomedia.ui.widget.attr.VideoViewAttributes;
import com.devbrackets.android.exomedia.ui.widget.controls.VideoControlsProvider;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ/\u0010\t\u001a\u0002H\n\"\u0004\b\u0000\u0010\n*\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\n0\u000fH\u0002\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0012"}, d2={"Lcom/devbrackets/android/exomedia/ui/widget/attr/VideoViewAttributeParser;", "", "()V", "parse", "Lcom/devbrackets/android/exomedia/ui/widget/attr/VideoViewAttributes;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "getOrDefault", "T", "Landroid/content/res/TypedArray;", "styleable", "", "default", "Lkotlin/Function0;", "(Landroid/content/res/TypedArray;ILkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "Companion", "library_release"})
public final class VideoViewAttributeParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String LOG_TAG = "VideoViewAttrParser";

    @NotNull
    public final VideoViewAttributes parse(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (attrs == null) {
            return new VideoViewAttributes(false, null, false, null, null, 31, null);
        }
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.VideoView);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"obtainStyledAttributes(...)");
        TypedArray typedArray2 = typedArray;
        boolean useTextureViewBacking = typedArray2.getBoolean(R.styleable.VideoView_useTextureViewBacking, false);
        ScaleType scaleType = typedArray2.hasValue(R.styleable.VideoView_videoScale) ? ScaleType.Companion.fromOrdinal(typedArray2.getInt(R.styleable.VideoView_videoScale, -1)) : null;
        boolean measureBasedOnAspectRatio = typedArray2.hasValue(R.styleable.VideoView_measureBasedOnAspectRatio) ? typedArray2.getBoolean(R.styleable.VideoView_measureBasedOnAspectRatio, false) : false;
        PlayerConfigProvider configProvider2 = (PlayerConfigProvider)this.getOrDefault(typedArray2, R.styleable.VideoView_playerConfigProvider, parse.configProvider.1.INSTANCE);
        VideoControlsProvider controlsProvider2 = (VideoControlsProvider)this.getOrDefault(typedArray2, R.styleable.VideoView_videoControlsProvider, parse.controlsProvider.1.INSTANCE);
        typedArray2.recycle();
        return new VideoViewAttributes(useTextureViewBacking, scaleType, measureBasedOnAspectRatio, configProvider2, controlsProvider2);
    }

    private final <T> T getOrDefault(TypedArray $this$getOrDefault, @StyleableRes int styleable2, Function0<? extends T> function0) {
        String className = $this$getOrDefault.getString(styleable2);
        Object object = className;
        if (object == null || StringsKt.isBlank((CharSequence)object)) {
            return (T)function0.invoke();
        }
        try {
            object = Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)("Unable to construct class for name " + className), (Throwable)e);
            object = function0.invoke();
        }
        return (T)object;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/devbrackets/android/exomedia/ui/widget/attr/VideoViewAttributeParser$Companion;", "", "()V", "LOG_TAG", "", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

