/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.core.video.surface;

import android.graphics.Point;
import android.util.Log;
import android.view.View;
import android.view.ViewTreeObserver;
import androidx.annotation.IntRange;
import com.devbrackets.android.exomedia.core.video.scale.MatrixManager;
import com.devbrackets.android.exomedia.core.video.scale.ScaleType;
import com.devbrackets.android.exomedia.core.video.surface.SurfaceEnvelope;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import javax.microedition.khronos.egl.EGL;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0003\b&\u0018\u0000 :*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u0005:\u0002:;B\u0015\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\"H\u0016J\b\u0010&\u001a\u00020\"H\u0016J\u0010\u0010'\u001a\u00020\"2\u0006\u0010(\u001a\u00020\u0002H\u0016J\u0010\u0010)\u001a\u00020\"2\u0006\u0010(\u001a\u00020\u0002H\u0016J\b\u0010*\u001a\u00020\"H\u0002J\b\u0010+\u001a\u00020\"H\u0016J\u0010\u0010,\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010-\u001a\u00020\"2\u0006\u0010.\u001a\u00020\u001cH\u0016J\u001a\u0010/\u001a\u00020\"2\b\b\u0001\u00100\u001a\u00020\u00132\u0006\u00101\u001a\u000202H\u0016J\u001a\u0010/\u001a\u00020\"2\b\b\u0001\u00103\u001a\u00020\u00132\b\b\u0001\u00104\u001a\u00020\u0013J\u0018\u00105\u001a\u0002022\u0006\u00106\u001a\u00020\u00132\u0006\u00107\u001a\u00020\u0013H\u0016J \u00105\u001a\u0002022\u0006\u00106\u001a\u00020\u00132\u0006\u00107\u001a\u00020\u00132\u0006\u00108\u001a\u000209H\u0016R\u0014\u0010\n\u001a\u00020\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u00020\u00138\u0004@\u0004X\u0085\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001e\u0010\u0018\u001a\u00020\u00138\u0004@\u0004X\u0085\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0015\"\u0004\b\u001a\u0010\u0017R\u0011\u0010\u001b\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0010\u0010\u0006\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001fR\u000e\u0010 \u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/devbrackets/android/exomedia/core/video/surface/BaseSurfaceEnvelope;", "T", "Landroid/view/View;", "Landroid/view/View$OnAttachStateChangeListener;", "Landroid/view/ViewTreeObserver$OnGlobalLayoutListener;", "Lcom/devbrackets/android/exomedia/core/video/surface/SurfaceEnvelope;", "surface", "matrixManager", "Lcom/devbrackets/android/exomedia/core/video/scale/MatrixManager;", "(Landroid/view/View;Lcom/devbrackets/android/exomedia/core/video/scale/MatrixManager;)V", "delegatingCallback", "Lcom/devbrackets/android/exomedia/core/video/surface/BaseSurfaceEnvelope$DelegatingCallback;", "getDelegatingCallback", "()Lcom/devbrackets/android/exomedia/core/video/surface/BaseSurfaceEnvelope$DelegatingCallback;", "globalLayoutMatrixListenerLock", "Ljava/util/concurrent/locks/ReentrantLock;", "lastNotifiedSize", "Landroid/graphics/Point;", "requestedConfigurationRotation", "", "getRequestedConfigurationRotation", "()I", "setRequestedConfigurationRotation", "(I)V", "requestedUserRotation", "getRequestedUserRotation", "setRequestedUserRotation", "scaleType", "Lcom/devbrackets/android/exomedia/core/video/scale/ScaleType;", "getScaleType", "()Lcom/devbrackets/android/exomedia/core/video/scale/ScaleType;", "Landroid/view/View;", "videoSize", "addCallback", "", "callback", "Lcom/devbrackets/android/exomedia/core/video/surface/SurfaceEnvelope$Callback;", "clearSurface", "onGlobalLayout", "onViewAttachedToWindow", "view", "onViewDetachedFromWindow", "registerStateAndLayoutListeners", "release", "removeCallback", "setScaleType", "type", "setVideoRotation", "rotation", "fromUser", "", "userRotation", "configurationRotation", "setVideoSize", "width", "height", "pixelWidthHeightRatio", "", "Companion", "DelegatingCallback", "library_release"})
public abstract class BaseSurfaceEnvelope<T extends View>
implements View.OnAttachStateChangeListener,
ViewTreeObserver.OnGlobalLayoutListener,
SurfaceEnvelope {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final T surface;
    @NotNull
    private final MatrixManager matrixManager;
    @NotNull
    private final DelegatingCallback delegatingCallback;
    @NotNull
    private Point lastNotifiedSize;
    @NotNull
    private Point videoSize;
    @NotNull
    private final ReentrantLock globalLayoutMatrixListenerLock;
    @IntRange(from=0L, to=359L)
    private int requestedUserRotation;
    @IntRange(from=0L, to=359L)
    private int requestedConfigurationRotation;
    private static final int MAX_DEGREES = 360;
    @NotNull
    private static final int[] GL_CLEAR_CONFIG_ATTRIBUTES;
    @NotNull
    private static final int[] GL_CLEAR_CONTEXT_ATTRIBUTES;

    public BaseSurfaceEnvelope(@NotNull T surface2, @NotNull MatrixManager matrixManager) {
        Intrinsics.checkNotNullParameter(surface2, (String)"surface");
        Intrinsics.checkNotNullParameter((Object)matrixManager, (String)"matrixManager");
        this.surface = surface2;
        this.matrixManager = matrixManager;
        this.delegatingCallback = new DelegatingCallback();
        this.lastNotifiedSize = new Point(0, 0);
        this.videoSize = new Point(0, 0);
        this.globalLayoutMatrixListenerLock = new ReentrantLock(true);
        this.registerStateAndLayoutListeners();
    }

    @NotNull
    protected final DelegatingCallback getDelegatingCallback() {
        return this.delegatingCallback;
    }

    protected final int getRequestedUserRotation() {
        return this.requestedUserRotation;
    }

    protected final void setRequestedUserRotation(int n) {
        this.requestedUserRotation = n;
    }

    protected final int getRequestedConfigurationRotation() {
        return this.requestedConfigurationRotation;
    }

    protected final void setRequestedConfigurationRotation(int n) {
        this.requestedConfigurationRotation = n;
    }

    @NotNull
    public final ScaleType getScaleType() {
        return this.matrixManager.getCurrentScaleType();
    }

    public void onViewAttachedToWindow(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        this.globalLayoutMatrixListenerLock.lock();
        this.surface.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        this.surface.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
        this.globalLayoutMatrixListenerLock.unlock();
    }

    public void onViewDetachedFromWindow(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
    }

    public void onGlobalLayout() {
        this.setScaleType(this.matrixManager.getCurrentScaleType());
    }

    @Override
    public void release() {
        this.surface.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        this.surface.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
    }

    @Override
    public void setScaleType(@NotNull ScaleType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.matrixManager.scale((View)this.surface, type);
    }

    @Override
    public void clearSurface() {
        try {
            EGL eGL = EGLContext.getEGL();
            Intrinsics.checkNotNull((Object)eGL, (String)"null cannot be cast to non-null type javax.microedition.khronos.egl.EGL10");
            EGL10 gl10 = (EGL10)eGL;
            EGLDisplay display = gl10.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
            gl10.eglInitialize(display, null);
            EGLConfig[] configs = new EGLConfig[1];
            gl10.eglChooseConfig(display, GL_CLEAR_CONFIG_ATTRIBUTES, configs, configs.length, new int[1]);
            EGLContext context = gl10.eglCreateContext(display, configs[0], EGL10.EGL_NO_CONTEXT, GL_CLEAR_CONTEXT_ATTRIBUTES);
            int[] nArray = new int[]{12344};
            EGLSurface eglSurface = gl10.eglCreateWindowSurface(display, configs[0], this.surface, nArray);
            gl10.eglMakeCurrent(display, eglSurface, eglSurface, context);
            gl10.eglSwapBuffers(display, eglSurface);
            gl10.eglDestroySurface(display, eglSurface);
            gl10.eglMakeCurrent(display, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
            gl10.eglDestroyContext(display, context);
            gl10.eglTerminate(display);
        }
        catch (Exception e) {
            Log.w((String)"BaseSurfaceEnvelope", (String)"Error clearing surface", (Throwable)e);
        }
    }

    @Override
    public boolean setVideoSize(int width, int height) {
        this.matrixManager.setIntrinsicVideoSize(width, height);
        this.videoSize.x = width;
        this.videoSize.y = height;
        return width != 0 && height != 0;
    }

    @Override
    public boolean setVideoSize(int width, int height, float pixelWidthHeightRatio) {
        return this.setVideoSize((int)((float)width * pixelWidthHeightRatio), height);
    }

    @Override
    public void setVideoRotation(@IntRange(from=0L, to=359L) int rotation, boolean fromUser) {
        if (fromUser) {
            this.setVideoRotation(rotation, this.requestedConfigurationRotation);
        } else {
            this.setVideoRotation(this.requestedUserRotation, rotation);
        }
    }

    @Override
    public void addCallback(@NotNull SurfaceEnvelope.Callback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.delegatingCallback.addCallback(callback);
    }

    @Override
    public void removeCallback(@NotNull SurfaceEnvelope.Callback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.delegatingCallback.removeCallback(callback);
    }

    public final void setVideoRotation(@IntRange(from=0L, to=359L) int userRotation, @IntRange(from=0L, to=359L) int configurationRotation) {
        this.requestedUserRotation = userRotation;
        this.requestedConfigurationRotation = configurationRotation;
        this.matrixManager.rotate((View)this.surface, (userRotation + configurationRotation) % 360);
    }

    private final void registerStateAndLayoutListeners() {
        this.globalLayoutMatrixListenerLock.lock();
        if (this.surface.getWindowToken() == null) {
            this.surface.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
        } else {
            this.surface.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
        this.globalLayoutMatrixListenerLock.unlock();
    }

    static {
        int[] nArray = new int[]{12324, 8, 12323, 8, 12322, 8, 12321, 8, 12352, 4, 12344, 0, 12344};
        GL_CLEAR_CONFIG_ATTRIBUTES = nArray;
        nArray = new int[]{12440, 2, 12344};
        GL_CLEAR_CONTEXT_ATTRIBUTES = nArray;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/devbrackets/android/exomedia/core/video/surface/BaseSurfaceEnvelope$Companion;", "", "()V", "GL_CLEAR_CONFIG_ATTRIBUTES", "", "GL_CLEAR_CONTEXT_ATTRIBUTES", "MAX_DEGREES", "", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0001J\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\f\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u000e\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0001R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/devbrackets/android/exomedia/core/video/surface/BaseSurfaceEnvelope$DelegatingCallback;", "Lcom/devbrackets/android/exomedia/core/video/surface/SurfaceEnvelope$Callback;", "()V", "callbacks", "", "addCallback", "", "callback", "onSurfaceAvailable", "envelope", "Lcom/devbrackets/android/exomedia/core/video/surface/SurfaceEnvelope;", "onSurfaceDestroyed", "onSurfaceSizeChanged", "width", "", "height", "removeCallback", "library_release"})
    @SourceDebugExtension(value={"SMAP\nBaseSurfaceEnvelope.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseSurfaceEnvelope.kt\ncom/devbrackets/android/exomedia/core/video/surface/BaseSurfaceEnvelope$DelegatingCallback\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,215:1\n1855#2,2:216\n1855#2,2:218\n1855#2,2:220\n*S KotlinDebug\n*F\n+ 1 BaseSurfaceEnvelope.kt\ncom/devbrackets/android/exomedia/core/video/surface/BaseSurfaceEnvelope$DelegatingCallback\n*L\n190#1:216,2\n196#1:218,2\n202#1:220,2\n*E\n"})
    protected static final class DelegatingCallback
    implements SurfaceEnvelope.Callback {
        @NotNull
        private final Set<SurfaceEnvelope.Callback> callbacks = new LinkedHashSet();

        @Override
        public void onSurfaceAvailable(@NotNull SurfaceEnvelope envelope) {
            Intrinsics.checkNotNullParameter((Object)envelope, (String)"envelope");
            Iterable $this$forEach$iv = this.callbacks;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SurfaceEnvelope.Callback callback = (SurfaceEnvelope.Callback)element$iv;
                boolean bl = false;
                callback.onSurfaceAvailable(envelope);
            }
        }

        @Override
        public void onSurfaceDestroyed(@NotNull SurfaceEnvelope envelope) {
            Intrinsics.checkNotNullParameter((Object)envelope, (String)"envelope");
            Iterable $this$forEach$iv = this.callbacks;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SurfaceEnvelope.Callback callback = (SurfaceEnvelope.Callback)element$iv;
                boolean bl = false;
                callback.onSurfaceDestroyed(envelope);
            }
        }

        @Override
        public void onSurfaceSizeChanged(@NotNull SurfaceEnvelope envelope, int width, int height) {
            Intrinsics.checkNotNullParameter((Object)envelope, (String)"envelope");
            Iterable $this$forEach$iv = this.callbacks;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SurfaceEnvelope.Callback callback = (SurfaceEnvelope.Callback)element$iv;
                boolean bl = false;
                callback.onSurfaceSizeChanged(envelope, width, height);
            }
        }

        public final void addCallback(@NotNull SurfaceEnvelope.Callback callback) {
            Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
            this.callbacks.add(callback);
        }

        public final void removeCallback(@NotNull SurfaceEnvelope.Callback callback) {
            Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
            this.callbacks.remove(callback);
        }
    }
}

