/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.core.source;

import android.net.Uri;
import androidx.media3.exoplayer.source.MediaSource;
import com.devbrackets.android.exomedia.core.source.builder.DashMediaSourceBuilder;
import com.devbrackets.android.exomedia.core.source.builder.DefaultMediaSourceBuilder;
import com.devbrackets.android.exomedia.core.source.builder.HlsMediaSourceBuilder;
import com.devbrackets.android.exomedia.core.source.builder.MediaSourceBuilder;
import com.devbrackets.android.exomedia.core.source.builder.SsMediaSourceBuilder;
import com.devbrackets.android.exomedia.util.UriExtensionsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\nH\u0004J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\nH\u0004J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\nH\u0004J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\nH\u0004J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/devbrackets/android/exomedia/core/source/MediaSourceProvider;", "", "()V", "builders", "", "Lcom/devbrackets/android/exomedia/core/source/MediaSourceProvider$SourceTypeBuilder;", "getBuilders", "()Ljava/util/List;", "findByExtension", "uri", "Landroid/net/Uri;", "findByLooseComparison", "findByProviders", "findByScheme", "generate", "Landroidx/media3/exoplayer/source/MediaSource;", "attributes", "Lcom/devbrackets/android/exomedia/core/source/builder/MediaSourceBuilder$MediaSourceAttributes;", "SourceTypeBuilder", "library_release"})
@SourceDebugExtension(value={"SMAP\nMediaSourceProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MediaSourceProvider.kt\ncom/devbrackets/android/exomedia/core/source/MediaSourceProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,67:1\n1#2:68\n288#3,2:69\n288#3,2:71\n288#3,2:73\n*S KotlinDebug\n*F\n+ 1 MediaSourceProvider.kt\ncom/devbrackets/android/exomedia/core/source/MediaSourceProvider\n*L\n54#1:69,2\n59#1:71,2\n64#1:73,2\n*E\n"})
public class MediaSourceProvider {
    @NotNull
    private final List<SourceTypeBuilder> builders;

    public MediaSourceProvider() {
        Object[] objectArray = new SourceTypeBuilder[]{new SourceTypeBuilder(new HlsMediaSourceBuilder(), null, ".m3u8", ".*\\.m3u8.*"), new SourceTypeBuilder(new DashMediaSourceBuilder(), null, ".mpd", ".*\\.mpd.*"), new SourceTypeBuilder(new SsMediaSourceBuilder(), null, ".ism", ".*\\.ism.*")};
        this.builders = CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    protected final List<SourceTypeBuilder> getBuilders() {
        return this.builders;
    }

    @NotNull
    public List<SourceTypeBuilder> builders() {
        return this.builders;
    }

    @NotNull
    public final MediaSource generate(@NotNull MediaSourceBuilder.MediaSourceAttributes attributes) {
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        SourceTypeBuilder sourceTypeBuilder = this.findByProviders(attributes.getUri());
        Object object = sourceTypeBuilder;
        if (object == null || (object = ((SourceTypeBuilder)object).getBuilder()) == null) {
            object = new DefaultMediaSourceBuilder();
        }
        Object builder = object;
        return ((MediaSourceBuilder)builder).build(attributes);
    }

    @Nullable
    protected final SourceTypeBuilder findByProviders(@NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        SourceTypeBuilder sourceTypeBuilder = this.findByScheme(uri);
        if (sourceTypeBuilder == null && (sourceTypeBuilder = this.findByExtension(uri)) == null) {
            sourceTypeBuilder = this.findByLooseComparison(uri);
        }
        return sourceTypeBuilder;
    }

    @Nullable
    protected final SourceTypeBuilder findByScheme(@NotNull Uri uri) {
        Object v1;
        block4: {
            Object it;
            String string;
            block6: {
                block5: {
                    Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
                    string = uri.getScheme();
                    if (string == null) break block5;
                    String string2 = string;
                    it = string2;
                    boolean bl = false;
                    string = ((CharSequence)it).length() > 0 ? string2 : null;
                    if (string != null) break block6;
                }
                return null;
            }
            String scheme = string;
            Iterable $this$firstOrNull$iv = this.builders();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                it = (SourceTypeBuilder)element$iv;
                boolean bl = false;
                if (!StringsKt.equals((String)((SourceTypeBuilder)it).getUriScheme(), (String)scheme, (boolean)true)) continue;
                v1 = element$iv;
                break block4;
            }
            v1 = null;
        }
        return v1;
    }

    @Nullable
    protected final SourceTypeBuilder findByExtension(@NotNull Uri uri) {
        Object v1;
        block2: {
            String string;
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            String it = string = UriExtensionsKt.getExtension(uri);
            boolean bl = false;
            String string2 = ((CharSequence)it).length() > 0 ? string : null;
            if (string2 == null) {
                return null;
            }
            String extension = string2;
            Iterable $this$firstOrNull$iv = this.builders();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                SourceTypeBuilder it2 = (SourceTypeBuilder)element$iv;
                boolean bl2 = false;
                if (!StringsKt.equals((String)it2.getExtension(), (String)extension, (boolean)true)) continue;
                v1 = element$iv;
                break block2;
            }
            v1 = null;
        }
        return v1;
    }

    @Nullable
    protected final SourceTypeBuilder findByLooseComparison(@NotNull Uri uri) {
        Object v2;
        block1: {
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            String string = uri.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String uriString = string;
            Iterable $this$firstOrNull$iv = this.builders();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                SourceTypeBuilder it = (SourceTypeBuilder)element$iv;
                boolean bl = false;
                String string2 = it.getLooseComparisonRegex();
                boolean bl2 = string2 != null ? new Regex(string2).matches((CharSequence)uriString) : false;
                if (!bl2) continue;
                v2 = element$iv;
                break block1;
            }
            v2 = null;
        }
        return v2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J7\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u001a"}, d2={"Lcom/devbrackets/android/exomedia/core/source/MediaSourceProvider$SourceTypeBuilder;", "", "builder", "Lcom/devbrackets/android/exomedia/core/source/builder/MediaSourceBuilder;", "uriScheme", "", "extension", "looseComparisonRegex", "(Lcom/devbrackets/android/exomedia/core/source/builder/MediaSourceBuilder;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getBuilder", "()Lcom/devbrackets/android/exomedia/core/source/builder/MediaSourceBuilder;", "getExtension", "()Ljava/lang/String;", "getLooseComparisonRegex", "getUriScheme", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "library_release"})
    public static final class SourceTypeBuilder {
        @NotNull
        private final MediaSourceBuilder builder;
        @Nullable
        private final String uriScheme;
        @Nullable
        private final String extension;
        @Nullable
        private final String looseComparisonRegex;

        public SourceTypeBuilder(@NotNull MediaSourceBuilder builder, @Nullable String uriScheme, @Nullable String extension, @Nullable String looseComparisonRegex) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            this.builder = builder;
            this.uriScheme = uriScheme;
            this.extension = extension;
            this.looseComparisonRegex = looseComparisonRegex;
        }

        @NotNull
        public final MediaSourceBuilder getBuilder() {
            return this.builder;
        }

        @Nullable
        public final String getUriScheme() {
            return this.uriScheme;
        }

        @Nullable
        public final String getExtension() {
            return this.extension;
        }

        @Nullable
        public final String getLooseComparisonRegex() {
            return this.looseComparisonRegex;
        }

        @NotNull
        public final MediaSourceBuilder component1() {
            return this.builder;
        }

        @Nullable
        public final String component2() {
            return this.uriScheme;
        }

        @Nullable
        public final String component3() {
            return this.extension;
        }

        @Nullable
        public final String component4() {
            return this.looseComparisonRegex;
        }

        @NotNull
        public final SourceTypeBuilder copy(@NotNull MediaSourceBuilder builder, @Nullable String uriScheme, @Nullable String extension, @Nullable String looseComparisonRegex) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            return new SourceTypeBuilder(builder, uriScheme, extension, looseComparisonRegex);
        }

        public static /* synthetic */ SourceTypeBuilder copy$default(SourceTypeBuilder sourceTypeBuilder, MediaSourceBuilder mediaSourceBuilder, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                mediaSourceBuilder = sourceTypeBuilder.builder;
            }
            if ((n & 2) != 0) {
                string = sourceTypeBuilder.uriScheme;
            }
            if ((n & 4) != 0) {
                string2 = sourceTypeBuilder.extension;
            }
            if ((n & 8) != 0) {
                string3 = sourceTypeBuilder.looseComparisonRegex;
            }
            return sourceTypeBuilder.copy(mediaSourceBuilder, string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "SourceTypeBuilder(builder=" + this.builder + ", uriScheme=" + this.uriScheme + ", extension=" + this.extension + ", looseComparisonRegex=" + this.looseComparisonRegex + ')';
        }

        public int hashCode() {
            int result = this.builder.hashCode();
            result = result * 31 + (this.uriScheme == null ? 0 : this.uriScheme.hashCode());
            result = result * 31 + (this.extension == null ? 0 : this.extension.hashCode());
            result = result * 31 + (this.looseComparisonRegex == null ? 0 : this.looseComparisonRegex.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SourceTypeBuilder)) {
                return false;
            }
            SourceTypeBuilder sourceTypeBuilder = (SourceTypeBuilder)other;
            if (!Intrinsics.areEqual((Object)this.builder, (Object)sourceTypeBuilder.builder)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.uriScheme, (Object)sourceTypeBuilder.uriScheme)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.extension, (Object)sourceTypeBuilder.extension)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.looseComparisonRegex, (Object)sourceTypeBuilder.looseComparisonRegex);
        }
    }
}

