/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.unified;

import androidx.annotation.OptIn;
import androidx.media3.common.MediaItem;
import androidx.media3.common.PlaybackParameters;
import androidx.media3.common.Player;
import androidx.media3.common.SimpleBasePlayer;
import androidx.media3.common.TrackSelectionParameters;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.exoplayer.source.MediaSource;
import com.devbrackets.android.exomedia.nmp.config.PlayerConfig;
import com.devbrackets.android.exomedia.ui.widget.VideoView;
import com.devbrackets.android.exomedia.unified.AudioPlayerWrapper;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u0017\u0018\u0000 02\u00020\u0001:\u00010B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0011\u001a\u00020\u0012H\u0014J\f\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0014J\f\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0014J$\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0018H\u0014J*\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u00142\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020\u00182\u0006\u0010!\u001a\u00020\u001aH\u0014J\u0014\u0010\"\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010#\u001a\u00020\bH\u0014J\u0014\u0010$\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010%\u001a\u00020&H\u0014J\u0014\u0010'\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010(\u001a\u00020\u0018H\u0014J\u0014\u0010)\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010*\u001a\u00020+H\u0014J\u0014\u0010,\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010-\u001a\u00020.H\u0014J\f\u0010/\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0014R\u001a\u0010\u0007\u001a\u00020\bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u00061"}, d2={"Lcom/devbrackets/android/exomedia/unified/VideoViewWrapper;", "Landroidx/media3/common/SimpleBasePlayer;", "videoView", "Lcom/devbrackets/android/exomedia/ui/widget/VideoView;", "playerConfig", "Lcom/devbrackets/android/exomedia/nmp/config/PlayerConfig;", "(Lcom/devbrackets/android/exomedia/ui/widget/VideoView;Lcom/devbrackets/android/exomedia/nmp/config/PlayerConfig;)V", "latestPlayWhenReady", "", "getLatestPlayWhenReady", "()Z", "setLatestPlayWhenReady", "(Z)V", "getPlayerConfig", "()Lcom/devbrackets/android/exomedia/nmp/config/PlayerConfig;", "getVideoView", "()Lcom/devbrackets/android/exomedia/ui/widget/VideoView;", "getState", "Landroidx/media3/common/SimpleBasePlayer$State;", "handlePrepare", "Lcom/google/common/util/concurrent/ListenableFuture;", "handleRelease", "handleSeek", "mediaItemIndex", "", "positionMs", "", "seekCommand", "handleSetMediaItems", "mediaItems", "", "Landroidx/media3/common/MediaItem;", "startIndex", "startPositionMs", "handleSetPlayWhenReady", "playWhenReady", "handleSetPlaybackParameters", "playbackParameters", "Landroidx/media3/common/PlaybackParameters;", "handleSetRepeatMode", "repeatMode", "handleSetTrackSelectionParameters", "trackSelectionParameters", "Landroidx/media3/common/TrackSelectionParameters;", "handleSetVolume", "volume", "", "handleStop", "Companion", "library_release"})
@OptIn(markerClass={UnstableApi.class})
@SourceDebugExtension(value={"SMAP\nVideoViewWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VideoViewWrapper.kt\ncom/devbrackets/android/exomedia/unified/VideoViewWrapper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,120:1\n1855#2,2:121\n1855#2,2:123\n*S KotlinDebug\n*F\n+ 1 VideoViewWrapper.kt\ncom/devbrackets/android/exomedia/unified/VideoViewWrapper\n*L\n36#1:121,2\n40#1:123,2\n*E\n"})
public class VideoViewWrapper
extends SimpleBasePlayer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VideoView videoView;
    @NotNull
    private final PlayerConfig playerConfig;
    private boolean latestPlayWhenReady;
    @NotNull
    private static final List<Integer> SUPPORTED_VIDEO_COMMANDS = CollectionsKt.emptyList();

    public VideoViewWrapper(@NotNull VideoView videoView, @NotNull PlayerConfig playerConfig) {
        Intrinsics.checkNotNullParameter((Object)videoView, (String)"videoView");
        Intrinsics.checkNotNullParameter((Object)playerConfig, (String)"playerConfig");
        super(playerConfig.getHandler().getLooper());
        this.videoView = videoView;
        this.playerConfig = playerConfig;
    }

    public /* synthetic */ VideoViewWrapper(VideoView videoView, PlayerConfig playerConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            playerConfig = videoView.getVideoPlayer().getPlayerConfig();
        }
        this(videoView, playerConfig);
    }

    @NotNull
    public final VideoView getVideoView() {
        return this.videoView;
    }

    @NotNull
    protected final PlayerConfig getPlayerConfig() {
        return this.playerConfig;
    }

    protected final boolean getLatestPlayWhenReady() {
        return this.latestPlayWhenReady;
    }

    protected final void setLatestPlayWhenReady(boolean bl) {
        this.latestPlayWhenReady = bl;
    }

    @NotNull
    protected SimpleBasePlayer.State getState() {
        int it;
        Player.Commands.Builder builder;
        Player.Commands.Builder $this$getState_u24lambda_u242 = builder = new Player.Commands.Builder();
        boolean bl = false;
        Iterable $this$forEach$iv = AudioPlayerWrapper.Companion.getSUPPORTED_AUDIO_COMMANDS();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = ((Number)element$iv).intValue();
            boolean bl2 = false;
            $this$getState_u24lambda_u242.add(it);
        }
        $this$forEach$iv = SUPPORTED_VIDEO_COMMANDS;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = ((Number)element$iv).intValue();
            boolean bl3 = false;
            $this$getState_u24lambda_u242.add(it);
        }
        Player.Commands commands = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)commands, (String)"Builder().apply {\n      \u2026it)\n      }\n    }.build()");
        Player.Commands allowedCommands = commands;
        SimpleBasePlayer.State state = new SimpleBasePlayer.State.Builder().setAvailableCommands(allowedCommands).setPlayWhenReady(this.latestPlayWhenReady, 1).build();
        Intrinsics.checkNotNullExpressionValue((Object)state, (String)"Builder()\n      .setAvai\u2026R_REQUEST)\n      .build()");
        return state;
    }

    @NotNull
    protected ListenableFuture<?> handleSetPlayWhenReady(boolean playWhenReady) {
        this.latestPlayWhenReady = playWhenReady;
        boolean bl = playWhenReady;
        if (bl) {
            this.videoView.start();
        } else if (!bl) {
            VideoView.pause$default(this.videoView, false, 1, null);
        }
        ListenableFuture listenableFuture = Futures.immediateVoidFuture();
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"immediateVoidFuture()");
        return listenableFuture;
    }

    @NotNull
    protected ListenableFuture<?> handlePrepare() {
        ListenableFuture listenableFuture = Futures.immediateVoidFuture();
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"immediateVoidFuture()");
        return listenableFuture;
    }

    @NotNull
    protected ListenableFuture<?> handleStop() {
        this.latestPlayWhenReady = false;
        this.videoView.stop();
        ListenableFuture listenableFuture = Futures.immediateVoidFuture();
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"immediateVoidFuture()");
        return listenableFuture;
    }

    @NotNull
    protected ListenableFuture<?> handleRelease() {
        this.videoView.release();
        ListenableFuture listenableFuture = Futures.immediateVoidFuture();
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"immediateVoidFuture()");
        return listenableFuture;
    }

    @NotNull
    protected ListenableFuture<?> handleSetRepeatMode(int repeatMode) {
        this.videoView.setRepeatMode(repeatMode);
        ListenableFuture listenableFuture = Futures.immediateVoidFuture();
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"immediateVoidFuture()");
        return listenableFuture;
    }

    @NotNull
    protected ListenableFuture<?> handleSetPlaybackParameters(@NotNull PlaybackParameters playbackParameters) {
        Intrinsics.checkNotNullParameter((Object)playbackParameters, (String)"playbackParameters");
        this.videoView.setPlaybackSpeed(playbackParameters.speed);
        this.videoView.setPlaybackPitch(playbackParameters.pitch);
        ListenableFuture listenableFuture = Futures.immediateVoidFuture();
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"immediateVoidFuture()");
        return listenableFuture;
    }

    @NotNull
    protected ListenableFuture<?> handleSetTrackSelectionParameters(@NotNull TrackSelectionParameters trackSelectionParameters) {
        Intrinsics.checkNotNullParameter((Object)trackSelectionParameters, (String)"trackSelectionParameters");
        this.videoView.setTrackSelectionParameters(trackSelectionParameters);
        ListenableFuture listenableFuture = Futures.immediateVoidFuture();
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"immediateVoidFuture()");
        return listenableFuture;
    }

    @NotNull
    protected ListenableFuture<?> handleSetVolume(float volume) {
        this.videoView.setVolume(volume);
        ListenableFuture listenableFuture = Futures.immediateVoidFuture();
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"immediateVoidFuture()");
        return listenableFuture;
    }

    @NotNull
    protected ListenableFuture<?> handleSetMediaItems(@NotNull List<MediaItem> mediaItems, int startIndex, long startPositionMs) {
        MediaSource mediaSource;
        Intrinsics.checkNotNullParameter(mediaItems, (String)"mediaItems");
        MediaItem mediaItem = (MediaItem)CollectionsKt.firstOrNull(mediaItems);
        if (mediaItem != null) {
            MediaItem it = mediaItem;
            boolean bl = false;
            mediaSource = this.playerConfig.getMediaSourceFactory().createMediaSource(it);
        } else {
            mediaSource = null;
        }
        MediaSource mediaSource2 = mediaSource;
        this.videoView.setMedia(mediaSource2);
        if (startPositionMs > 0L) {
            this.videoView.seekTo(startPositionMs);
        }
        ListenableFuture listenableFuture = Futures.immediateVoidFuture();
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"immediateVoidFuture()");
        return listenableFuture;
    }

    @NotNull
    protected ListenableFuture<?> handleSeek(int mediaItemIndex, long positionMs, int seekCommand) {
        this.videoView.seekTo(positionMs);
        ListenableFuture listenableFuture = Futures.immediateVoidFuture();
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"immediateVoidFuture()");
        return listenableFuture;
    }

    @NotNull
    public static final List<Integer> getSUPPORTED_VIDEO_COMMANDS() {
        return Companion.getSUPPORTED_VIDEO_COMMANDS();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\"\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/devbrackets/android/exomedia/unified/VideoViewWrapper$Companion;", "", "()V", "SUPPORTED_VIDEO_COMMANDS", "", "", "getSUPPORTED_VIDEO_COMMANDS$annotations", "getSUPPORTED_VIDEO_COMMANDS", "()Ljava/util/List;", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<Integer> getSUPPORTED_VIDEO_COMMANDS() {
            return SUPPORTED_VIDEO_COMMANDS;
        }

        @JvmStatic
        public static /* synthetic */ void getSUPPORTED_VIDEO_COMMANDS$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

