/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.nmp.manager;

import android.content.Context;
import android.os.PowerManager;
import android.util.Log;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\n\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0010\u001a\b\u0018\u00010\u0011R\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/devbrackets/android/exomedia/nmp/manager/WakeManager;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "hasWakeLockPermission", "", "getHasWakeLockPermission", "()Z", "hasWakeLockPermission$delegate", "Lkotlin/Lazy;", "powerManager", "Landroid/os/PowerManager;", "getPowerManager", "()Landroid/os/PowerManager;", "powerManager$delegate", "wakeLock", "Landroid/os/PowerManager$WakeLock;", "setWakeLevel", "", "levelAndFlags", "", "stayAwake", "awake", "Companion", "library_release"})
public final class WakeManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @Nullable
    private PowerManager.WakeLock wakeLock;
    @NotNull
    private final Lazy hasWakeLockPermission$delegate;
    @NotNull
    private final Lazy powerManager$delegate;
    @NotNull
    private static final String TAG = "ExoMediaPlayer";
    private static final long WAKE_LOCK_TIMEOUT = 1000L;

    public WakeManager(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.hasWakeLockPermission$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ WakeManager this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return WakeManager.access$getContext$p(this.this$0).getPackageManager().checkPermission("android.permission.WAKE_LOCK", WakeManager.access$getContext$p(this.this$0).getPackageName()) == 0;
            }
        }));
        this.powerManager$delegate = LazyKt.lazy((Function0)((Function0)new Function0<PowerManager>(this){
            final /* synthetic */ WakeManager this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final PowerManager invoke() {
                Object object = WakeManager.access$getContext$p(this.this$0).getSystemService("power");
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.os.PowerManager");
                return (PowerManager)object;
            }
        }));
    }

    private final boolean getHasWakeLockPermission() {
        Lazy lazy = this.hasWakeLockPermission$delegate;
        return (Boolean)lazy.getValue();
    }

    private final PowerManager getPowerManager() {
        Lazy lazy = this.powerManager$delegate;
        return (PowerManager)lazy.getValue();
    }

    public final void setWakeLevel(int levelAndFlags) {
        boolean wasHeld = false;
        PowerManager.WakeLock wakeLock = this.wakeLock;
        if (wakeLock != null) {
            PowerManager.WakeLock lock = wakeLock;
            boolean bl = false;
            if (lock.isHeld()) {
                wasHeld = true;
                lock.release();
            }
            this.wakeLock = null;
        }
        if (!this.getHasWakeLockPermission()) {
            Log.e((String)TAG, (String)"Unable to acquire WAKE_LOCK due to missing manifest permission \"android.permission.WAKE_LOCK\"");
            return;
        }
        PowerManager.WakeLock wakeLock2 = this.wakeLock = this.getPowerManager().newWakeLock(levelAndFlags | 0x20000000, this.getClass().getName());
        if (wakeLock2 != null) {
            wakeLock2.setReferenceCounted(false);
        }
        this.stayAwake(wasHeld);
    }

    public final void stayAwake(boolean awake) {
        block0: {
            PowerManager.WakeLock lock;
            block1: {
                PowerManager.WakeLock wakeLock = this.wakeLock;
                if (wakeLock == null) break block0;
                lock = wakeLock;
                boolean bl = false;
                if (!awake || lock.isHeld()) break block1;
                lock.acquire(1000L);
                break block0;
            }
            if (awake || !lock.isHeld()) break block0;
            lock.release();
        }
    }

    public static final /* synthetic */ Context access$getContext$p(WakeManager $this) {
        return $this.context;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/devbrackets/android/exomedia/nmp/manager/WakeManager$Companion;", "", "()V", "TAG", "", "WAKE_LOCK_TIMEOUT", "", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

