/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.core.video.exo;

import android.annotation.TargetApi;
import android.content.Context;
import android.net.Uri;
import android.support.annotation.FloatRange;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.SurfaceHolder;
import com.devbrackets.android.exomedia.ExoMedia;
import com.devbrackets.android.exomedia.core.ListenerMux;
import com.devbrackets.android.exomedia.core.api.VideoViewApi;
import com.devbrackets.android.exomedia.core.exoplayer.WindowInfo;
import com.devbrackets.android.exomedia.core.listener.CaptionListener;
import com.devbrackets.android.exomedia.core.video.ResizingSurfaceView;
import com.devbrackets.android.exomedia.core.video.exo.ExoVideoDelegate;
import com.google.android.exoplayer2.drm.MediaDrmCallback;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.TrackGroupArray;
import java.util.Map;

@TargetApi(value=16)
public class ExoSurfaceVideoView
extends ResizingSurfaceView
implements VideoViewApi {
    protected ExoVideoDelegate delegate;

    public ExoSurfaceVideoView(Context context) {
        super(context);
        this.setup();
    }

    public ExoSurfaceVideoView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setup();
    }

    public ExoSurfaceVideoView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setup();
    }

    public ExoSurfaceVideoView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.setup();
    }

    @Override
    public void setVideoUri(@Nullable Uri uri) {
        this.delegate.setVideoUri(uri);
    }

    @Override
    public void setVideoUri(@Nullable Uri uri, @Nullable MediaSource mediaSource) {
        this.delegate.setVideoUri(uri, mediaSource);
    }

    @Override
    public void setDrmCallback(@Nullable MediaDrmCallback drmCallback) {
        this.delegate.setDrmCallback(drmCallback);
    }

    @Override
    public boolean restart() {
        return this.delegate.restart();
    }

    @Override
    public float getVolume() {
        return this.delegate.getVolume();
    }

    @Override
    public boolean setVolume(@FloatRange(from=0.0, to=1.0) float volume) {
        return this.delegate.setVolume(volume);
    }

    @Override
    public void seekTo(@IntRange(from=0L) long milliseconds) {
        this.delegate.seekTo(milliseconds);
    }

    @Override
    public boolean isPlaying() {
        return this.delegate.isPlaying();
    }

    @Override
    public void start() {
        this.delegate.start();
    }

    @Override
    public void pause() {
        this.delegate.pause();
    }

    @Override
    public void stopPlayback(boolean clearSurface) {
        this.delegate.stopPlayback(clearSurface);
    }

    @Override
    public void suspend() {
        this.delegate.suspend();
    }

    @Override
    public long getDuration() {
        return this.delegate.getDuration();
    }

    @Override
    public long getCurrentPosition() {
        return this.delegate.getCurrentPosition();
    }

    @Override
    public int getBufferedPercent() {
        return this.delegate.getBufferedPercent();
    }

    @Override
    @Nullable
    public WindowInfo getWindowInfo() {
        return this.delegate.getWindowInfo();
    }

    @Override
    public boolean setPlaybackSpeed(float speed) {
        return this.delegate.setPlaybackSpeed(speed);
    }

    @Override
    public float getPlaybackSpeed() {
        return this.delegate.getPlaybackSpeed();
    }

    @Override
    public void setCaptionListener(@Nullable CaptionListener listener) {
        this.delegate.setCaptionListener(listener);
    }

    @Override
    public boolean trackSelectionAvailable() {
        return this.delegate.trackSelectionAvailable();
    }

    @Override
    public void setTrack(@NonNull ExoMedia.RendererType trackType, int trackIndex) {
        this.delegate.setTrack(trackType, trackIndex);
    }

    @Override
    public void setTrack(@NonNull ExoMedia.RendererType type, int groupIndex, int trackIndex) {
        this.delegate.setTrack(type, groupIndex, trackIndex);
    }

    @Override
    public int getSelectedTrackIndex(@NonNull ExoMedia.RendererType type, int groupIndex) {
        return this.delegate.getSelectedTrackIndex(type, groupIndex);
    }

    @Override
    public void clearSelectedTracks(@NonNull ExoMedia.RendererType type) {
        this.delegate.clearSelectedTracks(type);
    }

    @Override
    @Nullable
    public Map<ExoMedia.RendererType, TrackGroupArray> getAvailableTracks() {
        return this.delegate.getAvailableTracks();
    }

    @Override
    public void setRendererEnabled(@NonNull ExoMedia.RendererType type, boolean enabled) {
        this.delegate.setRendererEnabled(type, enabled);
    }

    @Override
    public boolean isRendererEnabled(@NonNull ExoMedia.RendererType type) {
        return this.delegate.isRendererEnabled(type);
    }

    @Override
    public void release() {
        this.delegate.release();
    }

    @Override
    public void setListenerMux(ListenerMux listenerMux) {
        this.delegate.setListenerMux(listenerMux);
    }

    @Override
    public void onVideoSizeChanged(int width, int height, float pixelWidthHeightRatio) {
        if (this.updateVideoSize((int)((float)width * pixelWidthHeightRatio), height)) {
            this.requestLayout();
        }
    }

    @Override
    public void setRepeatMode(int repeatMode) {
        this.delegate.setRepeatMode(repeatMode);
    }

    protected void setup() {
        this.delegate = new ExoVideoDelegate(this.getContext(), this);
        this.getHolder().addCallback((SurfaceHolder.Callback)new HolderCallback());
        this.updateVideoSize(0, 0);
    }

    protected class HolderCallback
    implements SurfaceHolder.Callback {
        protected HolderCallback() {
        }

        public void surfaceCreated(SurfaceHolder holder) {
            ExoSurfaceVideoView.this.delegate.onSurfaceReady(holder.getSurface());
        }

        public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        }

        public void surfaceDestroyed(SurfaceHolder holder) {
            ExoSurfaceVideoView.this.delegate.onSurfaceDestroyed();
            holder.getSurface().release();
        }
    }
}

