/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.core.builder;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.devbrackets.android.exomedia.core.builder.RenderBuilder;
import com.devbrackets.android.exomedia.core.exoplayer.EMExoPlayer;
import com.devbrackets.android.exomedia.core.renderer.EMMediaCodecAudioTrackRenderer;
import com.google.android.exoplayer.DefaultLoadControl;
import com.google.android.exoplayer.LoadControl;
import com.google.android.exoplayer.MediaCodecAudioTrackRenderer;
import com.google.android.exoplayer.MediaCodecSelector;
import com.google.android.exoplayer.MediaCodecVideoTrackRenderer;
import com.google.android.exoplayer.SampleSource;
import com.google.android.exoplayer.TrackRenderer;
import com.google.android.exoplayer.audio.AudioCapabilities;
import com.google.android.exoplayer.chunk.ChunkSampleSource;
import com.google.android.exoplayer.chunk.ChunkSource;
import com.google.android.exoplayer.chunk.FormatEvaluator;
import com.google.android.exoplayer.dash.DashChunkSource;
import com.google.android.exoplayer.dash.DashTrackSelector;
import com.google.android.exoplayer.dash.DefaultDashTrackSelector;
import com.google.android.exoplayer.dash.mpd.AdaptationSet;
import com.google.android.exoplayer.dash.mpd.MediaPresentationDescription;
import com.google.android.exoplayer.dash.mpd.MediaPresentationDescriptionParser;
import com.google.android.exoplayer.dash.mpd.Period;
import com.google.android.exoplayer.dash.mpd.UtcTimingElement;
import com.google.android.exoplayer.dash.mpd.UtcTimingElementResolver;
import com.google.android.exoplayer.drm.DrmSessionManager;
import com.google.android.exoplayer.drm.MediaDrmCallback;
import com.google.android.exoplayer.drm.StreamingDrmSessionManager;
import com.google.android.exoplayer.drm.UnsupportedDrmException;
import com.google.android.exoplayer.text.SubtitleParser;
import com.google.android.exoplayer.text.TextRenderer;
import com.google.android.exoplayer.text.TextTrackRenderer;
import com.google.android.exoplayer.upstream.Allocator;
import com.google.android.exoplayer.upstream.BandwidthMeter;
import com.google.android.exoplayer.upstream.DataSource;
import com.google.android.exoplayer.upstream.DefaultAllocator;
import com.google.android.exoplayer.upstream.DefaultBandwidthMeter;
import com.google.android.exoplayer.upstream.DefaultUriDataSource;
import com.google.android.exoplayer.upstream.TransferListener;
import com.google.android.exoplayer.upstream.UriDataSource;
import com.google.android.exoplayer.upstream.UriLoadable;
import com.google.android.exoplayer.util.ManifestFetcher;
import com.google.android.exoplayer.util.Util;
import java.io.IOException;

@TargetApi(value=16)
public class DashRenderBuilder
extends RenderBuilder {
    private static final String TAG = "DashRendererBuilder";
    protected static final int LIVE_EDGE_LATENCY_MS = 30000;
    protected static final int SECURITY_LEVEL_UNKNOWN = -1;
    protected static final int SECURITY_LEVEL_1 = 1;
    protected static final int SECURITY_LEVEL_3 = 3;

    public DashRenderBuilder(@NonNull Context context, @NonNull String userAgent, @NonNull String uri) {
        super(context, userAgent, uri);
    }

    public DashRenderBuilder(@NonNull Context context, @NonNull String userAgent, @NonNull String uri, int streamType) {
        super(context, userAgent, uri, streamType);
    }

    public DashRenderBuilder(@NonNull Context context, @NonNull String userAgent, @NonNull String uri, @Nullable MediaDrmCallback drmCallback, int streamType) {
        super(context, userAgent, uri, drmCallback, streamType);
    }

    @Override
    protected RenderBuilder.AsyncBuilder createAsyncBuilder(EMExoPlayer player) {
        return new AsyncDashBuilder(this.context, this.userAgent, this.uri, this.drmCallback, player, this.streamType);
    }

    protected UriDataSource createManifestDataSource(Context context, String userAgent) {
        return new DefaultUriDataSource(context, userAgent);
    }

    protected class AsyncDashBuilder
    extends RenderBuilder.AsyncBuilder
    implements ManifestFetcher.ManifestCallback<MediaPresentationDescription>,
    UtcTimingElementResolver.UtcTimingCallback {
        protected final ManifestFetcher<MediaPresentationDescription> manifestFetcher;
        protected MediaPresentationDescription currentManifest;
        protected final UriDataSource manifestDataSource;
        protected long elapsedRealtimeOffset;

        public AsyncDashBuilder(Context context, String userAgent, @Nullable String url, MediaDrmCallback drmCallback, EMExoPlayer player, int streamType) {
            super(DashRenderBuilder.this, context, userAgent, url, drmCallback, player, streamType);
            MediaPresentationDescriptionParser parser = new MediaPresentationDescriptionParser();
            this.manifestDataSource = DashRenderBuilder.this.createManifestDataSource(context, userAgent);
            this.manifestFetcher = new ManifestFetcher(url, this.manifestDataSource, (UriLoadable.Parser)parser);
        }

        @Override
        public void init() {
            this.manifestFetcher.singleLoad(this.player.getMainHandler().getLooper(), (ManifestFetcher.ManifestCallback)this);
        }

        public void onSingleManifest(MediaPresentationDescription manifest) {
            if (this.canceled) {
                return;
            }
            this.currentManifest = manifest;
            if (manifest.dynamic && manifest.utcTiming != null) {
                UtcTimingElementResolver.resolveTimingElement((UriDataSource)this.manifestDataSource, (UtcTimingElement)manifest.utcTiming, (long)this.manifestFetcher.getManifestLoadCompleteTimestamp(), (UtcTimingElementResolver.UtcTimingCallback)this);
            } else {
                this.buildRenderers();
            }
        }

        public void onSingleManifestError(IOException e) {
            if (this.canceled) {
                return;
            }
            this.player.onRenderersError(e);
        }

        public void onTimestampResolved(UtcTimingElement utcTiming, long elapsedRealtimeOffset) {
            if (this.canceled) {
                return;
            }
            this.elapsedRealtimeOffset = elapsedRealtimeOffset;
            this.buildRenderers();
        }

        public void onTimestampError(UtcTimingElement utcTiming, IOException e) {
            if (this.canceled) {
                return;
            }
            Log.e((String)DashRenderBuilder.TAG, (String)("Failed to resolve UtcTiming element [" + utcTiming + "]"), (Throwable)e);
            this.buildRenderers();
        }

        protected void buildRenderers() {
            boolean filterHdContent = false;
            boolean hasContentProtection = false;
            Period period = this.currentManifest.getPeriod(0);
            StreamingDrmSessionManager drmSessionManager = null;
            for (int i = 0; i < period.adaptationSets.size(); ++i) {
                AdaptationSet adaptationSet = (AdaptationSet)period.adaptationSets.get(i);
                if (adaptationSet.type == -1) continue;
                hasContentProtection |= adaptationSet.hasContentProtection();
            }
            if (hasContentProtection) {
                if (Util.SDK_INT < 18) {
                    this.player.onRenderersError((Exception)((Object)new UnsupportedDrmException(1)));
                    return;
                }
                try {
                    drmSessionManager = StreamingDrmSessionManager.newWidevineInstance((Looper)this.player.getPlaybackLooper(), (MediaDrmCallback)this.drmCallback, null, (Handler)this.player.getMainHandler(), (StreamingDrmSessionManager.EventListener)this.player);
                    filterHdContent = this.getWidevineSecurityLevel(drmSessionManager) != 1;
                }
                catch (UnsupportedDrmException e) {
                    this.player.onRenderersError((Exception)((Object)e));
                    return;
                }
            }
            this.buildTrackRenderers((DrmSessionManager)drmSessionManager, filterHdContent);
        }

        protected void buildTrackRenderers(DrmSessionManager drmSessionManager, boolean filterHdContent) {
            Handler mainHandler = this.player.getMainHandler();
            DefaultLoadControl loadControl = new DefaultLoadControl((Allocator)new DefaultAllocator(65536));
            DefaultBandwidthMeter bandwidthMeter = new DefaultBandwidthMeter(mainHandler, (BandwidthMeter.EventListener)this.player);
            DataSource dataSourceVideo = DashRenderBuilder.this.createDataSource(this.context, (TransferListener)bandwidthMeter, this.userAgent);
            DashChunkSource chunkSourceVideo = new DashChunkSource(this.manifestFetcher, (DashTrackSelector)DefaultDashTrackSelector.newVideoInstance((Context)this.context, (boolean)true, (boolean)filterHdContent), dataSourceVideo, (FormatEvaluator)new FormatEvaluator.AdaptiveEvaluator((BandwidthMeter)bandwidthMeter), 30000L, this.elapsedRealtimeOffset, mainHandler, (DashChunkSource.EventListener)this.player, 0);
            ChunkSampleSource sampleSourceVideo = new ChunkSampleSource((ChunkSource)chunkSourceVideo, (LoadControl)loadControl, 0xC80000, mainHandler, (ChunkSampleSource.EventListener)this.player, 0);
            DataSource dataSourceAudio = DashRenderBuilder.this.createDataSource(this.context, (TransferListener)bandwidthMeter, this.userAgent);
            DashChunkSource chunkSourceAudio = new DashChunkSource(this.manifestFetcher, (DashTrackSelector)DefaultDashTrackSelector.newAudioInstance(), dataSourceAudio, null, 30000L, this.elapsedRealtimeOffset, mainHandler, (DashChunkSource.EventListener)this.player, 1);
            ChunkSampleSource sampleSourceAudio = new ChunkSampleSource((ChunkSource)chunkSourceAudio, (LoadControl)loadControl, 0x360000, mainHandler, (ChunkSampleSource.EventListener)this.player, 1);
            DataSource dataSourceCC = DashRenderBuilder.this.createDataSource(this.context, (TransferListener)bandwidthMeter, this.userAgent);
            DashChunkSource chunkSourceCC = new DashChunkSource(this.manifestFetcher, (DashTrackSelector)DefaultDashTrackSelector.newAudioInstance(), dataSourceCC, null, 30000L, this.elapsedRealtimeOffset, mainHandler, (DashChunkSource.EventListener)this.player, 2);
            ChunkSampleSource sampleSourceCC = new ChunkSampleSource((ChunkSource)chunkSourceCC, (LoadControl)loadControl, 131072, mainHandler, (ChunkSampleSource.EventListener)this.player, 2);
            MediaCodecVideoTrackRenderer videoRenderer = new MediaCodecVideoTrackRenderer(this.context, (SampleSource)sampleSourceVideo, MediaCodecSelector.DEFAULT, 1, 5000L, drmSessionManager, true, mainHandler, (MediaCodecVideoTrackRenderer.EventListener)this.player, 50);
            EMMediaCodecAudioTrackRenderer audioRenderer = new EMMediaCodecAudioTrackRenderer((SampleSource)sampleSourceAudio, MediaCodecSelector.DEFAULT, drmSessionManager, true, mainHandler, (MediaCodecAudioTrackRenderer.EventListener)this.player, AudioCapabilities.getCapabilities((Context)this.context), this.streamType);
            TextTrackRenderer captionsRenderer = new TextTrackRenderer((SampleSource)sampleSourceCC, (TextRenderer)this.player, mainHandler.getLooper(), new SubtitleParser[0]);
            TrackRenderer[] renderers = new TrackRenderer[4];
            renderers[0] = videoRenderer;
            renderers[1] = audioRenderer;
            renderers[2] = captionsRenderer;
            this.player.onRenderers(renderers, (BandwidthMeter)bandwidthMeter);
        }

        protected int getWidevineSecurityLevel(StreamingDrmSessionManager sessionManager) {
            String securityLevelProperty = sessionManager.getPropertyString("securityLevel");
            return securityLevelProperty.equals("L1") ? 1 : (securityLevelProperty.equals("L3") ? 3 : -1);
        }
    }
}

