/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia;

import android.content.Context;
import android.net.Uri;
import android.support.annotation.FloatRange;
import android.support.annotation.Nullable;
import com.devbrackets.android.exomedia.core.EMListenerMux;
import com.devbrackets.android.exomedia.core.api.MediaPlayerApi;
import com.devbrackets.android.exomedia.core.audio.ExoMediaPlayer;
import com.devbrackets.android.exomedia.core.audio.NativeMediaPlayer;
import com.devbrackets.android.exomedia.core.builder.RenderBuilder;
import com.devbrackets.android.exomedia.core.exoplayer.EMExoPlayer;
import com.devbrackets.android.exomedia.core.listener.Id3MetadataListener;
import com.devbrackets.android.exomedia.listener.OnBufferUpdateListener;
import com.devbrackets.android.exomedia.listener.OnCompletionListener;
import com.devbrackets.android.exomedia.listener.OnErrorListener;
import com.devbrackets.android.exomedia.listener.OnPreparedListener;
import com.devbrackets.android.exomedia.listener.OnSeekCompletionListener;
import com.devbrackets.android.exomedia.util.DeviceUtil;
import com.devbrackets.android.exomedia.util.DrmProvider;
import com.google.android.exoplayer.MediaFormat;
import java.util.List;
import java.util.Map;

public class EMAudioPlayer {
    protected EMListenerMux listenerMux;
    protected MediaPlayerApi mediaPlayerImpl;
    protected int overriddenDuration = -1;

    public EMAudioPlayer(Context context) {
        this(context, new DeviceUtil());
    }

    public EMAudioPlayer(Context context, DeviceUtil deviceUtil) {
        this.mediaPlayerImpl = deviceUtil.supportsExoPlayer(context) ? new ExoMediaPlayer(context) : new NativeMediaPlayer(context);
        this.init(this.mediaPlayerImpl);
    }

    public EMAudioPlayer(MediaPlayerApi mediaPlayerImpl) {
        this.mediaPlayerImpl = mediaPlayerImpl;
        this.init(mediaPlayerImpl);
    }

    protected void init(MediaPlayerApi mediaPlayerImpl) {
        this.listenerMux = new EMListenerMux(new MuxNotifier());
        mediaPlayerImpl.setListenerMux(this.listenerMux);
    }

    public int getAudioSessionId() {
        return this.mediaPlayerImpl.getAudioSessionId();
    }

    public void setAudioStreamType(int streamType) {
        this.mediaPlayerImpl.setAudioStreamType(streamType);
    }

    public void setDataSource(Context context, Uri uri) {
        this.mediaPlayerImpl.setDataSource(context, uri);
        this.overrideDuration(-1);
    }

    public void setDataSource(Context context, Uri uri, RenderBuilder renderBuilder) {
        this.mediaPlayerImpl.setDataSource(context, uri, renderBuilder);
        this.overrideDuration(-1);
    }

    public void setDrmProvider(@Nullable DrmProvider drmProvider) {
        this.mediaPlayerImpl.setDrmProvider(drmProvider);
    }

    public void prepareAsync() {
        this.mediaPlayerImpl.prepareAsync();
    }

    public void setVolume(@FloatRange(from=0.0, to=1.0) float leftVolume, @FloatRange(from=0.0, to=1.0) float rightVolume) {
        this.mediaPlayerImpl.setVolume(leftVolume, rightVolume);
    }

    public void setWakeMode(Context context, int mode) {
        this.mediaPlayerImpl.setWakeMode(context, mode);
    }

    public void reset() {
        this.stopPlayback();
        this.setDataSource(null, null);
        this.mediaPlayerImpl.reset();
    }

    public void seekTo(int milliSeconds) {
        this.mediaPlayerImpl.seekTo(milliSeconds);
    }

    public boolean isPlaying() {
        return this.mediaPlayerImpl.isPlaying();
    }

    public void start() {
        this.mediaPlayerImpl.start();
    }

    public void pause() {
        this.mediaPlayerImpl.pause();
    }

    public void stopPlayback() {
        this.mediaPlayerImpl.stopPlayback();
    }

    public void release() {
        this.mediaPlayerImpl.release();
    }

    public int getDuration() {
        if (this.overriddenDuration >= 0) {
            return this.overriddenDuration;
        }
        return this.mediaPlayerImpl.getDuration();
    }

    public void overrideDuration(int duration) {
        this.overriddenDuration = duration;
    }

    public int getCurrentPosition() {
        return this.mediaPlayerImpl.getCurrentPosition();
    }

    public int getBufferPercentage() {
        return this.mediaPlayerImpl.getBufferedPercent();
    }

    public boolean trackSelectionAvailable() {
        return this.mediaPlayerImpl.trackSelectionAvailable();
    }

    public void setTrack(int trackType, int trackIndex) {
        this.mediaPlayerImpl.setTrack(trackType, trackIndex);
    }

    @Nullable
    public Map<Integer, List<MediaFormat>> getAvailableTracks() {
        return this.mediaPlayerImpl.getAvailableTracks();
    }

    public void setOnPreparedListener(OnPreparedListener listener) {
        this.listenerMux.setOnPreparedListener(listener);
    }

    public void setOnCompletionListener(OnCompletionListener listener) {
        this.listenerMux.setOnCompletionListener(listener);
    }

    public void setOnBufferUpdateListener(OnBufferUpdateListener listener) {
        this.listenerMux.setOnBufferUpdateListener(listener);
    }

    public void setOnSeekCompletionListener(OnSeekCompletionListener listener) {
        this.listenerMux.setOnSeekCompletionListener(listener);
    }

    public void setOnErrorListener(OnErrorListener listener) {
        this.listenerMux.setOnErrorListener(listener);
    }

    public void setId3MetadataListener(@Nullable Id3MetadataListener listener) {
        this.listenerMux.setId3MetadataListener(listener);
    }

    private void onPlaybackEnded() {
        this.pause();
    }

    private class MuxNotifier
    extends EMListenerMux.EMListenerMuxNotifier {
        private MuxNotifier() {
        }

        @Override
        public boolean shouldNotifyCompletion(long endLeeway) {
            return (long)EMAudioPlayer.this.getCurrentPosition() + endLeeway >= (long)EMAudioPlayer.this.getDuration();
        }

        @Override
        public void onExoPlayerError(EMExoPlayer emExoPlayer, Exception e) {
            EMAudioPlayer.this.stopPlayback();
            if (emExoPlayer != null) {
                emExoPlayer.forcePrepare();
            }
        }

        @Override
        public void onMediaPlaybackEnded() {
            EMAudioPlayer.this.onPlaybackEnded();
        }

        @Override
        public void onPrepared() {
            EMAudioPlayer.this.mediaPlayerImpl.onMediaPrepared();
        }
    }
}

