/*
 * Decompiled with CFR 0.152.
 */
package com.deliveredtechnologies.rulebook.runner;

import com.deliveredtechnologies.rulebook.DecisionBook;
import com.deliveredtechnologies.rulebook.annotation.Rule;
import com.deliveredtechnologies.rulebook.runner.RuleAdapter;
import com.deliveredtechnologies.rulebook.util.AnnotationUtils;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class RuleBookRunner
extends DecisionBook {
    private static Logger LOGGER = LoggerFactory.getLogger(RuleBookRunner.class);
    private String _package;

    public RuleBookRunner(String rulePackage) {
        this._package = rulePackage;
    }

    @Override
    protected void defineRules() {
        try {
            List<Class<?>> classes = this.findRuleClassesInPackage(this._package);
            for (Class<?> rule : classes) {
                try {
                    this.addRule(new RuleAdapter(rule.newInstance()));
                }
                catch (IllegalAccessException | InstantiationException ex) {
                    LOGGER.error("Unable to create instance of rule using '" + rule + "'", (Throwable)ex);
                }
            }
        }
        catch (IOException | InvalidPathException ex) {
            LOGGER.error("Unable to find rule classes in package '" + this._package + "'", (Throwable)ex);
        }
    }

    private List<Class<?>> findRuleClassesInPackage(String packageName) throws InvalidPathException, IOException {
        String pathName = packageName.replace(".", "/");
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL pathUrl = classLoader.getResource(pathName);
        if (pathUrl == null) {
            throw new InvalidPathException("'" + packageName + "' cannot be found by the ClassLoader", packageName);
        }
        try {
            Path path = Paths.get(pathUrl.toURI());
            if (!Files.exists(path, new LinkOption[0]) || !Files.isDirectory(path, new LinkOption[0])) {
                throw new InvalidPathException("'" + packageName + "' is not a valid path", packageName);
            }
            ArrayList classes = new ArrayList();
            Files.walk(path, 1, new FileVisitOption[0]).filter(p -> !Files.isDirectory(p, new LinkOption[0])).forEach(p -> {
                String fileName = p.getFileName().toString();
                String className = fileName.substring(0, fileName.length() - 6);
                try {
                    Class<?> ruleClass = Class.forName(packageName + "." + className);
                    if (AnnotationUtils.getAnnotation(Rule.class, ruleClass) != null) {
                        classes.add(ruleClass);
                    }
                }
                catch (ClassNotFoundException e) {
                    LOGGER.error("Unable to resolve class for '" + packageName + "." + className + "'", (Throwable)e);
                }
            });
            classes.sort((class1, class2) -> AnnotationUtils.getAnnotation(Rule.class, class1).order() - AnnotationUtils.getAnnotation(Rule.class, class2).order());
            return classes;
        }
        catch (URISyntaxException ex) {
            throw new InvalidPathException("'" + packageName + "' is not a valid path", ex.getReason());
        }
    }
}

