/*
 * Decompiled with CFR 0.152.
 */
package com.deliveredtechnologies.rulebook.model.runner;

import com.deliveredtechnologies.rulebook.NameValueReferableMap;
import com.deliveredtechnologies.rulebook.Result;
import com.deliveredtechnologies.rulebook.model.Rule;
import com.deliveredtechnologies.rulebook.model.RuleBook;
import com.deliveredtechnologies.rulebook.model.rulechain.cor.CoRRuleBook;
import com.deliveredtechnologies.rulebook.model.runner.RuleAdapter;
import com.deliveredtechnologies.rulebook.util.AnnotationUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleBookRunner
implements RuleBook {
    private static Logger LOGGER = LoggerFactory.getLogger(RuleBookRunner.class);
    private String _package;
    private Class<? extends RuleBook> _prototypeClass;
    private Result _result = new Result<Object>(null);

    public RuleBookRunner(String rulePackage) {
        this(CoRRuleBook.class, rulePackage);
    }

    public RuleBookRunner(Class<? extends RuleBook> ruleBookClass, String rulePackage) {
        this._prototypeClass = ruleBookClass;
        this._package = rulePackage;
    }

    @Override
    public void addRule(Rule rule) {
        throw new IllegalStateException("Rules are only added to a RuleBookRunner on run()!");
    }

    @Override
    public void run(NameValueReferableMap facts) {
        this.getResult().ifPresent(Result::reset);
        try {
            RuleBook ruleBook = this._prototypeClass.newInstance();
            List<Class<?>> classes = this.findRuleClassesInPackage(this._package);
            for (Class<?> rule : classes) {
                try {
                    AnnotationUtils.getAnnotatedField(com.deliveredtechnologies.rulebook.annotation.Result.class, rule).ifPresent(field -> ruleBook.setDefaultResult(this._result.getValue() == null ? new Object() : this._result.getValue()));
                    ruleBook.addRule(new RuleAdapter(rule.newInstance()));
                }
                catch (IllegalAccessException | InstantiationException ex) {
                    LOGGER.warn("Unable to create instance of rule using '" + rule + "'", (Throwable)ex);
                }
            }
            ruleBook.run(facts);
            Optional<Result<Result>> result = ruleBook.getResult();
            result.ifPresent(res -> this._result.setValue(res.getValue()));
        }
        catch (IOException | InvalidPathException ex) {
            LOGGER.error("Unable to find rule classes in package '" + this._package + "'", (Throwable)ex);
        }
        catch (IllegalAccessException | InstantiationException ex) {
            LOGGER.error("Unable to create an instance of '" + this._prototypeClass.getName() + "' with the default constructor", (Throwable)ex);
        }
    }

    public void setDefaultResult(Object result) {
        this._result = new Result<Object>(result);
    }

    public Optional<Result> getResult() {
        return this._result.getValue() == null ? Optional.empty() : Optional.of(this._result);
    }

    @Override
    public boolean hasRules() {
        try {
            return this.findRuleClassesInPackage(this._package).size() > 0;
        }
        catch (IOException | InvalidPathException e) {
            LOGGER.error("Unable to find rule classes in package '" + this._package + "'", (Throwable)e);
            return false;
        }
    }

    private List<Class<?>> findRuleClassesInPackage(String packageName) throws InvalidPathException, IOException {
        String pathName = packageName.replace(".", "/");
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL pathUrl = classLoader.getResource(pathName);
        if (pathUrl == null) {
            throw new InvalidPathException("'" + packageName + "' cannot be found by the ClassLoader", packageName);
        }
        try (FileSystem fs = null;){
            Path path;
            URI pathUri = pathUrl.toURI();
            LOGGER.debug(String.format("%s URI -> %s", pathName, pathUrl.toURI()));
            if (pathUri.toString().contains("!")) {
                String[] paths = pathUri.toString().split("!");
                fs = FileSystems.newFileSystem(URI.create(paths[0]), new HashMap());
                String strPath = Arrays.stream(Arrays.copyOfRange(paths, 1, paths.length)).reduce((item1, item2) -> item1 + item2).get();
                LOGGER.debug(String.format("Resource Path Inside Archive: %s", strPath));
                path = fs.getPath(strPath, new String[0]);
            } else {
                path = Paths.get(pathUri);
            }
            if (!Files.exists(path, new LinkOption[0]) || !Files.isDirectory(path, new LinkOption[0])) {
                throw new InvalidPathException("'" + packageName + "' is not a valid path", packageName);
            }
            ArrayList classes = new ArrayList();
            Files.walk(path, 1, new FileVisitOption[0]).filter(p -> !Files.isDirectory(p, new LinkOption[0])).forEach(p -> {
                String fileName = p.getFileName().toString();
                String className = fileName.substring(0, fileName.length() - 6);
                try {
                    Class<?> ruleClass = Class.forName(packageName + "." + className);
                    if (AnnotationUtils.getAnnotation(com.deliveredtechnologies.rulebook.annotation.Rule.class, ruleClass) != null) {
                        classes.add(ruleClass);
                    }
                }
                catch (ClassNotFoundException e) {
                    LOGGER.error("Unable to resolve class for '" + packageName + "." + className + "'", (Throwable)e);
                }
            });
            classes.sort((class1, class2) -> AnnotationUtils.getAnnotation(com.deliveredtechnologies.rulebook.annotation.Rule.class, class1).order() - AnnotationUtils.getAnnotation(com.deliveredtechnologies.rulebook.annotation.Rule.class, class2).order());
            ArrayList arrayList = classes;
            return arrayList;
        }
    }
}

