/*
 * Decompiled with CFR 0.152.
 */
package com.deliveredtechnologies.rulebook.model;

import com.deliveredtechnologies.rulebook.FactMap;
import com.deliveredtechnologies.rulebook.NameValueReferable;
import com.deliveredtechnologies.rulebook.NameValueReferableMap;
import com.deliveredtechnologies.rulebook.NameValueReferableTypeConvertibleMap;
import com.deliveredtechnologies.rulebook.Result;
import com.deliveredtechnologies.rulebook.RuleState;
import com.deliveredtechnologies.rulebook.TypeConvertibleFactMap;
import com.deliveredtechnologies.rulebook.model.Rule;
import com.deliveredtechnologies.rulebook.model.RuleChainActionType;
import com.deliveredtechnologies.rulebook.util.ArrayUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoldenRule<T, U>
implements Rule<T, U> {
    private static Logger LOGGER = LoggerFactory.getLogger(GoldenRule.class);
    private NameValueReferableMap _facts = new FactMap();
    private Result<U> _result;
    private Predicate<NameValueReferableTypeConvertibleMap<T>> _condition;
    private List<Object> _actionChain = new ArrayList<Object>();
    private Map<Integer, List<String>> _factNames = new HashMap<Integer, List<String>>();
    private RuleState _ruleState = RuleState.NEXT;
    private Class<T> _factType;
    private RuleChainActionType _actionType = RuleChainActionType.CONTINUE_ON_FAILURE;

    public GoldenRule(Class<T> factType) {
        this._factType = factType;
    }

    public GoldenRule(Class<T> factType, RuleChainActionType actionType) {
        this(factType);
        this._actionType = actionType;
    }

    @Override
    public void addFacts(NameValueReferable ... facts) {
        Arrays.stream(facts).forEach(fact -> this._facts.put(fact.getName(), fact));
    }

    @Override
    public void addFacts(NameValueReferableMap facts) {
        this._facts.putAll(facts);
    }

    @Override
    public void setFacts(NameValueReferableMap facts) {
        this._facts = facts;
    }

    @Override
    public void setCondition(Predicate<NameValueReferableTypeConvertibleMap<T>> condition) {
        this._condition = condition;
    }

    @Override
    public void setRuleState(RuleState ruleState) {
        this._ruleState = ruleState;
    }

    @Override
    public void addAction(Consumer<NameValueReferableTypeConvertibleMap<T>> action) {
        if (!this._actionChain.contains(action)) {
            this._actionChain.add(action);
        }
    }

    @Override
    public void addAction(BiConsumer<NameValueReferableTypeConvertibleMap<T>, Result<U>> action) {
        if (!this._actionChain.contains(action)) {
            this._actionChain.add(action);
        }
    }

    @Override
    public void addFactNameFilter(String ... factNames) {
        List factNameList = Stream.of(factNames).collect(Collectors.toList());
        if (this._factNames.containsKey(this.getActions().size())) {
            List<String> existingFactNames = this._factNames.get(this.getActions().size());
            existingFactNames.addAll(factNameList);
        } else {
            this._factNames.put(this.getActions().size(), factNameList);
        }
    }

    @Override
    public NameValueReferableMap getFacts() {
        return this._facts;
    }

    @Override
    public Predicate<NameValueReferableTypeConvertibleMap<T>> getCondition() {
        return this._condition;
    }

    @Override
    public RuleState getRuleState() {
        return this._ruleState;
    }

    @Override
    public List<Object> getActions() {
        return this._actionChain;
    }

    @Override
    public boolean invoke(NameValueReferableMap facts) {
        try {
            FactMap typeFilteredFacts = new FactMap(facts.values().stream().filter(fact -> this._factType.isAssignableFrom(((NameValueReferable)fact).getValue().getClass())).collect(Collectors.toMap(fact -> ((NameValueReferable)fact).getName(), fact -> (NameValueReferable)fact)));
            if (this.getCondition() == null || this.getCondition().test(new TypeConvertibleFactMap(typeFilteredFacts))) {
                List<Object> actionList = this.getActions();
                for (int i = 0; i < this.getActions().size(); ++i) {
                    Object action = actionList.get(i);
                    List<String> factNames = this._factNames.get(i);
                    FactMap usingFacts = factNames != null ? new FactMap(factNames.stream().filter(typeFilteredFacts::containsKey).collect(Collectors.toMap(name -> name, name -> (NameValueReferable)facts.get(name)))) : typeFilteredFacts;
                    Result result = new Result();
                    Stream.of(action.getClass().getMethods()).filter(method -> method.getName().equals("accept")).findFirst().ifPresent(method -> {
                        try {
                            method.setAccessible(true);
                            method.invoke(action, ArrayUtils.combine(new Object[]{new TypeConvertibleFactMap(usingFacts)}, new Object[]{this.getResult().orElseGet(() -> result)}, method.getParameterCount()));
                            if (result.getValue() != null) {
                                this._result = result;
                            }
                        }
                        catch (IllegalAccessException | InvocationTargetException err) {
                            LOGGER.error("Error invoking action on " + action.getClass(), (Throwable)err);
                        }
                    });
                    facts.putAll(usingFacts);
                }
                if (this._actionType.equals((Object)RuleChainActionType.STOP_ON_FAILURE)) {
                    this._ruleState = RuleState.NEXT;
                }
                return true;
            }
        }
        catch (Exception ex) {
            LOGGER.error("Error occurred when trying to evaluate rule!", (Throwable)ex);
        }
        return this._actionType.equals((Object)RuleChainActionType.STOP_ON_FAILURE);
    }

    @Override
    public void setResult(Result<U> result) {
        this._result = result;
    }

    @Override
    public Optional<Result<U>> getResult() {
        return Optional.ofNullable(this._result);
    }
}

