/*
 * Decompiled with CFR 0.152.
 */
package com.deliveredtechnologies.rulebook.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class AnnotationUtils {
    private AnnotationUtils() {
    }

    public static List<Field> getAnnotatedFields(Class annotation, Class clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        if (clazz == Object.class) {
            return fields;
        }
        fields.addAll(Arrays.stream(clazz.getDeclaredFields()).filter(field -> field.getAnnotation(annotation) != null).collect(Collectors.toList()));
        fields.addAll(AnnotationUtils.getAnnotatedFields(annotation, clazz.getSuperclass()));
        return fields;
    }

    public static Optional<Field> getAnnotatedField(Class annotation, Class clazz) {
        List<Field> fields = AnnotationUtils.getAnnotatedFields(annotation, clazz);
        return Optional.ofNullable(fields.size() > 0 ? fields.get(0) : null);
    }

    public static List<Method> getAnnotatedMethods(Class annotation, Class clazz) {
        ArrayList<Method> methods = new ArrayList<Method>();
        if (clazz == Object.class) {
            return methods;
        }
        methods.addAll(Arrays.stream(clazz.getDeclaredMethods()).filter(field -> field.getAnnotation(annotation) != null).collect(Collectors.toList()));
        methods.addAll(AnnotationUtils.getAnnotatedMethods(annotation, clazz.getSuperclass()));
        return methods;
    }

    public static Optional<Method> getAnnotatedMethod(Class annotation, Class clazz) {
        List<Method> methods = AnnotationUtils.getAnnotatedMethods(annotation, clazz);
        return Optional.ofNullable(methods.size() > 0 ? methods.get(0) : null);
    }

    public static <A extends Annotation> A getAnnotation(Class<A> annotation, Class<?> clazz) {
        return (A)Optional.ofNullable(clazz.getAnnotation(annotation)).orElse(Arrays.stream(clazz.getDeclaredAnnotations()).flatMap(anno -> Arrays.stream(anno.getClass().getInterfaces()).flatMap(iface -> Arrays.stream(iface.getDeclaredAnnotations()))).filter(annotation::isInstance).findFirst().orElse(null));
    }
}

