/*
 * Decompiled with CFR 0.152.
 */
package com.deliveredtechnologies.rulebook.runner;

import com.deliveredtechnologies.rulebook.Fact;
import com.deliveredtechnologies.rulebook.FactMap;
import com.deliveredtechnologies.rulebook.Result;
import com.deliveredtechnologies.rulebook.RuleState;
import com.deliveredtechnologies.rulebook.StandardDecision;
import com.deliveredtechnologies.rulebook.annotation.Given;
import com.deliveredtechnologies.rulebook.annotation.Rule;
import com.deliveredtechnologies.rulebook.annotation.Then;
import com.deliveredtechnologies.rulebook.annotation.When;
import com.deliveredtechnologies.rulebook.util.AnnotationUtils;
import java.io.InvalidClassException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleAdapter
extends StandardDecision {
    private static Logger LOGGER = LoggerFactory.getLogger(RuleAdapter.class);
    private Object _ruleObj;

    public RuleAdapter(Object ruleObj) throws InvalidClassException {
        if (AnnotationUtils.getAnnotation(Rule.class, ruleObj.getClass()) == null) {
            throw new InvalidClassException(ruleObj.getClass() + " is not a Rule; missing @Rule annotation");
        }
        this._ruleObj = ruleObj;
    }

    @Override
    public RuleAdapter given(Fact ... facts) {
        super.given(facts);
        this.mapGivenFactsToProperties();
        return this;
    }

    @Override
    public RuleAdapter given(List list) {
        super.given(list);
        this.mapGivenFactsToProperties();
        return this;
    }

    @Override
    public RuleAdapter given(FactMap facts) {
        super.given(facts);
        this.mapGivenFactsToProperties();
        return this;
    }

    @Override
    public Predicate getWhen() {
        if (super.getWhen() != null) {
            return super.getWhen();
        }
        return Arrays.stream(this._ruleObj.getClass().getMethods()).filter(method -> method.getReturnType() == Boolean.TYPE || method.getReturnType() == Boolean.class).filter(method -> Arrays.stream(method.getDeclaredAnnotations()).anyMatch(When.class::isInstance)).findFirst().map(method -> object -> {
            try {
                return (Boolean)method.invoke(this._ruleObj, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                return false;
            }
        }).orElse(o -> false);
    }

    @Override
    public Object getThen() {
        if (super.getThen() != null) {
            return super.getThen();
        }
        return this.getThenMethodAsBiFunction().map(Object.class::cast).orElse(this.getThenMethodAsFunction().orElse(factMap -> RuleState.NEXT));
    }

    private void mapGivenFactsToProperties() {
        for (Field field : AnnotationUtils.getAnnotatedFields(Given.class, this._ruleObj.getClass())) {
            Given given = field.getAnnotation(Given.class);
            try {
                field.setAccessible(true);
                if (field.getType() == Fact.class) {
                    field.set(this._ruleObj, this.getFactMap().get(given.value()));
                    continue;
                }
                Object value = this.getFactMap().getValue(given.value());
                if (value != null) {
                    field.set(this._ruleObj, value);
                    continue;
                }
                if (FactMap.class == field.getType()) {
                    field.set(this._ruleObj, this.getFactMap());
                    continue;
                }
                if (Collection.class.isAssignableFrom(field.getType())) {
                    Stream<Object> stream = this.getFactMap().values().stream().filter(fact -> {
                        ParameterizedType paramType = (ParameterizedType)field.getGenericType();
                        Class genericType = (Class)paramType.getActualTypeArguments()[0];
                        return genericType.equals(((Fact)fact).getValue().getClass());
                    }).map(fact -> {
                        ParameterizedType paramType = (ParameterizedType)field.getGenericType();
                        Class genericType = (Class)paramType.getActualTypeArguments()[0];
                        return genericType.cast(((Fact)fact).getValue());
                    });
                    if (List.class == field.getType()) {
                        field.set(this._ruleObj, stream.collect(Collectors.toList()));
                        continue;
                    }
                    if (Set.class != field.getType()) continue;
                    field.set(this._ruleObj, stream.collect(Collectors.toSet()));
                    continue;
                }
                if (Map.class != field.getType()) continue;
                Map<Object, Object> map = this.getFactMap().keySet().stream().filter(key -> {
                    ParameterizedType paramType = (ParameterizedType)field.getGenericType();
                    Class genericType = (Class)paramType.getActualTypeArguments()[1];
                    return genericType.equals(this.getFactMap().getValue((String)key).getClass());
                }).collect(Collectors.toMap(key -> key, key -> this.getFactMap().getValue((String)key)));
                field.set(this._ruleObj, map);
            }
            catch (Exception ex) {
                LOGGER.error("Unable to update field '" + field.getName() + "' in rule object '" + this._ruleObj.getClass() + "'");
            }
        }
    }

    private Optional<BiFunction> getThenMethodAsBiFunction() {
        return AnnotationUtils.getAnnotatedField(com.deliveredtechnologies.rulebook.annotation.Result.class, this._ruleObj.getClass()).flatMap(resultField -> AnnotationUtils.getAnnotatedMethod(Then.class, this._ruleObj.getClass()).map(method -> this.toBiFunction((Method)method, (Field)resultField)));
    }

    private BiFunction toBiFunction(Method method, Field resultField) {
        return (factMap, resultObj) -> {
            try {
                Object retVal = method.invoke(this._ruleObj, new Object[0]);
                resultField.setAccessible(true);
                Object resultVal = resultField.get(this._ruleObj);
                if (resultVal != null) {
                    ((Result)resultObj).setValue(resultVal);
                }
                return retVal;
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                return RuleState.BREAK;
            }
        };
    }

    private Optional<Function> getThenMethodAsFunction() {
        if (AnnotationUtils.getAnnotatedField(com.deliveredtechnologies.rulebook.annotation.Result.class, this._ruleObj.getClass()).isPresent()) {
            return Optional.empty();
        }
        return AnnotationUtils.getAnnotatedMethod(Then.class, this._ruleObj.getClass()).map(method -> obj -> {
            try {
                return method.invoke(this._ruleObj, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                return RuleState.BREAK;
            }
        });
    }
}

