/*
 * Decompiled with CFR 0.152.
 */
package com.deliveredtechnologies.rulebook;

import com.deliveredtechnologies.rulebook.Fact;
import com.deliveredtechnologies.rulebook.FactMap;
import com.deliveredtechnologies.rulebook.Rule;
import com.deliveredtechnologies.rulebook.RuleState;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;

public class StandardRule<T>
implements Rule<T> {
    private Optional<Rule<T>> _nextRule = Optional.empty();
    private FactMap<T> _facts = new FactMap();
    private Predicate<FactMap<T>> _test;
    private Function<FactMap<T>, RuleState> _action;

    public static <T> StandardRule<T> create(Class<T> factType) {
        return new StandardRule<T>();
    }

    public static StandardRule<Object> create() {
        return new StandardRule<Object>();
    }

    @Override
    public void run() {
        if (this.getWhen().test(this._facts) && ((Function)this.getThen()).apply(this._facts) == RuleState.BREAK) {
            return;
        }
        this._nextRule.ifPresent(rule -> rule.given(this._facts));
        this._nextRule.ifPresent(Rule::run);
    }

    @Override
    public Rule<T> given(Fact<T> ... facts) {
        for (Fact<T> f : facts) {
            this._facts.put(f.getName(), f);
        }
        return this;
    }

    @Override
    public Rule<T> given(List<Fact<T>> facts) {
        for (Fact<T> f : facts) {
            this._facts.put(f.getName(), f);
        }
        return this;
    }

    @Override
    public Rule<T> given(FactMap<T> facts) {
        this._facts = facts;
        return this;
    }

    @Override
    public Rule<T> when(Predicate<FactMap<T>> test) {
        this._test = test;
        return this;
    }

    @Override
    public Rule<T> then(Function<FactMap<T>, RuleState> action) {
        this._action = action;
        return this;
    }

    @Override
    public void setNextRule(Rule<T> rule) {
        this._nextRule = Optional.ofNullable(rule);
    }

    @Override
    public Predicate<FactMap<T>> getWhen() {
        return this._test;
    }

    @Override
    public Object getThen() {
        return this._action;
    }
}

