/*
 * Decompiled with CFR 0.152.
 */
package com.deliveredtechnologies.rulebook;

import com.deliveredtechnologies.rulebook.Decision;
import com.deliveredtechnologies.rulebook.Fact;
import com.deliveredtechnologies.rulebook.FactMap;
import com.deliveredtechnologies.rulebook.Result;
import com.deliveredtechnologies.rulebook.Rule;
import com.deliveredtechnologies.rulebook.RuleState;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;

public class StandardDecision<T, U>
implements Decision<T, U> {
    private Optional<Rule<T>> _nextRule = Optional.empty();
    private FactMap<T> _facts = new FactMap();
    private Result<U> _result = new Result();
    private Predicate<FactMap<T>> _test;
    private Function<FactMap<T>, RuleState> _action;
    private Optional<BiFunction<FactMap<T>, Result<U>, RuleState>> _actionResult = Optional.empty();

    public static <T, U> StandardDecision<T, U> create(Class<T> factType, Class<U> returnType) {
        return new StandardDecision<T, U>();
    }

    public static StandardDecision<Object, Object> create() {
        return new StandardDecision<Object, Object>();
    }

    @Override
    public void run() {
        if (this.getWhen().test(this._facts) && (this.getThen() instanceof BiFunction ? ((BiFunction)this.getThen()).apply(this._facts, this._result) == RuleState.BREAK : ((Function)this.getThen()).apply(this._facts) == RuleState.BREAK)) {
            return;
        }
        this._nextRule.ifPresent(rule -> rule.given(this._facts));
        this._nextRule.ifPresent(Rule::run);
    }

    public StandardDecision<T, U> given(Fact<T> ... facts) {
        Arrays.stream(facts).forEach(fact -> this._facts.put(fact.getName(), fact));
        return this;
    }

    public StandardDecision<T, U> given(List<Fact<T>> facts) {
        facts.forEach(fact -> this._facts.put(fact.getName(), fact));
        return this;
    }

    public StandardDecision<T, U> given(FactMap<T> facts) {
        this._facts = facts;
        return this;
    }

    public StandardDecision<T, U> when(Predicate<FactMap<T>> test) {
        this._test = test;
        return this;
    }

    public StandardDecision<T, U> then(Function<FactMap<T>, RuleState> action) {
        this._action = action;
        return this;
    }

    @Override
    public StandardDecision<T, U> then(BiFunction<FactMap<T>, Result<U>, RuleState> action) {
        this._actionResult = Optional.ofNullable(action);
        return this;
    }

    @Override
    public void setNextRule(Rule<T> rule) {
        this._nextRule = Optional.ofNullable(rule);
    }

    @Override
    public U getResult() {
        return this._result.getValue();
    }

    @Override
    public void setResult(Result<U> result) {
        this._result = result;
    }

    public FactMap<T> getFactMap() {
        return this._facts;
    }

    @Override
    public Predicate<FactMap<T>> getWhen() {
        return this._test;
    }

    @Override
    public Object getThen() {
        return this._actionResult.map(Object.class::cast).orElse(this._action);
    }
}

