/*
 * Decompiled with CFR 0.152.
 */
package com.deliveredtechnologies.rulebook;

import com.deliveredtechnologies.rulebook.Fact;
import com.deliveredtechnologies.rulebook.Rule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public abstract class RuleBook<T> {
    protected Optional<Rule<T>> _headRule = Optional.empty();
    protected Rule<T> _tailRule;
    protected List<Fact<T>> _facts = new ArrayList<Fact<T>>();

    public final void run() {
        if (!this._headRule.isPresent()) {
            this.defineRules();
        }
        this._headRule.ifPresent(rule -> rule.given(this._facts));
        this._headRule.ifPresent(Rule::run);
    }

    @SafeVarargs
    public final RuleBook<T> given(Fact<T> ... facts) {
        Arrays.stream(facts).forEach(this._facts::add);
        return this;
    }

    public void addRule(Rule<T> rule) {
        if (rule == null) {
            return;
        }
        if (!this._headRule.isPresent()) {
            this._headRule = Optional.of(rule);
            this._tailRule = rule;
        } else {
            this._tailRule.setNextRule(rule);
            this._tailRule = rule;
        }
    }

    protected abstract void defineRules();
}

