/*
 * Decompiled with CFR 0.152.
 */
package com.codewaves.codehighlight.languages;

import com.codewaves.codehighlight.core.Keyword;
import com.codewaves.codehighlight.core.Language;
import com.codewaves.codehighlight.core.Mode;
import com.codewaves.codehighlight.languages.LanguageBuilder;

public class RubyLanguage
implements LanguageBuilder {
    @Override
    public Language build() {
        String RUBY_METHOD_RE = "[a-zA-Z_]\\w*[!?=]?|[-+~]\\@|<<|>>|=~|===?|<=>|[<>]=?|\\*\\*|[-/+%^&*~`|]|\\[\\]=?";
        String KEYWORDS = "and then defined module in return redo if BEGIN retry end for self when next until do begin unless END rescue else break undef not super class case require yield alias while ensure elsif or include attr_reader attr_writer attr_accessor";
        String LITERALS = "true false nil";
        Keyword[] RUBY_KEYWORDS = new Keyword[]{new Keyword("keyword", "and then defined module in return redo if BEGIN retry end for self when next until do begin unless END rescue else break undef not super class case require yield alias while ensure elsif or include attr_reader attr_writer attr_accessor"), new Keyword("literal", "true false nil")};
        Mode YARDOCTAG = new Mode().className("doctag").begin("@[A-Za-z]+");
        Mode IRB_OBJECT = new Mode().begin("#<").end(">");
        Mode[] COMMENT_MODES = new Mode[]{Mode.COMMENT("#", "$", new Mode().contains(new Mode[]{YARDOCTAG})), Mode.COMMENT("^\\=begin", "^\\=end", new Mode().contains(new Mode[]{YARDOCTAG}).relevance(10)), Mode.COMMENT("^__END_", "\\n$", null)};
        Mode SUBST = new Mode().className("subst").begin("#\\{").end("\\}").keywords(RUBY_KEYWORDS);
        Mode STRING = new Mode().className("string").contains(new Mode[]{Mode.BACKSLASH_ESCAPE, SUBST}).variants(new Mode[]{new Mode().begin("'").end("'"), new Mode().begin("\"").end("\""), new Mode().begin("`").end("`"), new Mode().begin("%[qQwWx]?\\(").end("\\)"), new Mode().begin("%[qQwWx]?\\[").end("\\]"), new Mode().begin("%[qQwWx]?\\{").end("\\}"), new Mode().begin("%[qQwWx]?<").end(">"), new Mode().begin("%[qQwWx]?/").end("/"), new Mode().begin("%[qQwWx]?%").end("%"), new Mode().begin("%[qQwWx]?-").end("-"), new Mode().begin("%[qQwWx]?\\|").end("\\|"), new Mode().begin("\\B\\?(\\\\\\d{1,3}|\\\\x[A-Fa-f0-9]{1,2}|\\\\u[A-Fa-f0-9]{4}|\\\\?\\S)\\b"), new Mode().begin("<<(-?)\\w+$").end("^\\s*\\w+$")});
        Mode PARAMS = new Mode().className("params").begin("\\(").end("\\)").endsParent().keywords(RUBY_KEYWORDS);
        Mode[] RUBY_DEFAULT_CONTAINS = Mode.mergeModes(new Mode[]{STRING, IRB_OBJECT, new Mode().className("class").beginKeywords(new Keyword[]{new Keyword("keyword", "class module")}).end("$|;").illegal("=").contains(Mode.mergeModes(new Mode[]{Mode.inherit(Mode.TITLE_MODE, new Mode().begin("[A-Za-z_]\\w*(::\\w+)*(\\?|\\!)?")), new Mode().begin("<\\s*").contains(new Mode[]{new Mode().begin("([a-zA-Z]\\w*::)?[a-zA-Z]\\w*")})}, COMMENT_MODES)), new Mode().className("function").beginKeywords(new Keyword[]{new Keyword("keyword", "def")}).end("$|;").contains(Mode.mergeModes(new Mode[]{Mode.inherit(Mode.TITLE_MODE, new Mode().begin("[a-zA-Z_]\\w*[!?=]?|[-+~]\\@|<<|>>|=~|===?|<=>|[<>]=?|\\*\\*|[-/+%^&*~`|]|\\[\\]=?")), PARAMS}, COMMENT_MODES)), new Mode().begin("[a-zA-Z]\\w*::"), new Mode().className("symbol").begin("[a-zA-Z_]\\w*(\\!|\\?)?:").relevance(0), new Mode().className("symbol").begin(":(?!\\s)").contains(new Mode[]{STRING, new Mode().begin("[a-zA-Z_]\\w*[!?=]?|[-+~]\\@|<<|>>|=~|===?|<=>|[<>]=?|\\*\\*|[-/+%^&*~`|]|\\[\\]=?")}).relevance(0), new Mode().className("number").begin("(\\b0[0-7_]+)|(\\b0x[0-9a-fA-F_]+)|(\\b[1-9][0-9_]*(\\.[0-9_]+)?)|[0_]\\b").relevance(0), new Mode().begin("(\\$\\W)|((\\$|\\@\\@?)(\\w+))"), new Mode().className("params").begin("\\|").end("\\|").keywords(RUBY_KEYWORDS), new Mode().begin("(!|!=|!==|%|%=|&|&&|&=|\\*|\\*=|\\+|\\+=|,|-|-=|/=|/|:|;|<<|<<=|<=|<|===|==|=|>>>=|>>=|>=|>>>|>>|>|\\?|\\[|\\{|\\(|\\^|\\^=|\\||\\|=|\\|\\||~|unless)\\s*").keywords(new Keyword[]{new Keyword("keyword", "unless")}).contains(Mode.mergeModes(new Mode[]{IRB_OBJECT, new Mode().className("regexp").contains(new Mode[]{Mode.BACKSLASH_ESCAPE, SUBST}).illegal("\\n").variants(new Mode[]{new Mode().begin("/").end("/[a-z]*"), new Mode().begin("%r\\{").end("\\}[a-z]*"), new Mode().begin("%r\\(").end("\\)[a-z]*"), new Mode().begin("%r!").end("![a-z]*"), new Mode().begin("%r\\[").end("\\][a-z]*")})}, COMMENT_MODES)).relevance(0)}, COMMENT_MODES);
        SUBST.contains(RUBY_DEFAULT_CONTAINS);
        PARAMS.contains(RUBY_DEFAULT_CONTAINS);
        String SIMPLE_PROMPT = "[>?]>";
        String DEFAULT_PROMPT = "[\\w#]+\\(\\w+\\):\\d+:\\d+>";
        String RVM_PROMPT = "(\\w+-)?\\d+\\.\\d+\\.\\d(p\\d+)?[^>]+>";
        Mode[] IRB_DEFAULT = new Mode[]{new Mode().begin("^\\s*=>").starts(new Mode().end("$").contains(RUBY_DEFAULT_CONTAINS)), new Mode().className("meta").begin("^([>?]>|[\\w#]+\\(\\w+\\):\\d+:\\d+>|(\\w+-)?\\d+\\.\\d+\\.\\d(p\\d+)?[^>]+>)").starts(new Mode().end("$").contains(RUBY_DEFAULT_CONTAINS))};
        return (Language)new Language().aliases(new String[]{"rb", "gemspec", "podspec", "thor", "irb"}).keywords(RUBY_KEYWORDS).illegal("\\/\\*").contains(Mode.mergeModes(Mode.mergeModes(COMMENT_MODES, IRB_DEFAULT), RUBY_DEFAULT_CONTAINS));
    }
}

