/*
 * Decompiled with CFR 0.152.
 */
package com.deepl.api;

import com.google.gson.annotations.SerializedName;
import org.jetbrains.annotations.Nullable;

public class DocumentStatus {
    @SerializedName(value="document_id")
    private final String documentId;
    @SerializedName(value="status")
    private final StatusCode status;
    @SerializedName(value="billed_characters")
    @Nullable
    private final Long billedCharacters;
    @SerializedName(value="seconds_remaining")
    @Nullable
    private final Long secondsRemaining;
    @SerializedName(value="error_message")
    @Nullable
    private final String errorMessage;

    public DocumentStatus(String documentId, StatusCode status, @Nullable Long billedCharacters, @Nullable Long secondsRemaining, @Nullable String errorMessage) {
        this.documentId = documentId;
        this.status = status;
        this.billedCharacters = billedCharacters;
        this.secondsRemaining = secondsRemaining;
        this.errorMessage = errorMessage;
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public StatusCode getStatus() {
        return this.status;
    }

    public boolean ok() {
        return this.status != null && this.status != StatusCode.Error;
    }

    public boolean done() {
        return this.status != null && this.status == StatusCode.Done;
    }

    @Nullable
    public Long getSecondsRemaining() {
        return this.secondsRemaining;
    }

    @Nullable
    public Long getBilledCharacters() {
        return this.billedCharacters;
    }

    @Nullable
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public static enum StatusCode {
        Queued,
        Translating,
        Done,
        Error;

    }
}

