/*
 * Decompiled with CFR 0.152.
 */
package com.deepl.api.parsing;

import com.deepl.api.DocumentHandle;
import com.deepl.api.DocumentStatus;
import com.deepl.api.Language;
import com.deepl.api.TextResult;
import com.deepl.api.Usage;
import com.deepl.api.parsing.ErrorResponse;
import com.deepl.api.parsing.LanguageDeserializer;
import com.deepl.api.parsing.TextResponse;
import com.deepl.api.parsing.TextResultDeserializer;
import com.deepl.api.parsing.UsageDeserializer;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class Parser {
    private final Gson gson;

    public Parser() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(TextResult.class, (Object)new TextResultDeserializer());
        gsonBuilder.registerTypeAdapter(Language.class, (Object)new LanguageDeserializer());
        gsonBuilder.registerTypeAdapter(Usage.class, (Object)new UsageDeserializer());
        this.gson = gsonBuilder.create();
    }

    public List<TextResult> parseTextResult(String json) {
        TextResponse result = (TextResponse)this.gson.fromJson(json, TextResponse.class);
        return result.translations;
    }

    public Usage parseUsage(String json) {
        return (Usage)this.gson.fromJson(json, Usage.class);
    }

    public List<Language> parseLanguages(String json) {
        Type languageListType = new TypeToken<ArrayList<Language>>(){}.getType();
        return (List)this.gson.fromJson(json, languageListType);
    }

    public DocumentStatus parseDocumentStatus(String json) {
        return (DocumentStatus)this.gson.fromJson(json, DocumentStatus.class);
    }

    public DocumentHandle parseDocumentHandle(String json) {
        return (DocumentHandle)this.gson.fromJson(json, DocumentHandle.class);
    }

    public String parseErrorMessage(String json) {
        ErrorResponse response = (ErrorResponse)this.gson.fromJson(json, ErrorResponse.class);
        if (response != null) {
            return response.getErrorMessage();
        }
        return "";
    }

    @Nullable
    static Integer getAsIntOrNull(JsonObject jsonObject, String parameterName) {
        if (!jsonObject.has(parameterName)) {
            return null;
        }
        return jsonObject.get(parameterName).getAsInt();
    }

    @Nullable
    static String getAsStringOrNull(JsonObject jsonObject, String parameterName) {
        if (!jsonObject.has(parameterName)) {
            return null;
        }
        return jsonObject.get(parameterName).getAsString();
    }

    @Nullable
    static Boolean getAsBooleanOrNull(JsonObject jsonObject, String parameterName) {
        if (!jsonObject.has(parameterName)) {
            return null;
        }
        return jsonObject.get(parameterName).getAsBoolean();
    }
}

