/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.statistics.result;

import com.day.crx.statistics.Report;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.QueryManager;
import org.apache.jackrabbit.util.ISO9075;

public class MostPopularResultsReport
extends Report {
    private int size = 10;
    private long date = System.currentTimeMillis();

    public MostPopularResultsReport(String dataPath) {
        super(dataPath);
    }

    public Iterator getResult(Session session) throws RepositoryException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM");
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this.getDate());
        QueryManager qm = session.getWorkspace().getQueryManager();
        StringBuffer stmt = new StringBuffer("/jcr:root");
        stmt.append(this.getDataPath());
        stmt.append("//");
        stmt.append(ISO9075.encode((String)".stats"));
        stmt.append("/");
        stmt.append(ISO9075.encodePath((String)sdf.format(cal.getTime())));
        stmt.append(" order by @count descending");
        NodeIterator nodes = qm.createQuery(stmt.toString(), "xpath").execute().getNodes();
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        int num = this.getSize();
        while (nodes.hasNext() && num-- > 0) {
            Node n = nodes.nextNode();
            long count = n.getProperty("count").getLong();
            String path = n.getAncestor(n.getDepth() - 3).getPath();
            path = path.substring(this.getDataPath().length());
            data.add(new Object[]{path, new Long(count), this.getQueries(n)});
        }
        return data.iterator();
    }

    private String[] getQueries(Node n) throws RepositoryException {
        if (n.hasProperty("queries")) {
            Value[] values = n.getProperty("queries").getValues();
            String[] queries = new String[values.length];
            for (int i = 0; i < queries.length; ++i) {
                queries[i] = values[i].getString();
            }
            return queries;
        }
        return new String[0];
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setDate(long date) {
        this.date = date;
    }

    public long getDate() {
        return this.date;
    }
}

