/*
 * Decompiled with CFR 0.152.
 */
package com.davidehrmann.vcdiff.io;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ComparingOutputStream
extends OutputStream {
    private final InputStream expected;
    private volatile boolean open = true;

    public ComparingOutputStream(InputStream expected) {
        this.expected = new BufferedInputStream(expected);
    }

    @Override
    public void write(int b) throws IOException {
        if (!this.open) {
            throw new IllegalStateException();
        }
        b &= 0xFF;
        int read = this.expected.read();
        if (read < 0) {
            throw new IOException("Decoded target is longer than original target file");
        }
        if (b != read) {
            throw new IOException("Original target file does not match decoded target");
        }
    }

    @Override
    public void close() throws IOException {
        this.open = false;
        if (this.expected.read() >= 0) {
            throw new IOException("Decoded target is shorter than original target file");
        }
    }
}

