/*
 * Decompiled with CFR 0.152.
 */
package com.davemorrissey.labs.subscaleview.decoder;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapRegionDecoder;
import android.graphics.Point;
import android.graphics.Rect;
import android.net.Uri;
import android.text.TextUtils;
import com.davemorrissey.labs.subscaleview.decoder.ImageRegionDecoder;
import java.io.InputStream;
import java.util.List;

public class SkiaImageRegionDecoder
implements ImageRegionDecoder {
    private BitmapRegionDecoder decoder;
    private final Object decoderLock = new Object();
    private static final String FILE_PREFIX = "file://";
    private static final String ASSET_PREFIX = "file:///android_asset/";
    private static final String RESOURCE_PREFIX = "android.resource://";
    private final Bitmap.Config bitmapConfig;

    public SkiaImageRegionDecoder() {
        this(null);
    }

    public SkiaImageRegionDecoder(Bitmap.Config bitmapConfig) {
        this.bitmapConfig = bitmapConfig == null ? Bitmap.Config.RGB_565 : bitmapConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Point init(Context context, Uri uri) throws Exception {
        String uriString = uri.toString();
        if (uriString.startsWith(RESOURCE_PREFIX)) {
            Resources res;
            String packageName = uri.getAuthority();
            if (context.getPackageName().equals(packageName)) {
                res = context.getResources();
            } else {
                PackageManager pm = context.getPackageManager();
                res = pm.getResourcesForApplication(packageName);
            }
            int id = 0;
            List segments = uri.getPathSegments();
            int size = segments.size();
            if (size == 2 && ((String)segments.get(0)).equals("drawable")) {
                String resName = (String)segments.get(1);
                id = res.getIdentifier(resName, "drawable", packageName);
            } else if (size == 1 && TextUtils.isDigitsOnly((CharSequence)((CharSequence)segments.get(0)))) {
                try {
                    id = Integer.parseInt((String)segments.get(0));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.decoder = BitmapRegionDecoder.newInstance((InputStream)context.getResources().openRawResource(id), (boolean)false);
        } else if (uriString.startsWith(ASSET_PREFIX)) {
            String assetName = uriString.substring(ASSET_PREFIX.length());
            this.decoder = BitmapRegionDecoder.newInstance((InputStream)context.getAssets().open(assetName, 1), (boolean)false);
        } else if (uriString.startsWith(FILE_PREFIX)) {
            this.decoder = BitmapRegionDecoder.newInstance((String)uriString.substring(FILE_PREFIX.length()), (boolean)false);
        } else {
            InputStream inputStream = null;
            try {
                ContentResolver contentResolver = context.getContentResolver();
                inputStream = contentResolver.openInputStream(uri);
                this.decoder = BitmapRegionDecoder.newInstance((InputStream)inputStream, (boolean)false);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return new Point(this.decoder.getWidth(), this.decoder.getHeight());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bitmap decodeRegion(Rect sRect, int sampleSize) {
        Object object = this.decoderLock;
        synchronized (object) {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inSampleSize = sampleSize;
            options.inPreferredConfig = this.bitmapConfig;
            Bitmap bitmap = this.decoder.decodeRegion(sRect, options);
            if (bitmap == null) {
                throw new RuntimeException("Skia image decoder returned null bitmap - image format may not be supported");
            }
            return bitmap;
        }
    }

    @Override
    public boolean isReady() {
        return this.decoder != null && !this.decoder.isRecycled();
    }

    @Override
    public void recycle() {
        this.decoder.recycle();
    }
}

