/*
 * Decompiled with CFR 0.152.
 */
package com.davemorrissey.labs.subscaleview.decoder;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.text.TextUtils;
import com.davemorrissey.labs.subscaleview.decoder.ImageDecoder;
import java.io.InputStream;
import java.util.List;

public class SkiaImageDecoder
implements ImageDecoder {
    private static final String FILE_PREFIX = "file://";
    private static final String ASSET_PREFIX = "file:///android_asset/";
    private static final String RESOURCE_PREFIX = "android.resource://";

    @Override
    public Bitmap decode(Context context, Uri uri) throws Exception {
        String uriString = uri.toString();
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inPreferredConfig = Bitmap.Config.RGB_565;
        if (uriString.startsWith(RESOURCE_PREFIX)) {
            Resources res;
            String packageName = uri.getAuthority();
            if (context.getPackageName().equals(packageName)) {
                res = context.getResources();
            } else {
                PackageManager pm = context.getPackageManager();
                res = pm.getResourcesForApplication(packageName);
            }
            int id = 0;
            List segments = uri.getPathSegments();
            int size = segments.size();
            if (size == 2 && ((String)segments.get(0)).equals("drawable")) {
                String resName = (String)segments.get(1);
                id = res.getIdentifier(resName, "drawable", packageName);
            } else if (size == 1 && TextUtils.isDigitsOnly((CharSequence)((CharSequence)segments.get(0)))) {
                try {
                    id = Integer.parseInt((String)segments.get(0));
                }
                catch (NumberFormatException ignored) {
                    // empty catch block
                }
            }
            return BitmapFactory.decodeResource((Resources)context.getResources(), (int)id, (BitmapFactory.Options)options);
        }
        if (uriString.startsWith(ASSET_PREFIX)) {
            String assetName = uriString.substring(ASSET_PREFIX.length());
            return BitmapFactory.decodeStream((InputStream)context.getAssets().open(assetName), null, (BitmapFactory.Options)options);
        }
        if (uriString.startsWith(FILE_PREFIX)) {
            return BitmapFactory.decodeFile((String)uriString.substring(FILE_PREFIX.length()), (BitmapFactory.Options)options);
        }
        ContentResolver contentResolver = context.getContentResolver();
        return BitmapFactory.decodeStream((InputStream)contentResolver.openInputStream(uri), null, (BitmapFactory.Options)options);
    }
}

