/*
 * Decompiled with CFR 0.152.
 */
package com.davemorrissey.labs.subscaleview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.FloatMath;
import android.util.Log;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import com.davemorrissey.labs.subscaleview.ImageViewState;
import com.davemorrissey.labs.subscaleview.R;
import com.davemorrissey.labs.subscaleview.decoder.ImageRegionDecoder;
import com.davemorrissey.labs.subscaleview.decoder.SkiaImageRegionDecoder;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SubsamplingScaleImageView
extends View {
    private static final String TAG = SubsamplingScaleImageView.class.getSimpleName();
    private static final String FILE_SCHEME = "file:///";
    private static final String ASSET_SCHEME = "file:///android_asset/";
    public static final int ORIENTATION_USE_EXIF = -1;
    public static final int ORIENTATION_0 = 0;
    public static final int ORIENTATION_90 = 90;
    public static final int ORIENTATION_180 = 180;
    public static final int ORIENTATION_270 = 270;
    private static final List<Integer> VALID_ORIENTATIONS = Arrays.asList(0, 90, 180, 270, -1);
    public static final int ZOOM_FOCUS_FIXED = 1;
    public static final int ZOOM_FOCUS_CENTER = 2;
    public static final int ZOOM_FOCUS_CENTER_IMMEDIATE = 3;
    private static final List<Integer> VALID_ZOOM_STYLES = Arrays.asList(1, 2, 3);
    public static final int EASE_OUT_QUAD = 1;
    public static final int EASE_IN_OUT_QUAD = 2;
    private static final List<Integer> VALID_EASING_STYLES = Arrays.asList(2, 1);
    public static final int PAN_LIMIT_INSIDE = 1;
    public static final int PAN_LIMIT_OUTSIDE = 2;
    public static final int PAN_LIMIT_CENTER = 3;
    private static final List<Integer> VALID_PAN_LIMITS = Arrays.asList(1, 2, 3);
    public static final int SCALE_TYPE_CENTER_INSIDE = 1;
    public static final int SCALE_TYPE_CENTER_CROP = 2;
    public static final int SCALE_TYPE_CUSTOM = 3;
    private static final List<Integer> VALID_SCALE_TYPES = Arrays.asList(2, 1, 3);
    private boolean debug = false;
    private int orientation = 0;
    private float maxScale = 2.0f;
    private float minScale = this.minScale();
    private int minimumTileDpi = -1;
    private int panLimit = 1;
    private int minimumScaleType = 1;
    private boolean panEnabled = true;
    private boolean zoomEnabled = true;
    private float doubleTapZoomScale = 1.0f;
    private int doubleTapZoomStyle = 1;
    private float scale;
    private float scaleStart;
    private PointF vTranslate;
    private PointF vTranslateStart;
    private Float pendingScale;
    private PointF sPendingCenter;
    private PointF sRequestedCenter;
    private int sWidth;
    private int sHeight;
    private int sOrientation;
    private boolean isZooming;
    private boolean isPanning;
    private int maxTouchCount;
    private GestureDetector detector;
    private ImageRegionDecoder decoder;
    private Class<? extends ImageRegionDecoder> decoderClass = SkiaImageRegionDecoder.class;
    private final Object decoderLock = new Object();
    private int fullImageSampleSize;
    private Map<Integer, List<Tile>> tileMap;
    private PointF vCenterStart;
    private float vDistStart;
    private Anim anim;
    private boolean readySent = false;
    private View.OnLongClickListener onLongClickListener;
    private Handler handler;
    private static final int MESSAGE_LONG_CLICK = 1;
    private Paint bitmapPaint;
    private Paint debugPaint;
    private Paint tileBgPaint;

    public SubsamplingScaleImageView(Context context, AttributeSet attr) {
        super(context, attr);
        this.setMinimumDpi(160);
        this.setDoubleTapZoomDpi(160);
        this.setGestureDetector(context);
        this.handler = new Handler(new Handler.Callback(){

            public boolean handleMessage(Message message) {
                if (message.what == 1 && SubsamplingScaleImageView.this.onLongClickListener != null) {
                    SubsamplingScaleImageView.this.maxTouchCount = 0;
                    SubsamplingScaleImageView.super.setOnLongClickListener(SubsamplingScaleImageView.this.onLongClickListener);
                    SubsamplingScaleImageView.this.performLongClick();
                    SubsamplingScaleImageView.super.setOnLongClickListener(null);
                }
                return true;
            }
        });
        if (attr != null) {
            int resId;
            String assetName;
            TypedArray typedAttr = this.getContext().obtainStyledAttributes(attr, R.styleable.SubsamplingScaleImageView);
            if (typedAttr.hasValue(1) && (assetName = typedAttr.getString(1)) != null && assetName.length() > 0) {
                this.setImageAsset(assetName);
            }
            if (typedAttr.hasValue(0) && (resId = typedAttr.getResourceId(0, 0)) > 0) {
                this.setImageResource(resId);
            }
            if (typedAttr.hasValue(2)) {
                this.setPanEnabled(typedAttr.getBoolean(2, true));
            }
            if (typedAttr.hasValue(3)) {
                this.setZoomEnabled(typedAttr.getBoolean(3, true));
            }
            if (typedAttr.hasValue(4)) {
                this.setTileBackgroundColor(typedAttr.getColor(4, Color.argb((int)0, (int)0, (int)0, (int)0)));
            }
        }
    }

    public SubsamplingScaleImageView(Context context) {
        this(context, null);
    }

    public final void setOrientation(int orientation) {
        if (!VALID_ORIENTATIONS.contains(orientation)) {
            throw new IllegalArgumentException("Invalid orientation: " + orientation);
        }
        this.orientation = orientation;
        this.reset(false);
        this.invalidate();
        this.requestLayout();
    }

    @Deprecated
    public final void setImageFile(String fileUri) {
        this.setImageUri(fileUri);
    }

    @Deprecated
    public final void setImageFile(String fileUri, ImageViewState state) {
        this.setImageUri(fileUri, state);
    }

    public final void setImageResource(int resId) {
        this.setImageResource(resId, null);
    }

    public final void setImageResource(int resId, ImageViewState state) {
        this.setImageUri("android.resource://" + this.getContext().getPackageName() + "/" + resId);
    }

    public final void setImageAsset(String assetName) {
        this.setImageAsset(assetName, null);
    }

    public final void setImageAsset(String assetName, ImageViewState state) {
        this.setImageUri(ASSET_SCHEME + assetName);
    }

    public final void setImageUri(String uri) {
        this.setImageUri(uri, null);
    }

    public final void setImageUri(String uri, ImageViewState state) {
        if (!uri.contains("://")) {
            if (uri.startsWith("/")) {
                uri = uri.substring(1);
            }
            uri = FILE_SCHEME + uri;
        }
        this.setImageUri(Uri.parse((String)uri), state);
    }

    public final void setImageUri(Uri uri) {
        this.setImageUri(uri, null);
    }

    public final void setImageUri(Uri uri, ImageViewState state) {
        this.reset(true);
        if (state != null) {
            this.restoreState(state);
        }
        BitmapInitTask task = new BitmapInitTask(this, this.getContext(), this.decoderClass, uri);
        task.execute(new Void[0]);
        this.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reset(boolean newImage) {
        this.scale = 0.0f;
        this.scaleStart = 0.0f;
        this.vTranslate = null;
        this.vTranslateStart = null;
        this.pendingScale = Float.valueOf(0.0f);
        this.sPendingCenter = null;
        this.sRequestedCenter = null;
        this.isZooming = false;
        this.isPanning = false;
        this.maxTouchCount = 0;
        this.fullImageSampleSize = 0;
        this.vCenterStart = null;
        this.vDistStart = 0.0f;
        this.anim = null;
        if (newImage) {
            if (this.decoder != null) {
                Object object = this.decoderLock;
                synchronized (object) {
                    this.decoder.recycle();
                    this.decoder = null;
                }
            }
            this.sWidth = 0;
            this.sHeight = 0;
            this.sOrientation = 0;
            this.readySent = false;
        }
        if (this.tileMap != null) {
            for (Map.Entry<Integer, List<Tile>> tileMapEntry : this.tileMap.entrySet()) {
                for (Tile tile : tileMapEntry.getValue()) {
                    tile.visible = false;
                    if (tile.bitmap == null) continue;
                    tile.bitmap.recycle();
                    tile.bitmap = null;
                }
            }
            this.tileMap = null;
        }
    }

    private void setGestureDetector(final Context context) {
        this.detector = new GestureDetector(context, (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
                if (SubsamplingScaleImageView.this.panEnabled && SubsamplingScaleImageView.this.readySent && SubsamplingScaleImageView.this.vTranslate != null && e1 != null && e2 != null && (Math.abs(e1.getX() - e2.getX()) > 50.0f || Math.abs(e1.getY() - e2.getY()) > 50.0f) && (Math.abs(velocityX) > 500.0f || Math.abs(velocityY) > 500.0f) && !SubsamplingScaleImageView.this.isZooming) {
                    PointF vTranslateEnd = new PointF(((SubsamplingScaleImageView)SubsamplingScaleImageView.this).vTranslate.x + velocityX * 0.25f, ((SubsamplingScaleImageView)SubsamplingScaleImageView.this).vTranslate.y + velocityY * 0.25f);
                    float sCenterXEnd = ((float)(SubsamplingScaleImageView.this.getWidth() / 2) - vTranslateEnd.x) / SubsamplingScaleImageView.this.scale;
                    float sCenterYEnd = ((float)(SubsamplingScaleImageView.this.getHeight() / 2) - vTranslateEnd.y) / SubsamplingScaleImageView.this.scale;
                    new AnimationBuilder(new PointF(sCenterXEnd, sCenterYEnd)).withEasing(1).withPanLimited(false).start();
                    return true;
                }
                return super.onFling(e1, e2, velocityX, velocityY);
            }

            public boolean onSingleTapConfirmed(MotionEvent e) {
                SubsamplingScaleImageView.this.performClick();
                return true;
            }

            public boolean onDoubleTap(MotionEvent e) {
                if (SubsamplingScaleImageView.this.zoomEnabled && SubsamplingScaleImageView.this.readySent && SubsamplingScaleImageView.this.vTranslate != null) {
                    float doubleTapZoomScale = Math.min(SubsamplingScaleImageView.this.maxScale, SubsamplingScaleImageView.this.doubleTapZoomScale);
                    boolean zoomIn = (double)SubsamplingScaleImageView.this.scale <= (double)doubleTapZoomScale * 0.9;
                    float targetScale = zoomIn ? doubleTapZoomScale : Math.min((float)SubsamplingScaleImageView.this.getWidth() / (float)SubsamplingScaleImageView.this.sWidth(), (float)SubsamplingScaleImageView.this.getHeight() / (float)SubsamplingScaleImageView.this.sHeight());
                    PointF targetSCenter = SubsamplingScaleImageView.this.viewToSourceCoord(new PointF(e.getX(), e.getY()));
                    if (SubsamplingScaleImageView.this.doubleTapZoomStyle == 3) {
                        SubsamplingScaleImageView.this.setScaleAndCenter(targetScale, targetSCenter);
                    } else if (SubsamplingScaleImageView.this.doubleTapZoomStyle == 2 || !zoomIn) {
                        new AnimationBuilder(targetScale, targetSCenter).withInterruptible(false).start();
                    } else if (SubsamplingScaleImageView.this.doubleTapZoomStyle == 1) {
                        new AnimationBuilder(targetScale, targetSCenter, new PointF(e.getX(), e.getY())).withInterruptible(false).start();
                    }
                    SubsamplingScaleImageView.this.setGestureDetector(context);
                    SubsamplingScaleImageView.this.invalidate();
                    return true;
                }
                return super.onDoubleTapEvent(e);
            }
        });
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        if (this.readySent) {
            this.setScaleAndCenter(this.getScale(), this.getCenter());
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthSpecMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightSpecMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int parentWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int parentHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        boolean resizeWidth = widthSpecMode != 0x40000000;
        boolean resizeHeight = heightSpecMode != 0x40000000;
        int width = parentWidth;
        int height = parentHeight;
        if (this.sWidth > 0 && this.sHeight > 0) {
            if (resizeWidth && resizeHeight) {
                width = this.sWidth();
                height = this.sHeight();
            } else if (resizeHeight) {
                height = (int)((double)this.sHeight() / (double)this.sWidth() * (double)width);
            } else if (resizeWidth) {
                width = (int)((double)this.sWidth() / (double)this.sHeight() * (double)height);
            }
        }
        width = Math.max(width, this.getSuggestedMinimumWidth());
        height = Math.max(height, this.getSuggestedMinimumHeight());
        this.setMeasuredDimension(width, height);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.anim != null && !this.anim.interruptible) {
            this.getParent().requestDisallowInterceptTouchEvent(true);
            return true;
        }
        this.anim = null;
        if (this.vTranslate == null) {
            return true;
        }
        if (this.detector == null || this.detector.onTouchEvent(event)) {
            this.isZooming = false;
            this.isPanning = false;
            this.maxTouchCount = 0;
            return true;
        }
        int touchCount = event.getPointerCount();
        switch (event.getAction()) {
            case 0: 
            case 5: 
            case 261: {
                this.anim = null;
                this.getParent().requestDisallowInterceptTouchEvent(true);
                this.maxTouchCount = Math.max(this.maxTouchCount, touchCount);
                if (touchCount >= 2) {
                    if (this.zoomEnabled) {
                        float distance = this.distance(event.getX(0), event.getX(1), event.getY(0), event.getY(1));
                        this.scaleStart = this.scale;
                        this.vDistStart = distance;
                        this.vTranslateStart = new PointF(this.vTranslate.x, this.vTranslate.y);
                        this.vCenterStart = new PointF((event.getX(0) + event.getX(1)) / 2.0f, (event.getY(0) + event.getY(1)) / 2.0f);
                    } else {
                        this.maxTouchCount = 0;
                    }
                    this.handler.removeMessages(1);
                } else {
                    this.vTranslateStart = new PointF(this.vTranslate.x, this.vTranslate.y);
                    this.vCenterStart = new PointF(event.getX(), event.getY());
                    this.handler.sendEmptyMessageDelayed(1, 600L);
                }
                return true;
            }
            case 2: {
                boolean consumed = false;
                if (this.maxTouchCount > 0) {
                    if (touchCount >= 2) {
                        float vDistEnd = this.distance(event.getX(0), event.getX(1), event.getY(0), event.getY(1));
                        PointF vCenterEnd = new PointF((event.getX(0) + event.getX(1)) / 2.0f, (event.getY(0) + event.getY(1)) / 2.0f);
                        if (this.zoomEnabled && (this.distance(this.vCenterStart.x, vCenterEnd.x, this.vCenterStart.y, vCenterEnd.y) > 5.0f || Math.abs(vDistEnd - this.vDistStart) > 5.0f || this.isPanning)) {
                            this.isZooming = true;
                            this.isPanning = true;
                            consumed = true;
                            this.scale = Math.min(this.maxScale, vDistEnd / this.vDistStart * this.scaleStart);
                            if (this.scale <= this.minScale()) {
                                this.vDistStart = vDistEnd;
                                this.scaleStart = this.minScale();
                                this.vCenterStart = vCenterEnd;
                                this.vTranslateStart = this.vTranslate;
                            } else if (this.panEnabled) {
                                float vLeftStart = this.vCenterStart.x - this.vTranslateStart.x;
                                float vTopStart = this.vCenterStart.y - this.vTranslateStart.y;
                                float vLeftNow = vLeftStart * (this.scale / this.scaleStart);
                                float vTopNow = vTopStart * (this.scale / this.scaleStart);
                                this.vTranslate.x = vCenterEnd.x - vLeftNow;
                                this.vTranslate.y = vCenterEnd.y - vTopNow;
                            } else if (this.sRequestedCenter != null) {
                                this.vTranslate.x = (float)(this.getWidth() / 2) - this.scale * this.sRequestedCenter.x;
                                this.vTranslate.y = (float)(this.getHeight() / 2) - this.scale * this.sRequestedCenter.y;
                            } else {
                                this.vTranslate.x = (float)(this.getWidth() / 2) - this.scale * (float)(this.sWidth() / 2);
                                this.vTranslate.y = (float)(this.getHeight() / 2) - this.scale * (float)(this.sHeight() / 2);
                            }
                            this.fitToBounds(true);
                            this.refreshRequiredTiles(false);
                        }
                    } else if (!this.isZooming) {
                        float dx = Math.abs(event.getX() - this.vCenterStart.x);
                        float dy = Math.abs(event.getY() - this.vCenterStart.y);
                        if (dx > 5.0f || dy > 5.0f || this.isPanning) {
                            boolean yPan;
                            consumed = true;
                            this.vTranslate.x = this.vTranslateStart.x + (event.getX() - this.vCenterStart.x);
                            this.vTranslate.y = this.vTranslateStart.y + (event.getY() - this.vCenterStart.y);
                            float lastX = this.vTranslate.x;
                            float lastY = this.vTranslate.y;
                            this.fitToBounds(true);
                            boolean atXEdge = lastX != this.vTranslate.x;
                            boolean edgeXSwipe = atXEdge && dx > dy && !this.isPanning;
                            boolean bl = yPan = lastY == this.vTranslate.y && dy > 15.0f;
                            if (!edgeXSwipe && (!atXEdge || yPan || this.isPanning)) {
                                this.isPanning = true;
                            } else if (dx > 5.0f) {
                                this.maxTouchCount = 0;
                                this.handler.removeMessages(1);
                                this.getParent().requestDisallowInterceptTouchEvent(false);
                            }
                            if (!this.panEnabled) {
                                this.vTranslate.x = this.vTranslateStart.x;
                                this.vTranslate.y = this.vTranslateStart.y;
                                this.getParent().requestDisallowInterceptTouchEvent(false);
                            }
                            this.refreshRequiredTiles(false);
                        }
                    }
                }
                if (!consumed) break;
                this.handler.removeMessages(1);
                this.invalidate();
                return true;
            }
            case 1: 
            case 6: 
            case 262: {
                this.handler.removeMessages(1);
                if (this.maxTouchCount > 0 && (this.isZooming || this.isPanning)) {
                    if (this.isZooming && touchCount == 2) {
                        this.isPanning = true;
                        this.vTranslateStart = new PointF(this.vTranslate.x, this.vTranslate.y);
                        this.vCenterStart = event.getActionIndex() == 1 ? new PointF(event.getX(0), event.getY(0)) : new PointF(event.getX(1), event.getY(1));
                    }
                    if (touchCount < 3) {
                        this.isZooming = false;
                    }
                    if (touchCount < 2) {
                        this.isPanning = false;
                        this.maxTouchCount = 0;
                    }
                    this.refreshRequiredTiles(true);
                    return true;
                }
                if (touchCount == 1) {
                    this.isZooming = false;
                    this.isPanning = false;
                    this.maxTouchCount = 0;
                }
                return true;
            }
        }
        return super.onTouchEvent(event);
    }

    public void setOnLongClickListener(View.OnLongClickListener onLongClickListener) {
        this.onLongClickListener = onLongClickListener;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.createPaints();
        if (this.sWidth == 0 || this.sHeight == 0 || this.decoder == null || this.getWidth() == 0 || this.getHeight() == 0) {
            return;
        }
        if (this.tileMap == null) {
            this.initialiseBaseLayer(this.getMaxBitmapDimensions(canvas));
            return;
        }
        if (this.sPendingCenter != null && this.pendingScale != null) {
            this.scale = this.pendingScale.floatValue();
            this.vTranslate.x = (float)(this.getWidth() / 2) - this.scale * this.sPendingCenter.x;
            this.vTranslate.y = (float)(this.getHeight() / 2) - this.scale * this.sPendingCenter.y;
            this.sPendingCenter = null;
            this.pendingScale = null;
            this.fitToBounds(true);
            this.refreshRequiredTiles(true);
        }
        this.fitToBounds(false);
        if (!this.readySent) {
            this.readySent = true;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    SubsamplingScaleImageView.this.onImageReady();
                }
            }).start();
        }
        if (this.anim != null) {
            long scaleElapsed = System.currentTimeMillis() - this.anim.time;
            boolean finished = scaleElapsed > this.anim.duration;
            scaleElapsed = Math.min(scaleElapsed, this.anim.duration);
            this.scale = this.ease(this.anim.easing, scaleElapsed, this.anim.scaleStart, this.anim.scaleEnd - this.anim.scaleStart, this.anim.duration);
            float vFocusNowX = this.ease(this.anim.easing, scaleElapsed, ((Anim)this.anim).vFocusStart.x, ((Anim)this.anim).vFocusEnd.x - ((Anim)this.anim).vFocusStart.x, this.anim.duration);
            float vFocusNowY = this.ease(this.anim.easing, scaleElapsed, ((Anim)this.anim).vFocusStart.y, ((Anim)this.anim).vFocusEnd.y - ((Anim)this.anim).vFocusStart.y, this.anim.duration);
            PointF vFocus = this.sourceToViewCoord(this.anim.sCenterEnd);
            this.vTranslate.x -= vFocus.x - vFocusNowX;
            this.vTranslate.y -= vFocus.y - vFocusNowY;
            this.fitToBounds(finished || this.anim.scaleStart == this.anim.scaleEnd);
            this.refreshRequiredTiles(finished);
            if (finished) {
                this.anim = null;
            }
            this.invalidate();
        }
        int sampleSize = Math.min(this.fullImageSampleSize, this.calculateInSampleSize());
        boolean hasMissingTiles = false;
        for (Map.Entry<Integer, List<Tile>> tileMapEntry : this.tileMap.entrySet()) {
            if (tileMapEntry.getKey() != sampleSize) continue;
            for (Tile tile : tileMapEntry.getValue()) {
                if (!tile.visible || !tile.loading && tile.bitmap != null) continue;
                hasMissingTiles = true;
            }
        }
        for (Map.Entry<Integer, List<Tile>> tileMapEntry : this.tileMap.entrySet()) {
            if (tileMapEntry.getKey() != sampleSize && !hasMissingTiles) continue;
            for (Tile tile : tileMapEntry.getValue()) {
                Rect vRect = this.convertRect(this.sourceToViewRect(tile.sRect));
                if (!tile.loading && tile.bitmap != null) {
                    if (this.tileBgPaint != null) {
                        canvas.drawRect(vRect, this.tileBgPaint);
                    }
                    canvas.drawBitmap(tile.bitmap, null, vRect, this.bitmapPaint);
                    if (this.debug) {
                        canvas.drawRect(vRect, this.debugPaint);
                    }
                } else if (tile.loading && this.debug) {
                    canvas.drawText("LOADING", (float)(vRect.left + 5), (float)(vRect.top + 35), this.debugPaint);
                }
                if (!tile.visible || !this.debug) continue;
                canvas.drawText("ISS " + tile.sampleSize + " RECT " + ((Tile)tile).sRect.top + "," + ((Tile)tile).sRect.left + "," + ((Tile)tile).sRect.bottom + "," + ((Tile)tile).sRect.right, (float)(vRect.left + 5), (float)(vRect.top + 15), this.debugPaint);
            }
        }
        if (this.debug) {
            canvas.drawText("Scale: " + String.format("%.2f", Float.valueOf(this.scale)), 5.0f, 15.0f, this.debugPaint);
            canvas.drawText("Translate: " + String.format("%.2f", Float.valueOf(this.vTranslate.x)) + ":" + String.format("%.2f", Float.valueOf(this.vTranslate.y)), 5.0f, 35.0f, this.debugPaint);
            PointF center = this.getCenter();
            canvas.drawText("Source center: " + String.format("%.2f", Float.valueOf(center.x)) + ":" + String.format("%.2f", Float.valueOf(center.y)), 5.0f, 55.0f, this.debugPaint);
            if (this.anim != null) {
                PointF vCenterStart = this.sourceToViewCoord(this.anim.sCenterStart);
                PointF vCenterEndRequested = this.sourceToViewCoord(this.anim.sCenterEndRequested);
                PointF vCenterEnd = this.sourceToViewCoord(this.anim.sCenterEnd);
                canvas.drawCircle(vCenterStart.x, vCenterStart.y, 10.0f, this.debugPaint);
                canvas.drawCircle(vCenterEndRequested.x, vCenterEndRequested.y, 20.0f, this.debugPaint);
                canvas.drawCircle(vCenterEnd.x, vCenterEnd.y, 25.0f, this.debugPaint);
                canvas.drawCircle((float)(this.getWidth() / 2), (float)(this.getHeight() / 2), 30.0f, this.debugPaint);
            }
        }
    }

    private void createPaints() {
        if (this.bitmapPaint == null) {
            this.bitmapPaint = new Paint();
            this.bitmapPaint.setAntiAlias(true);
            this.bitmapPaint.setFilterBitmap(true);
            this.bitmapPaint.setDither(true);
        }
        if (this.debugPaint == null && this.debug) {
            this.debugPaint = new Paint();
            this.debugPaint.setTextSize(18.0f);
            this.debugPaint.setColor(-65281);
            this.debugPaint.setStyle(Paint.Style.STROKE);
        }
    }

    private synchronized void initialiseBaseLayer(Point maxTileDimensions) {
        this.fitToBounds(true);
        this.fullImageSampleSize = this.calculateInSampleSize();
        if (this.fullImageSampleSize > 1) {
            this.fullImageSampleSize /= 2;
        }
        this.initialiseTileMap(maxTileDimensions);
        List<Tile> baseGrid = this.tileMap.get(this.fullImageSampleSize);
        for (Tile baseTile : baseGrid) {
            BitmapTileTask task = new BitmapTileTask(this, this.decoder, this.decoderLock, baseTile);
            task.execute(new Void[0]);
        }
    }

    private void refreshRequiredTiles(boolean load) {
        int sampleSize = Math.min(this.fullImageSampleSize, this.calculateInSampleSize());
        RectF vVisRect = new RectF(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight());
        RectF sVisRect = this.viewToSourceRect(vVisRect);
        for (Map.Entry<Integer, List<Tile>> tileMapEntry : this.tileMap.entrySet()) {
            for (Tile tile : tileMapEntry.getValue()) {
                if (tile.sampleSize < sampleSize || tile.sampleSize > sampleSize && tile.sampleSize != this.fullImageSampleSize) {
                    tile.visible = false;
                    if (tile.bitmap != null) {
                        tile.bitmap.recycle();
                        tile.bitmap = null;
                    }
                }
                if (tile.sampleSize == sampleSize) {
                    if (RectF.intersects((RectF)sVisRect, (RectF)this.convertRect(tile.sRect))) {
                        tile.visible = true;
                        if (tile.loading || tile.bitmap != null || !load) continue;
                        BitmapTileTask task = new BitmapTileTask(this, this.decoder, this.decoderLock, tile);
                        task.execute(new Void[0]);
                        continue;
                    }
                    if (tile.sampleSize == this.fullImageSampleSize) continue;
                    tile.visible = false;
                    if (tile.bitmap == null) continue;
                    tile.bitmap.recycle();
                    tile.bitmap = null;
                    continue;
                }
                if (tile.sampleSize != this.fullImageSampleSize) continue;
                tile.visible = true;
            }
        }
    }

    private int calculateInSampleSize() {
        float adjustedScale = this.scale;
        if (this.minimumTileDpi > 0) {
            DisplayMetrics metrics = this.getResources().getDisplayMetrics();
            float averageDpi = (metrics.xdpi + metrics.ydpi) / 2.0f;
            adjustedScale = (float)this.minimumTileDpi / averageDpi * this.scale;
        }
        int reqWidth = (int)((float)this.sWidth() * adjustedScale);
        int reqHeight = (int)((float)this.sHeight() * adjustedScale);
        int inSampleSize = 1;
        if (reqWidth == 0 || reqHeight == 0) {
            return 32;
        }
        if (this.sHeight() > reqHeight || this.sWidth() > reqWidth) {
            int widthRatio;
            int heightRatio = Math.round((float)this.sHeight() / (float)reqHeight);
            inSampleSize = heightRatio < (widthRatio = Math.round((float)this.sWidth() / (float)reqWidth)) ? heightRatio : widthRatio;
        }
        int power = 1;
        while (power * 2 < inSampleSize) {
            power *= 2;
        }
        return power;
    }

    private void fitToBounds(boolean center, ScaleAndTranslate scaleAndTranslate) {
        float maxTy;
        float maxTx;
        if (this.panLimit == 2 && this.isImageReady()) {
            center = false;
        }
        PointF vTranslate = scaleAndTranslate.translate;
        float scale = this.limitedScale(scaleAndTranslate.scale);
        float scaleWidth = scale * (float)this.sWidth();
        float scaleHeight = scale * (float)this.sHeight();
        if (this.panLimit == 3 && this.isImageReady()) {
            vTranslate.x = Math.max(vTranslate.x, (float)(this.getWidth() / 2) - scaleWidth);
            vTranslate.y = Math.max(vTranslate.y, (float)(this.getHeight() / 2) - scaleHeight);
        } else if (center) {
            vTranslate.x = Math.max(vTranslate.x, (float)this.getWidth() - scaleWidth);
            vTranslate.y = Math.max(vTranslate.y, (float)this.getHeight() - scaleHeight);
        } else {
            vTranslate.x = Math.max(vTranslate.x, -scaleWidth);
            vTranslate.y = Math.max(vTranslate.y, -scaleHeight);
        }
        if (this.panLimit == 3 && this.isImageReady()) {
            maxTx = Math.max(0, this.getWidth() / 2);
            maxTy = Math.max(0, this.getHeight() / 2);
        } else if (center) {
            maxTx = Math.max(0.0f, ((float)this.getWidth() - scaleWidth) / 2.0f);
            maxTy = Math.max(0.0f, ((float)this.getHeight() - scaleHeight) / 2.0f);
        } else {
            maxTx = Math.max(0, this.getWidth());
            maxTy = Math.max(0, this.getHeight());
        }
        vTranslate.x = Math.min(vTranslate.x, maxTx);
        vTranslate.y = Math.min(vTranslate.y, maxTy);
        scaleAndTranslate.scale = scale;
    }

    private void fitToBounds(boolean center) {
        boolean init = false;
        if (this.vTranslate == null) {
            init = true;
            this.vTranslate = new PointF(0.0f, 0.0f);
        }
        ScaleAndTranslate input = new ScaleAndTranslate(this.scale, this.vTranslate);
        this.fitToBounds(center, input);
        this.scale = input.scale;
        if (init) {
            this.vTranslate = this.vTranslateForSCenter(new PointF((float)(this.sWidth() / 2), (float)(this.sHeight() / 2)), this.scale);
        }
    }

    private void initialiseTileMap(Point maxTileDimensions) {
        this.tileMap = new LinkedHashMap<Integer, List<Tile>>();
        int sampleSize = this.fullImageSampleSize;
        int xTiles = 1;
        int yTiles = 1;
        while (true) {
            int sTileWidth = this.sWidth() / xTiles;
            int sTileHeight = this.sHeight() / yTiles;
            int subTileWidth = sTileWidth / sampleSize;
            int subTileHeight = sTileHeight / sampleSize;
            while (subTileWidth > maxTileDimensions.x || (double)subTileWidth > (double)this.getWidth() * 1.25 && sampleSize < this.fullImageSampleSize) {
                sTileWidth = this.sWidth() / ++xTiles;
                subTileWidth = sTileWidth / sampleSize;
            }
            while (subTileHeight > maxTileDimensions.y || (double)subTileHeight > (double)this.getHeight() * 1.25 && sampleSize < this.fullImageSampleSize) {
                sTileHeight = this.sHeight() / ++yTiles;
                subTileHeight = sTileHeight / sampleSize;
            }
            ArrayList<Tile> tileGrid = new ArrayList<Tile>(xTiles * yTiles);
            for (int x = 0; x < xTiles; ++x) {
                for (int y = 0; y < yTiles; ++y) {
                    Tile tile = new Tile();
                    tile.sampleSize = sampleSize;
                    tile.visible = sampleSize == this.fullImageSampleSize;
                    tile.sRect = new Rect(x * sTileWidth, y * sTileHeight, (x + 1) * sTileWidth, (y + 1) * sTileHeight);
                    tileGrid.add(tile);
                }
            }
            this.tileMap.put(sampleSize, tileGrid);
            if (sampleSize == 1) break;
            sampleSize /= 2;
        }
    }

    private void onImageInited(ImageRegionDecoder decoder, int sWidth, int sHeight, int sOrientation) {
        this.decoder = decoder;
        this.sWidth = sWidth;
        this.sHeight = sHeight;
        this.sOrientation = sOrientation;
        this.requestLayout();
        this.invalidate();
    }

    private void onTileLoaded() {
        this.invalidate();
    }

    private void restoreState(ImageViewState state) {
        if (state != null && state.getCenter() != null && VALID_ORIENTATIONS.contains(state.getOrientation())) {
            this.orientation = state.getOrientation();
            this.pendingScale = Float.valueOf(state.getScale());
            this.sPendingCenter = state.getCenter();
            this.invalidate();
        }
    }

    private Point getMaxBitmapDimensions(Canvas canvas) {
        if (Build.VERSION.SDK_INT >= 14) {
            try {
                int maxWidth = (Integer)Canvas.class.getMethod("getMaximumBitmapWidth", new Class[0]).invoke((Object)canvas, new Object[0]);
                int maxHeight = (Integer)Canvas.class.getMethod("getMaximumBitmapHeight", new Class[0]).invoke((Object)canvas, new Object[0]);
                return new Point(maxWidth, maxHeight);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new Point(2048, 2048);
    }

    private int sWidth() {
        int rotation = this.getRequiredRotation();
        if (rotation == 90 || rotation == 270) {
            return this.sHeight;
        }
        return this.sWidth;
    }

    private int sHeight() {
        int rotation = this.getRequiredRotation();
        if (rotation == 90 || rotation == 270) {
            return this.sWidth;
        }
        return this.sHeight;
    }

    private Rect fileSRect(Rect sRect) {
        if (this.getRequiredRotation() == 0) {
            return sRect;
        }
        if (this.getRequiredRotation() == 90) {
            return new Rect(sRect.top, this.sHeight - sRect.right, sRect.bottom, this.sHeight - sRect.left);
        }
        if (this.getRequiredRotation() == 180) {
            return new Rect(this.sWidth - sRect.right, this.sHeight - sRect.bottom, this.sWidth - sRect.left, this.sHeight - sRect.top);
        }
        return new Rect(this.sWidth - sRect.bottom, sRect.left, this.sWidth - sRect.top, sRect.right);
    }

    private int getRequiredRotation() {
        if (this.orientation == -1) {
            return this.sOrientation;
        }
        return this.orientation;
    }

    private float distance(float x0, float x1, float y0, float y1) {
        float x = x0 - x1;
        float y = y0 - y1;
        return FloatMath.sqrt((float)(x * x + y * y));
    }

    public final PointF viewToSourceCoord(PointF vxy) {
        return this.viewToSourceCoord(vxy.x, vxy.y);
    }

    public final PointF viewToSourceCoord(float vx, float vy) {
        if (this.vTranslate == null) {
            return null;
        }
        float sx = (vx - this.vTranslate.x) / this.scale;
        float sy = (vy - this.vTranslate.y) / this.scale;
        return new PointF(sx, sy);
    }

    public final PointF sourceToViewCoord(PointF sxy) {
        return this.sourceToViewCoord(sxy.x, sxy.y);
    }

    public final PointF sourceToViewCoord(float sx, float sy) {
        if (this.vTranslate == null) {
            return null;
        }
        float vx = sx * this.scale + this.vTranslate.x;
        float vy = sy * this.scale + this.vTranslate.y;
        return new PointF(vx, vy);
    }

    private RectF sourceToViewRect(Rect sRect) {
        return this.sourceToViewRect(this.convertRect(sRect));
    }

    private RectF sourceToViewRect(RectF sRect) {
        PointF vLT = this.sourceToViewCoord(new PointF(sRect.left, sRect.top));
        PointF vRB = this.sourceToViewCoord(new PointF(sRect.right, sRect.bottom));
        return new RectF(vLT.x, vLT.y, vRB.x, vRB.y);
    }

    private RectF viewToSourceRect(RectF vRect) {
        PointF sLT = this.viewToSourceCoord(new PointF(vRect.left, vRect.top));
        PointF sRB = this.viewToSourceCoord(new PointF(vRect.right, vRect.bottom));
        return new RectF(sLT.x, sLT.y, sRB.x, sRB.y);
    }

    private RectF convertRect(Rect rect) {
        return new RectF((float)rect.left, (float)rect.top, (float)rect.right, (float)rect.bottom);
    }

    private Rect convertRect(RectF rect) {
        return new Rect((int)rect.left, (int)rect.top, (int)rect.right, (int)rect.bottom);
    }

    private PointF vTranslateForSCenter(PointF sCenter, float scale) {
        PointF vTranslate = new PointF((float)(this.getWidth() / 2) - sCenter.x * scale, (float)(this.getHeight() / 2) - sCenter.y * scale);
        ScaleAndTranslate sat = new ScaleAndTranslate(scale, vTranslate);
        this.fitToBounds(true, sat);
        return vTranslate;
    }

    private PointF limitedSCenter(PointF sCenter, float scale) {
        PointF vTranslate = this.vTranslateForSCenter(sCenter, scale);
        int mY = this.getHeight() / 2;
        float sx = ((float)(this.getWidth() / 2) - vTranslate.x) / scale;
        float sy = ((float)(this.getHeight() / 2) - vTranslate.y) / scale;
        return new PointF(sx, sy);
    }

    private float minScale() {
        if (this.minimumScaleType == 1) {
            return Math.min((float)this.getWidth() / (float)this.sWidth(), (float)this.getHeight() / (float)this.sHeight());
        }
        if (this.minimumScaleType == 3) {
            return this.minScale;
        }
        return Math.max((float)this.getWidth() / (float)this.sWidth(), (float)this.getHeight() / (float)this.sHeight());
    }

    private float limitedScale(float targetScale) {
        targetScale = Math.max(this.minScale(), targetScale);
        targetScale = Math.min(this.maxScale, targetScale);
        return targetScale;
    }

    private float ease(int type, long time, float from, float change, long duration) {
        switch (type) {
            case 2: {
                return this.easeInOutQuad(time, from, change, duration);
            }
            case 1: {
                return this.easeOutQuad(time, from, change, duration);
            }
        }
        throw new IllegalStateException("Unexpected easing type: " + type);
    }

    private float easeOutQuad(long time, float from, float change, long duration) {
        float progress = (float)time / (float)duration;
        return -change * progress * (progress - 2.0f) + from;
    }

    private float easeInOutQuad(long time, float from, float change, long duration) {
        float timeF = (float)time / ((float)duration / 2.0f);
        if (timeF < 1.0f) {
            return change / 2.0f * timeF * timeF + from;
        }
        return -change / 2.0f * ((timeF -= 1.0f) * (timeF - 2.0f) - 1.0f) + from;
    }

    public final void setDecoderClass(Class<? extends ImageRegionDecoder> decoderClass) {
        if (decoderClass == null) {
            throw new IllegalArgumentException("Decoder class cannot be set to null");
        }
        this.decoderClass = decoderClass;
    }

    public final void setPanLimit(int panLimit) {
        if (!VALID_PAN_LIMITS.contains(panLimit)) {
            throw new IllegalArgumentException("Invalid pan limit: " + panLimit);
        }
        this.panLimit = panLimit;
        if (this.isImageReady()) {
            this.fitToBounds(true);
            this.invalidate();
        }
    }

    public final void setMinimumScaleType(int scaleType) {
        if (!VALID_SCALE_TYPES.contains(scaleType)) {
            throw new IllegalArgumentException("Invalid scale type: " + scaleType);
        }
        this.minimumScaleType = scaleType;
        if (this.isImageReady()) {
            this.fitToBounds(true);
            this.invalidate();
        }
    }

    public final void setMaxScale(float maxScale) {
        this.maxScale = maxScale;
    }

    public final void setMinScale(float minScale) {
        this.minScale = minScale;
    }

    public final void setMinimumDpi(int dpi) {
        DisplayMetrics metrics = this.getResources().getDisplayMetrics();
        float averageDpi = (metrics.xdpi + metrics.ydpi) / 2.0f;
        this.setMaxScale(averageDpi / (float)dpi);
    }

    public final void setMaximumDpi(int dpi) {
        DisplayMetrics metrics = this.getResources().getDisplayMetrics();
        float averageDpi = (metrics.xdpi + metrics.ydpi) / 2.0f;
        this.setMinScale(averageDpi / (float)dpi);
    }

    public float getMaxScale() {
        return this.maxScale;
    }

    public final float getMinScale() {
        return this.minScale();
    }

    public void setMinimumTileDpi(int minimumTileDpi) {
        DisplayMetrics metrics = this.getResources().getDisplayMetrics();
        float averageDpi = (metrics.xdpi + metrics.ydpi) / 2.0f;
        this.minimumTileDpi = (int)Math.min(averageDpi, (float)minimumTileDpi);
        if (this.isImageReady()) {
            this.reset(false);
            this.invalidate();
        }
    }

    public final PointF getCenter() {
        int mX = this.getWidth() / 2;
        int mY = this.getHeight() / 2;
        return this.viewToSourceCoord(mX, mY);
    }

    public final float getScale() {
        return this.scale;
    }

    public final void setScaleAndCenter(float scale, PointF sCenter) {
        this.anim = null;
        this.pendingScale = Float.valueOf(scale);
        this.sPendingCenter = sCenter;
        this.sRequestedCenter = sCenter;
        this.invalidate();
    }

    public final void resetScaleAndCenter() {
        this.anim = null;
        this.pendingScale = Float.valueOf(this.limitedScale(0.0f));
        this.sPendingCenter = this.isImageReady() ? new PointF((float)(this.sWidth() / 2), (float)(this.sHeight() / 2)) : new PointF(0.0f, 0.0f);
        this.invalidate();
    }

    protected void onImageReady() {
    }

    public final boolean isImageReady() {
        return this.readySent && this.vTranslate != null && this.tileMap != null && this.sWidth > 0 && this.sHeight > 0;
    }

    public final int getSWidth() {
        return this.sWidth;
    }

    public final int getSHeight() {
        return this.sHeight;
    }

    public final int getOrientation() {
        return this.orientation;
    }

    public final int getAppliedOrientation() {
        return this.getRequiredRotation();
    }

    public final ImageViewState getState() {
        if (this.vTranslate != null && this.sWidth > 0 && this.sHeight > 0) {
            return new ImageViewState(this.getScale(), this.getCenter(), this.getOrientation());
        }
        return null;
    }

    public final boolean isZoomEnabled() {
        return this.zoomEnabled;
    }

    public final void setZoomEnabled(boolean zoomEnabled) {
        this.zoomEnabled = zoomEnabled;
    }

    public final boolean isPanEnabled() {
        return this.panEnabled;
    }

    public final void setPanEnabled(boolean panEnabled) {
        this.panEnabled = panEnabled;
        if (!panEnabled && this.vTranslate != null) {
            this.vTranslate.x = (float)(this.getWidth() / 2) - this.scale * (float)(this.sWidth() / 2);
            this.vTranslate.y = (float)(this.getHeight() / 2) - this.scale * (float)(this.sHeight() / 2);
            if (this.isImageReady()) {
                this.refreshRequiredTiles(true);
                this.invalidate();
            }
        }
    }

    public final void setTileBackgroundColor(int tileBgColor) {
        if (Color.alpha((int)tileBgColor) == 0) {
            this.tileBgPaint = null;
        } else {
            this.tileBgPaint = new Paint();
            this.tileBgPaint.setStyle(Paint.Style.FILL);
            this.tileBgPaint.setColor(tileBgColor);
        }
        this.invalidate();
    }

    public final void setDoubleTapZoomScale(float doubleTapZoomScale) {
        this.doubleTapZoomScale = doubleTapZoomScale;
    }

    public final void setDoubleTapZoomDpi(int dpi) {
        DisplayMetrics metrics = this.getResources().getDisplayMetrics();
        float averageDpi = (metrics.xdpi + metrics.ydpi) / 2.0f;
        this.setDoubleTapZoomScale(averageDpi / (float)dpi);
    }

    public final void setDoubleTapZoomStyle(int doubleTapZoomStyle) {
        if (!VALID_ZOOM_STYLES.contains(doubleTapZoomStyle)) {
            throw new IllegalArgumentException("Invalid zoom style: " + doubleTapZoomStyle);
        }
        this.doubleTapZoomStyle = doubleTapZoomStyle;
    }

    public final void setDebug(boolean debug) {
        this.debug = debug;
    }

    public AnimationBuilder animateCenter(PointF sCenter) {
        if (!this.isImageReady()) {
            return null;
        }
        return new AnimationBuilder(sCenter);
    }

    public AnimationBuilder animateScale(float scale) {
        if (!this.isImageReady()) {
            return null;
        }
        return new AnimationBuilder(scale);
    }

    public AnimationBuilder animateScaleAndCenter(float scale, PointF sCenter) {
        if (!this.isImageReady()) {
            return null;
        }
        return new AnimationBuilder(scale, sCenter);
    }

    public final class AnimationBuilder {
        private final float targetScale;
        private final PointF targetSCenter;
        private final PointF vFocus;
        private long duration = 500L;
        private int easing = 2;
        private boolean interruptible = true;
        private boolean panLimited = true;

        private AnimationBuilder(PointF sCenter) {
            this.targetScale = SubsamplingScaleImageView.this.scale;
            this.targetSCenter = sCenter;
            this.vFocus = null;
        }

        private AnimationBuilder(float scale) {
            this.targetScale = scale;
            this.targetSCenter = SubsamplingScaleImageView.this.getCenter();
            this.vFocus = null;
        }

        private AnimationBuilder(float scale, PointF sCenter) {
            this.targetScale = scale;
            this.targetSCenter = sCenter;
            this.vFocus = null;
        }

        private AnimationBuilder(float scale, PointF sCenter, PointF vFocus) {
            this.targetScale = scale;
            this.targetSCenter = sCenter;
            this.vFocus = vFocus;
        }

        public AnimationBuilder withDuration(long duration) {
            this.duration = duration;
            return this;
        }

        public AnimationBuilder withInterruptible(boolean interruptible) {
            this.interruptible = interruptible;
            return this;
        }

        public AnimationBuilder withEasing(int easing) {
            if (!VALID_EASING_STYLES.contains(easing)) {
                throw new IllegalArgumentException("Unknown easing type: " + easing);
            }
            this.easing = easing;
            return this;
        }

        private AnimationBuilder withPanLimited(boolean panLimited) {
            this.panLimited = panLimited;
            return this;
        }

        public void start() {
            float targetScale = SubsamplingScaleImageView.this.limitedScale(this.targetScale);
            PointF targetSCenter = this.panLimited ? SubsamplingScaleImageView.this.limitedSCenter(this.targetSCenter, targetScale) : this.targetSCenter;
            SubsamplingScaleImageView.this.anim = new Anim();
            SubsamplingScaleImageView.this.anim.scaleStart = SubsamplingScaleImageView.this.scale;
            SubsamplingScaleImageView.this.anim.scaleEnd = targetScale;
            SubsamplingScaleImageView.this.anim.time = System.currentTimeMillis();
            SubsamplingScaleImageView.this.anim.sCenterEndRequested = targetSCenter;
            SubsamplingScaleImageView.this.anim.sCenterStart = SubsamplingScaleImageView.this.getCenter();
            SubsamplingScaleImageView.this.anim.sCenterEnd = targetSCenter;
            SubsamplingScaleImageView.this.anim.vFocusStart = SubsamplingScaleImageView.this.sourceToViewCoord(targetSCenter);
            SubsamplingScaleImageView.this.anim.vFocusEnd = new PointF((float)(SubsamplingScaleImageView.this.getWidth() / 2), (float)(SubsamplingScaleImageView.this.getHeight() / 2));
            SubsamplingScaleImageView.this.anim.duration = this.duration;
            SubsamplingScaleImageView.this.anim.interruptible = this.interruptible;
            SubsamplingScaleImageView.this.anim.easing = this.easing;
            SubsamplingScaleImageView.this.anim.time = System.currentTimeMillis();
            if (this.vFocus != null) {
                float vTranslateXEnd = this.vFocus.x - targetScale * ((Anim)((SubsamplingScaleImageView)SubsamplingScaleImageView.this).anim).sCenterStart.x;
                float vTranslateYEnd = this.vFocus.y - targetScale * ((Anim)((SubsamplingScaleImageView)SubsamplingScaleImageView.this).anim).sCenterStart.y;
                ScaleAndTranslate satEnd = new ScaleAndTranslate(targetScale, new PointF(vTranslateXEnd, vTranslateYEnd));
                SubsamplingScaleImageView.this.fitToBounds(true, satEnd);
                SubsamplingScaleImageView.this.anim.vFocusEnd = new PointF(this.vFocus.x + (((ScaleAndTranslate)satEnd).translate.x - vTranslateXEnd), this.vFocus.y + (((ScaleAndTranslate)satEnd).translate.y - vTranslateYEnd));
            }
            SubsamplingScaleImageView.this.invalidate();
        }
    }

    private static class ScaleAndTranslate {
        private float scale;
        private PointF translate;

        private ScaleAndTranslate(float scale, PointF translate) {
            this.scale = scale;
            this.translate = translate;
        }
    }

    private static class Anim {
        private float scaleStart;
        private float scaleEnd;
        private PointF sCenterStart;
        private PointF sCenterEnd;
        private PointF sCenterEndRequested;
        private PointF vFocusStart;
        private PointF vFocusEnd;
        private long duration = 500L;
        private boolean interruptible = true;
        private int easing = 2;
        private long time = System.currentTimeMillis();

        private Anim() {
        }
    }

    private static class Tile {
        private Rect sRect;
        private int sampleSize;
        private Bitmap bitmap;
        private boolean loading;
        private boolean visible;

        private Tile() {
        }
    }

    private static class BitmapTileTask
    extends AsyncTask<Void, Void, Bitmap> {
        private final WeakReference<SubsamplingScaleImageView> viewRef;
        private final WeakReference<ImageRegionDecoder> decoderRef;
        private final WeakReference<Object> decoderLockRef;
        private final WeakReference<Tile> tileRef;

        public BitmapTileTask(SubsamplingScaleImageView view, ImageRegionDecoder decoder, Object decoderLock, Tile tile) {
            this.viewRef = new WeakReference<SubsamplingScaleImageView>(view);
            this.decoderRef = new WeakReference<ImageRegionDecoder>(decoder);
            this.decoderLockRef = new WeakReference<Object>(decoderLock);
            this.tileRef = new WeakReference<Tile>(tile);
            tile.loading = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Bitmap doInBackground(Void ... params) {
            try {
                ImageRegionDecoder decoder = (ImageRegionDecoder)this.decoderRef.get();
                Object decoderLock = this.decoderLockRef.get();
                Tile tile = (Tile)this.tileRef.get();
                SubsamplingScaleImageView view = (SubsamplingScaleImageView)((Object)this.viewRef.get());
                if (decoder != null && decoderLock != null && tile != null && view != null && decoder.isReady()) {
                    Object t = decoderLock;
                    synchronized (t) {
                        Bitmap bitmap = decoder.decodeRegion(view.fileSRect(tile.sRect), tile.sampleSize);
                        int rotation = view.getRequiredRotation();
                        if (rotation != 0) {
                            Matrix matrix = new Matrix();
                            matrix.postRotate((float)rotation);
                            bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
                        }
                        return bitmap;
                    }
                }
                if (tile != null) {
                    tile.loading = false;
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Failed to decode tile", (Throwable)e);
            }
            return null;
        }

        protected void onPostExecute(Bitmap bitmap) {
            if (bitmap != null) {
                SubsamplingScaleImageView subsamplingScaleImageView = (SubsamplingScaleImageView)((Object)this.viewRef.get());
                Tile tile = (Tile)this.tileRef.get();
                if (subsamplingScaleImageView != null && tile != null) {
                    tile.bitmap = bitmap;
                    tile.loading = false;
                    subsamplingScaleImageView.onTileLoaded();
                }
            }
        }
    }

    private static class BitmapInitTask
    extends AsyncTask<Void, Void, int[]> {
        private final WeakReference<SubsamplingScaleImageView> viewRef;
        private final WeakReference<Context> contextRef;
        private final WeakReference<Class<? extends ImageRegionDecoder>> decoderClassRef;
        private final Uri source;
        private ImageRegionDecoder decoder;

        public BitmapInitTask(SubsamplingScaleImageView view, Context context, Class<? extends ImageRegionDecoder> decoderClass, Uri source) {
            this.viewRef = new WeakReference<SubsamplingScaleImageView>(view);
            this.contextRef = new WeakReference<Context>(context);
            this.decoderClassRef = new WeakReference<Class<? extends ImageRegionDecoder>>(decoderClass);
            this.source = source;
        }

        protected int[] doInBackground(Void ... params) {
            block13: {
                try {
                    String sourceUri = this.source.toString();
                    Context context = (Context)this.contextRef.get();
                    Class decoderClass = (Class)this.decoderClassRef.get();
                    if (context == null || decoderClass == null) break block13;
                    int exifOrientation = 0;
                    this.decoder = (ImageRegionDecoder)decoderClass.newInstance();
                    Point dimensions = this.decoder.init(context, this.source);
                    if (sourceUri.startsWith(SubsamplingScaleImageView.FILE_SCHEME) && !sourceUri.startsWith(SubsamplingScaleImageView.ASSET_SCHEME)) {
                        try {
                            ExifInterface exifInterface = new ExifInterface(sourceUri.substring(SubsamplingScaleImageView.FILE_SCHEME.length() - 1));
                            int orientationAttr = exifInterface.getAttributeInt("Orientation", 1);
                            if (orientationAttr == 1 || orientationAttr == 0) {
                                exifOrientation = 0;
                            } else if (orientationAttr == 6) {
                                exifOrientation = 90;
                            } else if (orientationAttr == 3) {
                                exifOrientation = 180;
                            } else if (orientationAttr == 8) {
                                exifOrientation = 270;
                            } else {
                                Log.w((String)TAG, (String)("Unsupported EXIF orientation: " + orientationAttr));
                            }
                        }
                        catch (Exception e) {
                            Log.w((String)TAG, (String)"Could not get EXIF orientation of image");
                        }
                    }
                    return new int[]{dimensions.x, dimensions.y, exifOrientation};
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)"Failed to initialise bitmap decoder", (Throwable)e);
                }
            }
            return null;
        }

        protected void onPostExecute(int[] xyo) {
            SubsamplingScaleImageView subsamplingScaleImageView;
            if (this.decoder != null && (subsamplingScaleImageView = (SubsamplingScaleImageView)((Object)this.viewRef.get())) != null && this.decoder != null && xyo != null && xyo.length == 3) {
                subsamplingScaleImageView.onImageInited(this.decoder, xyo[0], xyo[1], xyo[2]);
            }
        }
    }
}

