/*
 * Decompiled with CFR 0.152.
 */
package com.davemorrissey.labs.subscaleview;

import android.content.Context;
import android.content.res.TypedArray;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewParent;
import androidx.annotation.AnyThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.exifinterface.media.ExifInterface;
import com.davemorrissey.labs.subscaleview.ImageSource;
import com.davemorrissey.labs.subscaleview.ImageViewState;
import com.davemorrissey.labs.subscaleview.R;
import com.davemorrissey.labs.subscaleview.decoder.CompatDecoderFactory;
import com.davemorrissey.labs.subscaleview.decoder.DecoderFactory;
import com.davemorrissey.labs.subscaleview.decoder.ImageDecoder;
import com.davemorrissey.labs.subscaleview.decoder.ImageRegionDecoder;
import com.davemorrissey.labs.subscaleview.decoder.SkiaImageDecoder;
import com.davemorrissey.labs.subscaleview.decoder.SkiaImageRegionDecoder;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class SubsamplingScaleImageView
extends View {
    private static final String TAG = SubsamplingScaleImageView.class.getSimpleName();
    public static final int ORIENTATION_USE_EXIF = -1;
    public static final int ORIENTATION_0 = 0;
    public static final int ORIENTATION_90 = 90;
    public static final int ORIENTATION_180 = 180;
    public static final int ORIENTATION_270 = 270;
    private static final List<Integer> VALID_ORIENTATIONS = Arrays.asList(0, 90, 180, 270, -1);
    public static final int ZOOM_FOCUS_FIXED = 1;
    public static final int ZOOM_FOCUS_CENTER = 2;
    public static final int ZOOM_FOCUS_CENTER_IMMEDIATE = 3;
    private static final List<Integer> VALID_ZOOM_STYLES = Arrays.asList(1, 2, 3);
    public static final int EASE_OUT_QUAD = 1;
    public static final int EASE_IN_OUT_QUAD = 2;
    private static final List<Integer> VALID_EASING_STYLES = Arrays.asList(2, 1);
    public static final int PAN_LIMIT_INSIDE = 1;
    public static final int PAN_LIMIT_OUTSIDE = 2;
    public static final int PAN_LIMIT_CENTER = 3;
    private static final List<Integer> VALID_PAN_LIMITS = Arrays.asList(1, 2, 3);
    public static final int SCALE_TYPE_CENTER_INSIDE = 1;
    public static final int SCALE_TYPE_CENTER_CROP = 2;
    public static final int SCALE_TYPE_CUSTOM = 3;
    public static final int SCALE_TYPE_START = 4;
    private static final List<Integer> VALID_SCALE_TYPES = Arrays.asList(2, 1, 3, 4);
    public static final int ORIGIN_ANIM = 1;
    public static final int ORIGIN_TOUCH = 2;
    public static final int ORIGIN_FLING = 3;
    public static final int ORIGIN_DOUBLE_TAP_ZOOM = 4;
    private Bitmap bitmap;
    private boolean bitmapIsPreview;
    private boolean bitmapIsCached;
    private Uri uri;
    private int fullImageSampleSize;
    private Map<Integer, List<Tile>> tileMap;
    private boolean debug;
    private int orientation = 0;
    private float maxScale = 2.0f;
    private float minScale = this.minScale();
    private int minimumTileDpi = -1;
    private int panLimit = 1;
    private int minimumScaleType = 1;
    public static final int TILE_SIZE_AUTO = Integer.MAX_VALUE;
    private int maxTileWidth = Integer.MAX_VALUE;
    private int maxTileHeight = Integer.MAX_VALUE;
    private Executor executor = AsyncTask.THREAD_POOL_EXECUTOR;
    private boolean eagerLoadingEnabled = true;
    private boolean panEnabled = true;
    private boolean zoomEnabled = true;
    private boolean quickScaleEnabled = true;
    private float doubleTapZoomScale = 1.0f;
    private int doubleTapZoomStyle = 1;
    private int doubleTapZoomDuration = 500;
    private float scale;
    private float scaleStart;
    private PointF vTranslate;
    private PointF vTranslateStart;
    private PointF vTranslateBefore;
    private Float pendingScale;
    private PointF sPendingCenter;
    private PointF sRequestedCenter;
    private int sWidth;
    private int sHeight;
    private int sOrientation;
    private Rect sRegion;
    private Rect pRegion;
    private boolean isZooming;
    private boolean isPanning;
    private boolean isQuickScaling;
    private int maxTouchCount;
    private GestureDetector detector;
    private GestureDetector singleDetector;
    private ImageRegionDecoder decoder;
    private final ReadWriteLock decoderLock = new ReentrantReadWriteLock(true);
    private DecoderFactory<? extends ImageDecoder> bitmapDecoderFactory = new CompatDecoderFactory<SkiaImageDecoder>(SkiaImageDecoder.class);
    private DecoderFactory<? extends ImageRegionDecoder> regionDecoderFactory = new CompatDecoderFactory<SkiaImageRegionDecoder>(SkiaImageRegionDecoder.class);
    private PointF vCenterStart;
    private float vDistStart;
    private final float quickScaleThreshold;
    private float quickScaleLastDistance;
    private boolean quickScaleMoved;
    private PointF quickScaleVLastPoint;
    private PointF quickScaleSCenter;
    private PointF quickScaleVStart;
    private Anim anim;
    private boolean readySent;
    private boolean imageLoadedSent;
    private OnImageEventListener onImageEventListener;
    private OnStateChangedListener onStateChangedListener;
    private View.OnLongClickListener onLongClickListener;
    private final Handler handler;
    private static final int MESSAGE_LONG_CLICK = 1;
    private Paint bitmapPaint;
    private Paint debugTextPaint;
    private Paint debugLinePaint;
    private Paint tileBgPaint;
    private ScaleAndTranslate satTemp;
    private Matrix matrix;
    private RectF sRect;
    private final float[] srcArray = new float[8];
    private final float[] dstArray = new float[8];
    private final float density;
    private static Bitmap.Config preferredBitmapConfig;

    public SubsamplingScaleImageView(Context context, AttributeSet attr) {
        super(context, attr);
        this.density = this.getResources().getDisplayMetrics().density;
        this.setMinimumDpi(160);
        this.setDoubleTapZoomDpi(160);
        this.setMinimumTileDpi(320);
        this.setGestureDetector(context);
        this.handler = new Handler(new Handler.Callback(){

            public boolean handleMessage(Message message) {
                if (message.what == 1 && SubsamplingScaleImageView.this.onLongClickListener != null) {
                    SubsamplingScaleImageView.this.maxTouchCount = 0;
                    SubsamplingScaleImageView.super.setOnLongClickListener(SubsamplingScaleImageView.this.onLongClickListener);
                    SubsamplingScaleImageView.this.performLongClick();
                    SubsamplingScaleImageView.super.setOnLongClickListener(null);
                }
                return true;
            }
        });
        if (attr != null) {
            int resId;
            String assetName;
            TypedArray typedAttr = this.getContext().obtainStyledAttributes(attr, R.styleable.SubsamplingScaleImageView);
            if (typedAttr.hasValue(R.styleable.SubsamplingScaleImageView_assetName) && (assetName = typedAttr.getString(R.styleable.SubsamplingScaleImageView_assetName)) != null && assetName.length() > 0) {
                this.setImage(ImageSource.asset(assetName).tilingEnabled());
            }
            if (typedAttr.hasValue(R.styleable.SubsamplingScaleImageView_src) && (resId = typedAttr.getResourceId(R.styleable.SubsamplingScaleImageView_src, 0)) > 0) {
                this.setImage(ImageSource.resource(resId).tilingEnabled());
            }
            if (typedAttr.hasValue(R.styleable.SubsamplingScaleImageView_panEnabled)) {
                this.setPanEnabled(typedAttr.getBoolean(R.styleable.SubsamplingScaleImageView_panEnabled, true));
            }
            if (typedAttr.hasValue(R.styleable.SubsamplingScaleImageView_zoomEnabled)) {
                this.setZoomEnabled(typedAttr.getBoolean(R.styleable.SubsamplingScaleImageView_zoomEnabled, true));
            }
            if (typedAttr.hasValue(R.styleable.SubsamplingScaleImageView_quickScaleEnabled)) {
                this.setQuickScaleEnabled(typedAttr.getBoolean(R.styleable.SubsamplingScaleImageView_quickScaleEnabled, true));
            }
            if (typedAttr.hasValue(R.styleable.SubsamplingScaleImageView_tileBackgroundColor)) {
                this.setTileBackgroundColor(typedAttr.getColor(R.styleable.SubsamplingScaleImageView_tileBackgroundColor, Color.argb((int)0, (int)0, (int)0, (int)0)));
            }
            typedAttr.recycle();
        }
        this.quickScaleThreshold = TypedValue.applyDimension((int)1, (float)20.0f, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public SubsamplingScaleImageView(Context context) {
        this(context, null);
    }

    public static Bitmap.Config getPreferredBitmapConfig() {
        return preferredBitmapConfig;
    }

    public static void setPreferredBitmapConfig(Bitmap.Config preferredBitmapConfig) {
        SubsamplingScaleImageView.preferredBitmapConfig = preferredBitmapConfig;
    }

    public final void setOrientation(int orientation) {
        if (!VALID_ORIENTATIONS.contains(orientation)) {
            throw new IllegalArgumentException("Invalid orientation: " + orientation);
        }
        this.orientation = orientation;
        this.reset(false);
        this.invalidate();
        this.requestLayout();
    }

    public final void setImage(@NonNull ImageSource imageSource) {
        this.setImage(imageSource, null, null);
    }

    public final void setImage(@NonNull ImageSource imageSource, ImageViewState state) {
        this.setImage(imageSource, null, state);
    }

    public final void setImage(@NonNull ImageSource imageSource, ImageSource previewSource) {
        this.setImage(imageSource, previewSource, null);
    }

    public final void setImage(@NonNull ImageSource imageSource, ImageSource previewSource, ImageViewState state) {
        if (imageSource == null) {
            throw new NullPointerException("imageSource must not be null");
        }
        this.reset(true);
        if (state != null) {
            this.restoreState(state);
        }
        if (previewSource != null) {
            if (imageSource.getBitmap() != null) {
                throw new IllegalArgumentException("Preview image cannot be used when a bitmap is provided for the main image");
            }
            if (imageSource.getSWidth() <= 0 || imageSource.getSHeight() <= 0) {
                throw new IllegalArgumentException("Preview image cannot be used unless dimensions are provided for the main image");
            }
            this.sWidth = imageSource.getSWidth();
            this.sHeight = imageSource.getSHeight();
            this.pRegion = previewSource.getSRegion();
            if (previewSource.getBitmap() != null) {
                this.bitmapIsCached = previewSource.isCached();
                this.onPreviewLoaded(previewSource.getBitmap());
            } else {
                Uri uri = previewSource.getUri();
                if (uri == null && previewSource.getResource() != null) {
                    uri = Uri.parse((String)("android.resource://" + this.getContext().getPackageName() + "/" + previewSource.getResource()));
                }
                BitmapLoadTask task = new BitmapLoadTask(this, this.getContext(), this.bitmapDecoderFactory, uri, true);
                this.execute(task);
            }
        }
        if (imageSource.getBitmap() != null && imageSource.getSRegion() != null) {
            this.onImageLoaded(Bitmap.createBitmap((Bitmap)imageSource.getBitmap(), (int)imageSource.getSRegion().left, (int)imageSource.getSRegion().top, (int)imageSource.getSRegion().width(), (int)imageSource.getSRegion().height()), 0, false);
        } else if (imageSource.getBitmap() != null) {
            this.onImageLoaded(imageSource.getBitmap(), 0, imageSource.isCached());
        } else {
            AsyncTask task;
            this.sRegion = imageSource.getSRegion();
            this.uri = imageSource.getUri();
            if (this.uri == null && imageSource.getResource() != null) {
                this.uri = Uri.parse((String)("android.resource://" + this.getContext().getPackageName() + "/" + imageSource.getResource()));
            }
            if (imageSource.getTile() || this.sRegion != null) {
                task = new TilesInitTask(this, this.getContext(), this.regionDecoderFactory, this.uri);
                this.execute(task);
            } else {
                task = new BitmapLoadTask(this, this.getContext(), this.bitmapDecoderFactory, this.uri, false);
                this.execute(task);
            }
        }
    }

    private void reset(boolean newImage) {
        this.debug("reset newImage=" + newImage, new Object[0]);
        this.scale = 0.0f;
        this.scaleStart = 0.0f;
        this.vTranslate = null;
        this.vTranslateStart = null;
        this.vTranslateBefore = null;
        this.pendingScale = Float.valueOf(0.0f);
        this.sPendingCenter = null;
        this.sRequestedCenter = null;
        this.isZooming = false;
        this.isPanning = false;
        this.isQuickScaling = false;
        this.maxTouchCount = 0;
        this.fullImageSampleSize = 0;
        this.vCenterStart = null;
        this.vDistStart = 0.0f;
        this.quickScaleLastDistance = 0.0f;
        this.quickScaleMoved = false;
        this.quickScaleSCenter = null;
        this.quickScaleVLastPoint = null;
        this.quickScaleVStart = null;
        this.anim = null;
        this.satTemp = null;
        this.matrix = null;
        this.sRect = null;
        if (newImage) {
            this.uri = null;
            this.decoderLock.writeLock().lock();
            try {
                if (this.decoder != null) {
                    this.decoder.recycle();
                    this.decoder = null;
                }
            }
            finally {
                this.decoderLock.writeLock().unlock();
            }
            if (this.bitmap != null && !this.bitmapIsCached) {
                this.bitmap.recycle();
            }
            if (this.bitmap != null && this.bitmapIsCached && this.onImageEventListener != null) {
                this.onImageEventListener.onPreviewReleased();
            }
            this.sWidth = 0;
            this.sHeight = 0;
            this.sOrientation = 0;
            this.sRegion = null;
            this.pRegion = null;
            this.readySent = false;
            this.imageLoadedSent = false;
            this.bitmap = null;
            this.bitmapIsPreview = false;
            this.bitmapIsCached = false;
        }
        if (this.tileMap != null) {
            for (Map.Entry<Integer, List<Tile>> tileMapEntry : this.tileMap.entrySet()) {
                for (Tile tile : tileMapEntry.getValue()) {
                    tile.visible = false;
                    if (tile.bitmap == null) continue;
                    tile.bitmap.recycle();
                    tile.bitmap = null;
                }
            }
            this.tileMap = null;
        }
        this.setGestureDetector(this.getContext());
    }

    private void setGestureDetector(final Context context) {
        this.detector = new GestureDetector(context, (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
                if (SubsamplingScaleImageView.this.panEnabled && SubsamplingScaleImageView.this.readySent && SubsamplingScaleImageView.this.vTranslate != null && e1 != null && e2 != null && (Math.abs(e1.getX() - e2.getX()) > 50.0f || Math.abs(e1.getY() - e2.getY()) > 50.0f) && (Math.abs(velocityX) > 500.0f || Math.abs(velocityY) > 500.0f) && !SubsamplingScaleImageView.this.isZooming) {
                    PointF vTranslateEnd = new PointF(((SubsamplingScaleImageView)SubsamplingScaleImageView.this).vTranslate.x + velocityX * 0.25f, ((SubsamplingScaleImageView)SubsamplingScaleImageView.this).vTranslate.y + velocityY * 0.25f);
                    float sCenterXEnd = ((float)(SubsamplingScaleImageView.this.getWidth() / 2) - vTranslateEnd.x) / SubsamplingScaleImageView.this.scale;
                    float sCenterYEnd = ((float)(SubsamplingScaleImageView.this.getHeight() / 2) - vTranslateEnd.y) / SubsamplingScaleImageView.this.scale;
                    new AnimationBuilder(new PointF(sCenterXEnd, sCenterYEnd)).withEasing(1).withPanLimited(false).withOrigin(3).start();
                    return true;
                }
                return super.onFling(e1, e2, velocityX, velocityY);
            }

            public boolean onSingleTapConfirmed(MotionEvent e) {
                SubsamplingScaleImageView.this.performClick();
                return true;
            }

            public boolean onDoubleTap(MotionEvent e) {
                if (SubsamplingScaleImageView.this.zoomEnabled && SubsamplingScaleImageView.this.readySent && SubsamplingScaleImageView.this.vTranslate != null) {
                    SubsamplingScaleImageView.this.setGestureDetector(context);
                    if (SubsamplingScaleImageView.this.quickScaleEnabled) {
                        SubsamplingScaleImageView.this.vCenterStart = new PointF(e.getX(), e.getY());
                        SubsamplingScaleImageView.this.vTranslateStart = new PointF(((SubsamplingScaleImageView)SubsamplingScaleImageView.this).vTranslate.x, ((SubsamplingScaleImageView)SubsamplingScaleImageView.this).vTranslate.y);
                        SubsamplingScaleImageView.this.scaleStart = SubsamplingScaleImageView.this.scale;
                        SubsamplingScaleImageView.this.isQuickScaling = true;
                        SubsamplingScaleImageView.this.isZooming = true;
                        SubsamplingScaleImageView.this.quickScaleLastDistance = -1.0f;
                        SubsamplingScaleImageView.this.quickScaleSCenter = SubsamplingScaleImageView.this.viewToSourceCoord(SubsamplingScaleImageView.this.vCenterStart);
                        SubsamplingScaleImageView.this.quickScaleVStart = new PointF(e.getX(), e.getY());
                        SubsamplingScaleImageView.this.quickScaleVLastPoint = new PointF(((SubsamplingScaleImageView)SubsamplingScaleImageView.this).quickScaleSCenter.x, ((SubsamplingScaleImageView)SubsamplingScaleImageView.this).quickScaleSCenter.y);
                        SubsamplingScaleImageView.this.quickScaleMoved = false;
                        return false;
                    }
                    SubsamplingScaleImageView.this.doubleTapZoom(SubsamplingScaleImageView.this.viewToSourceCoord(new PointF(e.getX(), e.getY())), new PointF(e.getX(), e.getY()));
                    return true;
                }
                return super.onDoubleTapEvent(e);
            }
        });
        this.singleDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onSingleTapConfirmed(MotionEvent e) {
                SubsamplingScaleImageView.this.performClick();
                return true;
            }
        });
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.debug("onSizeChanged %dx%d -> %dx%d", oldw, oldh, w, h);
        PointF sCenter = this.getCenter();
        if (this.readySent && sCenter != null) {
            this.anim = null;
            this.pendingScale = Float.valueOf(this.scale);
            this.sPendingCenter = sCenter;
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthSpecMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightSpecMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int parentWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int parentHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        boolean resizeWidth = widthSpecMode != 0x40000000;
        boolean resizeHeight = heightSpecMode != 0x40000000;
        int width = parentWidth;
        int height = parentHeight;
        if (this.sWidth > 0 && this.sHeight > 0) {
            if (resizeWidth && resizeHeight) {
                width = this.sWidth();
                height = this.sHeight();
            } else if (resizeHeight) {
                height = (int)((double)this.sHeight() / (double)this.sWidth() * (double)width);
            } else if (resizeWidth) {
                width = (int)((double)this.sWidth() / (double)this.sHeight() * (double)height);
            }
        }
        width = Math.max(width, this.getSuggestedMinimumWidth());
        height = Math.max(height, this.getSuggestedMinimumHeight());
        this.setMeasuredDimension(width, height);
    }

    public boolean onTouchEvent(@NonNull MotionEvent event) {
        if (this.anim != null && !this.anim.interruptible) {
            this.requestDisallowInterceptTouchEvent(true);
            return true;
        }
        if (this.anim != null && this.anim.listener != null) {
            try {
                this.anim.listener.onInterruptedByUser();
            }
            catch (Exception e) {
                Log.w((String)TAG, (String)"Error thrown by animation listener", (Throwable)e);
            }
        }
        this.anim = null;
        if (this.vTranslate == null) {
            if (this.singleDetector != null) {
                this.singleDetector.onTouchEvent(event);
            }
            return true;
        }
        if (!this.isQuickScaling && (this.detector == null || this.detector.onTouchEvent(event))) {
            this.isZooming = false;
            this.isPanning = false;
            this.maxTouchCount = 0;
            return true;
        }
        if (this.vTranslateStart == null) {
            this.vTranslateStart = new PointF(0.0f, 0.0f);
        }
        if (this.vTranslateBefore == null) {
            this.vTranslateBefore = new PointF(0.0f, 0.0f);
        }
        if (this.vCenterStart == null) {
            this.vCenterStart = new PointF(0.0f, 0.0f);
        }
        float scaleBefore = this.scale;
        this.vTranslateBefore.set(this.vTranslate);
        boolean handled = this.onTouchEventInternal(event);
        this.sendStateChanged(scaleBefore, this.vTranslateBefore, 2);
        return handled || super.onTouchEvent(event);
    }

    private boolean onTouchEventInternal(@NonNull MotionEvent event) {
        int touchCount = event.getPointerCount();
        switch (event.getAction()) {
            case 0: 
            case 5: 
            case 261: {
                this.anim = null;
                this.requestDisallowInterceptTouchEvent(true);
                this.maxTouchCount = Math.max(this.maxTouchCount, touchCount);
                if (touchCount >= 2) {
                    if (this.zoomEnabled) {
                        float distance = this.distance(event.getX(0), event.getX(1), event.getY(0), event.getY(1));
                        this.scaleStart = this.scale;
                        this.vDistStart = distance;
                        this.vTranslateStart.set(this.vTranslate.x, this.vTranslate.y);
                        this.vCenterStart.set((event.getX(0) + event.getX(1)) / 2.0f, (event.getY(0) + event.getY(1)) / 2.0f);
                    } else {
                        this.maxTouchCount = 0;
                    }
                    this.handler.removeMessages(1);
                } else if (!this.isQuickScaling) {
                    this.vTranslateStart.set(this.vTranslate.x, this.vTranslate.y);
                    this.vCenterStart.set(event.getX(), event.getY());
                    this.handler.sendEmptyMessageDelayed(1, 600L);
                }
                return true;
            }
            case 2: {
                boolean consumed = false;
                if (this.maxTouchCount > 0) {
                    if (touchCount >= 2) {
                        float vDistEnd = this.distance(event.getX(0), event.getX(1), event.getY(0), event.getY(1));
                        float vCenterEndX = (event.getX(0) + event.getX(1)) / 2.0f;
                        float vCenterEndY = (event.getY(0) + event.getY(1)) / 2.0f;
                        if (this.zoomEnabled && (this.distance(this.vCenterStart.x, vCenterEndX, this.vCenterStart.y, vCenterEndY) > 5.0f || Math.abs(vDistEnd - this.vDistStart) > 5.0f || this.isPanning)) {
                            this.isZooming = true;
                            this.isPanning = true;
                            consumed = true;
                            double previousScale = this.scale;
                            this.scale = Math.min(this.maxScale, vDistEnd / this.vDistStart * this.scaleStart);
                            if (this.scale <= this.minScale()) {
                                this.vDistStart = vDistEnd;
                                this.scaleStart = this.minScale();
                                this.vCenterStart.set(vCenterEndX, vCenterEndY);
                                this.vTranslateStart.set(this.vTranslate);
                            } else if (this.panEnabled) {
                                float vLeftStart = this.vCenterStart.x - this.vTranslateStart.x;
                                float vTopStart = this.vCenterStart.y - this.vTranslateStart.y;
                                float vLeftNow = vLeftStart * (this.scale / this.scaleStart);
                                float vTopNow = vTopStart * (this.scale / this.scaleStart);
                                this.vTranslate.x = vCenterEndX - vLeftNow;
                                this.vTranslate.y = vCenterEndY - vTopNow;
                                if (previousScale * (double)this.sHeight() < (double)this.getHeight() && this.scale * (float)this.sHeight() >= (float)this.getHeight() || previousScale * (double)this.sWidth() < (double)this.getWidth() && this.scale * (float)this.sWidth() >= (float)this.getWidth()) {
                                    this.fitToBounds(true);
                                    this.vCenterStart.set(vCenterEndX, vCenterEndY);
                                    this.vTranslateStart.set(this.vTranslate);
                                    this.scaleStart = this.scale;
                                    this.vDistStart = vDistEnd;
                                }
                            } else if (this.sRequestedCenter != null) {
                                this.vTranslate.x = (float)(this.getWidth() / 2) - this.scale * this.sRequestedCenter.x;
                                this.vTranslate.y = (float)(this.getHeight() / 2) - this.scale * this.sRequestedCenter.y;
                            } else {
                                this.vTranslate.x = (float)(this.getWidth() / 2) - this.scale * (float)(this.sWidth() / 2);
                                this.vTranslate.y = (float)(this.getHeight() / 2) - this.scale * (float)(this.sHeight() / 2);
                            }
                            this.fitToBounds(true);
                            this.refreshRequiredTiles(this.eagerLoadingEnabled);
                        }
                    } else if (this.isQuickScaling) {
                        float dist = Math.abs(this.quickScaleVStart.y - event.getY()) * 2.0f + this.quickScaleThreshold;
                        if (this.quickScaleLastDistance == -1.0f) {
                            this.quickScaleLastDistance = dist;
                        }
                        boolean isUpwards = event.getY() > this.quickScaleVLastPoint.y;
                        this.quickScaleVLastPoint.set(0.0f, event.getY());
                        float spanDiff = Math.abs(1.0f - dist / this.quickScaleLastDistance) * 0.5f;
                        if (spanDiff > 0.03f || this.quickScaleMoved) {
                            this.quickScaleMoved = true;
                            float multiplier = 1.0f;
                            if (this.quickScaleLastDistance > 0.0f) {
                                multiplier = isUpwards ? 1.0f + spanDiff : 1.0f - spanDiff;
                            }
                            double previousScale = this.scale;
                            this.scale = Math.max(this.minScale(), Math.min(this.maxScale, this.scale * multiplier));
                            if (this.panEnabled) {
                                float vLeftStart = this.vCenterStart.x - this.vTranslateStart.x;
                                float vTopStart = this.vCenterStart.y - this.vTranslateStart.y;
                                float vLeftNow = vLeftStart * (this.scale / this.scaleStart);
                                float vTopNow = vTopStart * (this.scale / this.scaleStart);
                                this.vTranslate.x = this.vCenterStart.x - vLeftNow;
                                this.vTranslate.y = this.vCenterStart.y - vTopNow;
                                if (previousScale * (double)this.sHeight() < (double)this.getHeight() && this.scale * (float)this.sHeight() >= (float)this.getHeight() || previousScale * (double)this.sWidth() < (double)this.getWidth() && this.scale * (float)this.sWidth() >= (float)this.getWidth()) {
                                    this.fitToBounds(true);
                                    this.vCenterStart.set(this.sourceToViewCoord(this.quickScaleSCenter));
                                    this.vTranslateStart.set(this.vTranslate);
                                    this.scaleStart = this.scale;
                                    dist = 0.0f;
                                }
                            } else if (this.sRequestedCenter != null) {
                                this.vTranslate.x = (float)(this.getWidth() / 2) - this.scale * this.sRequestedCenter.x;
                                this.vTranslate.y = (float)(this.getHeight() / 2) - this.scale * this.sRequestedCenter.y;
                            } else {
                                this.vTranslate.x = (float)(this.getWidth() / 2) - this.scale * (float)(this.sWidth() / 2);
                                this.vTranslate.y = (float)(this.getHeight() / 2) - this.scale * (float)(this.sHeight() / 2);
                            }
                        }
                        this.quickScaleLastDistance = dist;
                        this.fitToBounds(true);
                        this.refreshRequiredTiles(this.eagerLoadingEnabled);
                        consumed = true;
                    } else if (!this.isZooming) {
                        float dx = Math.abs(event.getX() - this.vCenterStart.x);
                        float dy = Math.abs(event.getY() - this.vCenterStart.y);
                        float offset = this.density * 5.0f;
                        if (dx > offset || dy > offset || this.isPanning) {
                            boolean yPan;
                            consumed = true;
                            this.vTranslate.x = this.vTranslateStart.x + (event.getX() - this.vCenterStart.x);
                            this.vTranslate.y = this.vTranslateStart.y + (event.getY() - this.vCenterStart.y);
                            float lastX = this.vTranslate.x;
                            float lastY = this.vTranslate.y;
                            this.fitToBounds(true);
                            boolean atXEdge = lastX != this.vTranslate.x;
                            boolean atYEdge = lastY != this.vTranslate.y;
                            boolean edgeXSwipe = atXEdge && dx > dy && !this.isPanning;
                            boolean edgeYSwipe = atYEdge && dy > dx && !this.isPanning;
                            boolean bl = yPan = lastY == this.vTranslate.y && dy > offset * 3.0f;
                            if (!(edgeXSwipe || edgeYSwipe || atXEdge && atYEdge && !yPan && !this.isPanning)) {
                                this.isPanning = true;
                            } else if (dx > offset || dy > offset) {
                                this.maxTouchCount = 0;
                                this.handler.removeMessages(1);
                                this.requestDisallowInterceptTouchEvent(false);
                            }
                            if (!this.panEnabled) {
                                this.vTranslate.x = this.vTranslateStart.x;
                                this.vTranslate.y = this.vTranslateStart.y;
                                this.requestDisallowInterceptTouchEvent(false);
                            }
                            this.refreshRequiredTiles(this.eagerLoadingEnabled);
                        }
                    }
                }
                if (!consumed) break;
                this.handler.removeMessages(1);
                this.invalidate();
                return true;
            }
            case 1: 
            case 6: 
            case 262: {
                this.handler.removeMessages(1);
                if (this.isQuickScaling) {
                    this.isQuickScaling = false;
                    if (!this.quickScaleMoved) {
                        this.doubleTapZoom(this.quickScaleSCenter, this.vCenterStart);
                    }
                }
                if (this.maxTouchCount > 0 && (this.isZooming || this.isPanning)) {
                    if (this.isZooming && touchCount == 2) {
                        this.isPanning = true;
                        this.vTranslateStart.set(this.vTranslate.x, this.vTranslate.y);
                        if (event.getActionIndex() == 1) {
                            this.vCenterStart.set(event.getX(0), event.getY(0));
                        } else {
                            this.vCenterStart.set(event.getX(1), event.getY(1));
                        }
                    }
                    if (touchCount < 3) {
                        this.isZooming = false;
                    }
                    if (touchCount < 2) {
                        this.isPanning = false;
                        this.maxTouchCount = 0;
                    }
                    this.refreshRequiredTiles(true);
                    return true;
                }
                if (touchCount == 1) {
                    this.isZooming = false;
                    this.isPanning = false;
                    this.maxTouchCount = 0;
                }
                return true;
            }
        }
        return false;
    }

    private void requestDisallowInterceptTouchEvent(boolean disallowIntercept) {
        ViewParent parent = this.getParent();
        if (parent != null) {
            parent.requestDisallowInterceptTouchEvent(disallowIntercept);
        }
    }

    private void doubleTapZoom(PointF sCenter, PointF vFocus) {
        float targetScale;
        float doubleTapZoomScale;
        if (!this.panEnabled) {
            if (this.sRequestedCenter != null) {
                sCenter.x = this.sRequestedCenter.x;
                sCenter.y = this.sRequestedCenter.y;
            } else {
                sCenter.x = this.sWidth() / 2;
                sCenter.y = this.sHeight() / 2;
            }
        }
        boolean zoomIn = (double)this.scale <= (double)(doubleTapZoomScale = Math.min(this.maxScale, this.doubleTapZoomScale)) * 0.9 || this.scale == this.minScale;
        float f = targetScale = zoomIn ? doubleTapZoomScale : this.minScale();
        if (this.doubleTapZoomStyle == 3) {
            this.setScaleAndCenter(targetScale, sCenter);
        } else if (this.doubleTapZoomStyle == 2 || !zoomIn || !this.panEnabled) {
            new AnimationBuilder(targetScale, sCenter).withInterruptible(false).withDuration(this.doubleTapZoomDuration).withOrigin(4).start();
        } else if (this.doubleTapZoomStyle == 1) {
            new AnimationBuilder(targetScale, sCenter, vFocus).withInterruptible(false).withDuration(this.doubleTapZoomDuration).withOrigin(4).start();
        }
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.createPaints();
        if (this.sWidth == 0 || this.sHeight == 0 || this.getWidth() == 0 || this.getHeight() == 0) {
            return;
        }
        if (this.tileMap == null && this.decoder != null) {
            this.initialiseBaseLayer(this.getMaxBitmapDimensions(canvas));
        }
        if (!this.checkReady()) {
            return;
        }
        this.preDraw();
        if (this.anim != null && this.anim.vFocusStart != null) {
            float scaleBefore = this.scale;
            if (this.vTranslateBefore == null) {
                this.vTranslateBefore = new PointF(0.0f, 0.0f);
            }
            this.vTranslateBefore.set(this.vTranslate);
            long scaleElapsed = System.currentTimeMillis() - this.anim.time;
            boolean finished = scaleElapsed > this.anim.duration;
            scaleElapsed = Math.min(scaleElapsed, this.anim.duration);
            this.scale = this.ease(this.anim.easing, scaleElapsed, this.anim.scaleStart, this.anim.scaleEnd - this.anim.scaleStart, this.anim.duration);
            float vFocusNowX = this.ease(this.anim.easing, scaleElapsed, ((Anim)this.anim).vFocusStart.x, ((Anim)this.anim).vFocusEnd.x - ((Anim)this.anim).vFocusStart.x, this.anim.duration);
            float vFocusNowY = this.ease(this.anim.easing, scaleElapsed, ((Anim)this.anim).vFocusStart.y, ((Anim)this.anim).vFocusEnd.y - ((Anim)this.anim).vFocusStart.y, this.anim.duration);
            this.vTranslate.x -= this.sourceToViewX(((Anim)this.anim).sCenterEnd.x) - vFocusNowX;
            this.vTranslate.y -= this.sourceToViewY(((Anim)this.anim).sCenterEnd.y) - vFocusNowY;
            this.fitToBounds(finished || this.anim.scaleStart == this.anim.scaleEnd);
            this.sendStateChanged(scaleBefore, this.vTranslateBefore, this.anim.origin);
            this.refreshRequiredTiles(finished);
            if (finished) {
                if (this.anim.listener != null) {
                    try {
                        this.anim.listener.onComplete();
                    }
                    catch (Exception e) {
                        Log.w((String)TAG, (String)"Error thrown by animation listener", (Throwable)e);
                    }
                }
                this.anim = null;
            }
            this.invalidate();
        }
        if (this.tileMap != null && this.isBaseLayerReady()) {
            int sampleSize = Math.min(this.fullImageSampleSize, this.calculateInSampleSize(this.scale));
            boolean hasMissingTiles = false;
            for (Map.Entry<Integer, List<Tile>> tileMapEntry : this.tileMap.entrySet()) {
                if (tileMapEntry.getKey() != sampleSize) continue;
                for (Tile tile : tileMapEntry.getValue()) {
                    if (!tile.visible || !tile.loading && tile.bitmap != null) continue;
                    hasMissingTiles = true;
                }
            }
            for (Map.Entry<Integer, List<Tile>> tileMapEntry : this.tileMap.entrySet()) {
                if (tileMapEntry.getKey() != sampleSize && !hasMissingTiles) continue;
                for (Tile tile : tileMapEntry.getValue()) {
                    this.sourceToViewRect(tile.sRect, tile.vRect);
                    if (!tile.loading && tile.bitmap != null) {
                        if (this.tileBgPaint != null) {
                            canvas.drawRect(tile.vRect, this.tileBgPaint);
                        }
                        if (this.matrix == null) {
                            this.matrix = new Matrix();
                        }
                        this.matrix.reset();
                        this.setMatrixArray(this.srcArray, 0.0f, 0.0f, tile.bitmap.getWidth(), 0.0f, tile.bitmap.getWidth(), tile.bitmap.getHeight(), 0.0f, tile.bitmap.getHeight());
                        if (this.getRequiredRotation() == 0) {
                            this.setMatrixArray(this.dstArray, ((Tile)tile).vRect.left, ((Tile)tile).vRect.top, ((Tile)tile).vRect.right, ((Tile)tile).vRect.top, ((Tile)tile).vRect.right, ((Tile)tile).vRect.bottom, ((Tile)tile).vRect.left, ((Tile)tile).vRect.bottom);
                        } else if (this.getRequiredRotation() == 90) {
                            this.setMatrixArray(this.dstArray, ((Tile)tile).vRect.right, ((Tile)tile).vRect.top, ((Tile)tile).vRect.right, ((Tile)tile).vRect.bottom, ((Tile)tile).vRect.left, ((Tile)tile).vRect.bottom, ((Tile)tile).vRect.left, ((Tile)tile).vRect.top);
                        } else if (this.getRequiredRotation() == 180) {
                            this.setMatrixArray(this.dstArray, ((Tile)tile).vRect.right, ((Tile)tile).vRect.bottom, ((Tile)tile).vRect.left, ((Tile)tile).vRect.bottom, ((Tile)tile).vRect.left, ((Tile)tile).vRect.top, ((Tile)tile).vRect.right, ((Tile)tile).vRect.top);
                        } else if (this.getRequiredRotation() == 270) {
                            this.setMatrixArray(this.dstArray, ((Tile)tile).vRect.left, ((Tile)tile).vRect.bottom, ((Tile)tile).vRect.left, ((Tile)tile).vRect.top, ((Tile)tile).vRect.right, ((Tile)tile).vRect.top, ((Tile)tile).vRect.right, ((Tile)tile).vRect.bottom);
                        }
                        this.matrix.setPolyToPoly(this.srcArray, 0, this.dstArray, 0, 4);
                        canvas.drawBitmap(tile.bitmap, this.matrix, this.bitmapPaint);
                        if (this.debug) {
                            canvas.drawRect(tile.vRect, this.debugLinePaint);
                        }
                    } else if (tile.loading && this.debug) {
                        canvas.drawText("LOADING", (float)(((Tile)tile).vRect.left + this.px(5)), (float)(((Tile)tile).vRect.top + this.px(35)), this.debugTextPaint);
                    }
                    if (!tile.visible || !this.debug) continue;
                    canvas.drawText("ISS " + tile.sampleSize + " RECT " + ((Tile)tile).sRect.top + "," + ((Tile)tile).sRect.left + "," + ((Tile)tile).sRect.bottom + "," + ((Tile)tile).sRect.right, (float)(((Tile)tile).vRect.left + this.px(5)), (float)(((Tile)tile).vRect.top + this.px(15)), this.debugTextPaint);
                }
            }
        } else if (this.bitmap != null) {
            float xScale = this.scale;
            float yScale = this.scale;
            if (this.bitmapIsPreview) {
                xScale = this.scale * ((float)this.sWidth / (float)this.bitmap.getWidth());
                yScale = this.scale * ((float)this.sHeight / (float)this.bitmap.getHeight());
            }
            if (this.matrix == null) {
                this.matrix = new Matrix();
            }
            this.matrix.reset();
            this.matrix.postScale(xScale, yScale);
            this.matrix.postRotate((float)this.getRequiredRotation());
            this.matrix.postTranslate(this.vTranslate.x, this.vTranslate.y);
            if (this.getRequiredRotation() == 180) {
                this.matrix.postTranslate(this.scale * (float)this.sWidth, this.scale * (float)this.sHeight);
            } else if (this.getRequiredRotation() == 90) {
                this.matrix.postTranslate(this.scale * (float)this.sHeight, 0.0f);
            } else if (this.getRequiredRotation() == 270) {
                this.matrix.postTranslate(0.0f, this.scale * (float)this.sWidth);
            }
            if (this.tileBgPaint != null) {
                if (this.sRect == null) {
                    this.sRect = new RectF();
                }
                this.sRect.set(0.0f, 0.0f, this.bitmapIsPreview ? (float)this.bitmap.getWidth() : (float)this.sWidth, this.bitmapIsPreview ? (float)this.bitmap.getHeight() : (float)this.sHeight);
                this.matrix.mapRect(this.sRect);
                canvas.drawRect(this.sRect, this.tileBgPaint);
            }
            canvas.drawBitmap(this.bitmap, this.matrix, this.bitmapPaint);
        }
        if (this.debug) {
            canvas.drawText("Scale: " + String.format(Locale.ENGLISH, "%.2f", Float.valueOf(this.scale)) + " (" + String.format(Locale.ENGLISH, "%.2f", Float.valueOf(this.minScale())) + " - " + String.format(Locale.ENGLISH, "%.2f", Float.valueOf(this.maxScale)) + ")", (float)this.px(5), (float)this.px(15), this.debugTextPaint);
            canvas.drawText("Translate: " + String.format(Locale.ENGLISH, "%.2f", Float.valueOf(this.vTranslate.x)) + ":" + String.format(Locale.ENGLISH, "%.2f", Float.valueOf(this.vTranslate.y)), (float)this.px(5), (float)this.px(30), this.debugTextPaint);
            PointF center = this.getCenter();
            canvas.drawText("Source center: " + String.format(Locale.ENGLISH, "%.2f", Float.valueOf(center.x)) + ":" + String.format(Locale.ENGLISH, "%.2f", Float.valueOf(center.y)), (float)this.px(5), (float)this.px(45), this.debugTextPaint);
            if (this.anim != null) {
                PointF vCenterStart = this.sourceToViewCoord(this.anim.sCenterStart);
                PointF vCenterEndRequested = this.sourceToViewCoord(this.anim.sCenterEndRequested);
                PointF vCenterEnd = this.sourceToViewCoord(this.anim.sCenterEnd);
                canvas.drawCircle(vCenterStart.x, vCenterStart.y, (float)this.px(10), this.debugLinePaint);
                this.debugLinePaint.setColor(-65536);
                canvas.drawCircle(vCenterEndRequested.x, vCenterEndRequested.y, (float)this.px(20), this.debugLinePaint);
                this.debugLinePaint.setColor(-16776961);
                canvas.drawCircle(vCenterEnd.x, vCenterEnd.y, (float)this.px(25), this.debugLinePaint);
                this.debugLinePaint.setColor(-16711681);
                canvas.drawCircle((float)(this.getWidth() / 2), (float)(this.getHeight() / 2), (float)this.px(30), this.debugLinePaint);
            }
            if (this.vCenterStart != null) {
                this.debugLinePaint.setColor(-65536);
                canvas.drawCircle(this.vCenterStart.x, this.vCenterStart.y, (float)this.px(20), this.debugLinePaint);
            }
            if (this.quickScaleSCenter != null) {
                this.debugLinePaint.setColor(-16776961);
                canvas.drawCircle(this.sourceToViewX(this.quickScaleSCenter.x), this.sourceToViewY(this.quickScaleSCenter.y), (float)this.px(35), this.debugLinePaint);
            }
            if (this.quickScaleVStart != null && this.isQuickScaling) {
                this.debugLinePaint.setColor(-16711681);
                canvas.drawCircle(this.quickScaleVStart.x, this.quickScaleVStart.y, (float)this.px(30), this.debugLinePaint);
            }
            this.debugLinePaint.setColor(-65281);
        }
    }

    private void setMatrixArray(float[] array, float f0, float f1, float f2, float f3, float f4, float f5, float f6, float f7) {
        array[0] = f0;
        array[1] = f1;
        array[2] = f2;
        array[3] = f3;
        array[4] = f4;
        array[5] = f5;
        array[6] = f6;
        array[7] = f7;
    }

    private boolean isBaseLayerReady() {
        if (this.bitmap != null && !this.bitmapIsPreview) {
            return true;
        }
        if (this.tileMap != null) {
            boolean baseLayerReady = true;
            for (Map.Entry<Integer, List<Tile>> tileMapEntry : this.tileMap.entrySet()) {
                if (tileMapEntry.getKey() != this.fullImageSampleSize) continue;
                for (Tile tile : tileMapEntry.getValue()) {
                    if (!tile.loading && tile.bitmap != null) continue;
                    baseLayerReady = false;
                }
            }
            return baseLayerReady;
        }
        return false;
    }

    private boolean checkReady() {
        boolean ready;
        boolean bl = ready = this.getWidth() > 0 && this.getHeight() > 0 && this.sWidth > 0 && this.sHeight > 0 && (this.bitmap != null || this.isBaseLayerReady());
        if (!this.readySent && ready) {
            this.preDraw();
            this.readySent = true;
            this.onReady();
            if (this.onImageEventListener != null) {
                this.onImageEventListener.onReady();
            }
        }
        return ready;
    }

    private boolean checkImageLoaded() {
        boolean imageLoaded = this.isBaseLayerReady();
        if (!this.imageLoadedSent && imageLoaded) {
            this.preDraw();
            this.imageLoadedSent = true;
            this.onImageLoaded();
            if (this.onImageEventListener != null) {
                this.onImageEventListener.onImageLoaded();
            }
        }
        return imageLoaded;
    }

    private void createPaints() {
        if (this.bitmapPaint == null) {
            this.bitmapPaint = new Paint();
            this.bitmapPaint.setAntiAlias(true);
            this.bitmapPaint.setFilterBitmap(true);
            this.bitmapPaint.setDither(true);
        }
        if ((this.debugTextPaint == null || this.debugLinePaint == null) && this.debug) {
            this.debugTextPaint = new Paint();
            this.debugTextPaint.setTextSize((float)this.px(12));
            this.debugTextPaint.setColor(-65281);
            this.debugTextPaint.setStyle(Paint.Style.FILL);
            this.debugLinePaint = new Paint();
            this.debugLinePaint.setColor(-65281);
            this.debugLinePaint.setStyle(Paint.Style.STROKE);
            this.debugLinePaint.setStrokeWidth((float)this.px(1));
        }
    }

    private synchronized void initialiseBaseLayer(@NonNull Point maxTileDimensions) {
        this.debug("initialiseBaseLayer maxTileDimensions=%dx%d", maxTileDimensions.x, maxTileDimensions.y);
        this.satTemp = new ScaleAndTranslate(0.0f, new PointF(0.0f, 0.0f));
        this.fitToBounds(true, this.satTemp);
        this.fullImageSampleSize = this.calculateInSampleSize(this.satTemp.scale);
        if (this.fullImageSampleSize > 1) {
            this.fullImageSampleSize /= 2;
        }
        if (this.fullImageSampleSize == 1 && this.sRegion == null && this.sWidth() < maxTileDimensions.x && this.sHeight() < maxTileDimensions.y) {
            this.decoder.recycle();
            this.decoder = null;
            BitmapLoadTask task = new BitmapLoadTask(this, this.getContext(), this.bitmapDecoderFactory, this.uri, false);
            this.execute(task);
        } else {
            this.initialiseTileMap(maxTileDimensions);
            List<Tile> baseGrid = this.tileMap.get(this.fullImageSampleSize);
            for (Tile baseTile : baseGrid) {
                TileLoadTask task = new TileLoadTask(this, this.decoder, baseTile);
                this.execute(task);
            }
            this.refreshRequiredTiles(true);
        }
    }

    private void refreshRequiredTiles(boolean load) {
        if (this.decoder == null || this.tileMap == null) {
            return;
        }
        int sampleSize = Math.min(this.fullImageSampleSize, this.calculateInSampleSize(this.scale));
        for (Map.Entry<Integer, List<Tile>> tileMapEntry : this.tileMap.entrySet()) {
            for (Tile tile : tileMapEntry.getValue()) {
                if (tile.sampleSize < sampleSize || tile.sampleSize > sampleSize && tile.sampleSize != this.fullImageSampleSize) {
                    tile.visible = false;
                    if (tile.bitmap != null) {
                        tile.bitmap.recycle();
                        tile.bitmap = null;
                    }
                }
                if (tile.sampleSize == sampleSize) {
                    if (this.tileVisible(tile)) {
                        tile.visible = true;
                        if (tile.loading || tile.bitmap != null || !load) continue;
                        TileLoadTask task = new TileLoadTask(this, this.decoder, tile);
                        this.execute(task);
                        continue;
                    }
                    if (tile.sampleSize == this.fullImageSampleSize) continue;
                    tile.visible = false;
                    if (tile.bitmap == null) continue;
                    tile.bitmap.recycle();
                    tile.bitmap = null;
                    continue;
                }
                if (tile.sampleSize != this.fullImageSampleSize) continue;
                tile.visible = true;
            }
        }
    }

    private boolean tileVisible(Tile tile) {
        float sVisLeft = this.viewToSourceX(0.0f);
        float sVisRight = this.viewToSourceX(this.getWidth());
        float sVisTop = this.viewToSourceY(0.0f);
        float sVisBottom = this.viewToSourceY(this.getHeight());
        return !(sVisLeft > (float)((Tile)tile).sRect.right || (float)((Tile)tile).sRect.left > sVisRight || sVisTop > (float)((Tile)tile).sRect.bottom || (float)((Tile)tile).sRect.top > sVisBottom);
    }

    private void preDraw() {
        if (this.getWidth() == 0 || this.getHeight() == 0 || this.sWidth <= 0 || this.sHeight <= 0) {
            return;
        }
        if (this.sPendingCenter != null && this.pendingScale != null) {
            this.scale = this.pendingScale.floatValue();
            if (this.vTranslate == null) {
                this.vTranslate = new PointF();
            }
            this.vTranslate.x = (float)(this.getWidth() / 2) - this.scale * this.sPendingCenter.x;
            this.vTranslate.y = (float)(this.getHeight() / 2) - this.scale * this.sPendingCenter.y;
            this.sPendingCenter = null;
            this.pendingScale = null;
            this.fitToBounds(true);
            this.refreshRequiredTiles(true);
        }
        this.fitToBounds(false);
    }

    private int calculateInSampleSize(float scale) {
        if (this.minimumTileDpi > 0) {
            DisplayMetrics metrics = this.getResources().getDisplayMetrics();
            float averageDpi = (metrics.xdpi + metrics.ydpi) / 2.0f;
            scale = (float)this.minimumTileDpi / averageDpi * scale;
        }
        int reqWidth = (int)((float)this.sWidth() * scale);
        int reqHeight = (int)((float)this.sHeight() * scale);
        int inSampleSize = 1;
        if (reqWidth == 0 || reqHeight == 0) {
            return 32;
        }
        if (this.sHeight() > reqHeight || this.sWidth() > reqWidth) {
            int widthRatio;
            int heightRatio = Math.round((float)this.sHeight() / (float)reqHeight);
            inSampleSize = heightRatio < (widthRatio = Math.round((float)this.sWidth() / (float)reqWidth)) ? heightRatio : widthRatio;
        }
        int power = 1;
        while (power * 2 < inSampleSize) {
            power *= 2;
        }
        return power;
    }

    private void fitToBounds(boolean center, ScaleAndTranslate sat) {
        float maxTy;
        float maxTx;
        float yPaddingRatio;
        if (this.panLimit == 2 && this.isReady()) {
            center = false;
        }
        PointF vTranslate = sat.vTranslate;
        float scale = this.limitedScale(sat.scale);
        float scaleWidth = scale * (float)this.sWidth();
        float scaleHeight = scale * (float)this.sHeight();
        if (this.panLimit == 3 && this.isReady()) {
            vTranslate.x = Math.max(vTranslate.x, (float)(this.getWidth() / 2) - scaleWidth);
            vTranslate.y = Math.max(vTranslate.y, (float)(this.getHeight() / 2) - scaleHeight);
        } else if (center) {
            vTranslate.x = Math.max(vTranslate.x, (float)this.getWidth() - scaleWidth);
            vTranslate.y = Math.max(vTranslate.y, (float)this.getHeight() - scaleHeight);
        } else {
            vTranslate.x = Math.max(vTranslate.x, -scaleWidth);
            vTranslate.y = Math.max(vTranslate.y, -scaleHeight);
        }
        float xPaddingRatio = this.getPaddingLeft() > 0 || this.getPaddingRight() > 0 ? (float)this.getPaddingLeft() / (float)(this.getPaddingLeft() + this.getPaddingRight()) : 0.5f;
        float f = yPaddingRatio = this.getPaddingTop() > 0 || this.getPaddingBottom() > 0 ? (float)this.getPaddingTop() / (float)(this.getPaddingTop() + this.getPaddingBottom()) : 0.5f;
        if (this.panLimit == 3 && this.isReady()) {
            maxTx = Math.max(0, this.getWidth() / 2);
            maxTy = Math.max(0, this.getHeight() / 2);
        } else if (center) {
            maxTx = Math.max(0.0f, ((float)this.getWidth() - scaleWidth) * xPaddingRatio);
            maxTy = Math.max(0.0f, ((float)this.getHeight() - scaleHeight) * yPaddingRatio);
        } else {
            maxTx = Math.max(0, this.getWidth());
            maxTy = Math.max(0, this.getHeight());
        }
        vTranslate.x = Math.min(vTranslate.x, maxTx);
        vTranslate.y = Math.min(vTranslate.y, maxTy);
        sat.scale = scale;
    }

    private void fitToBounds(boolean center) {
        boolean init = false;
        if (this.vTranslate == null) {
            init = true;
            this.vTranslate = new PointF(0.0f, 0.0f);
        }
        if (this.satTemp == null) {
            this.satTemp = new ScaleAndTranslate(0.0f, new PointF(0.0f, 0.0f));
        }
        this.satTemp.scale = this.scale;
        this.satTemp.vTranslate.set(this.vTranslate);
        this.fitToBounds(center, this.satTemp);
        this.scale = this.satTemp.scale;
        this.vTranslate.set(this.satTemp.vTranslate);
        if (init && this.minimumScaleType != 4) {
            this.vTranslate.set(this.vTranslateForSCenter(this.sWidth() / 2, this.sHeight() / 2, this.scale));
        }
    }

    private void initialiseTileMap(Point maxTileDimensions) {
        this.debug("initialiseTileMap maxTileDimensions=%dx%d", maxTileDimensions.x, maxTileDimensions.y);
        this.tileMap = new LinkedHashMap<Integer, List<Tile>>();
        int sampleSize = this.fullImageSampleSize;
        int xTiles = 1;
        int yTiles = 1;
        while (true) {
            int sTileWidth = this.sWidth() / xTiles;
            int sTileHeight = this.sHeight() / yTiles;
            int subTileWidth = sTileWidth / sampleSize;
            int subTileHeight = sTileHeight / sampleSize;
            while (subTileWidth + xTiles + 1 > maxTileDimensions.x || (double)subTileWidth > (double)this.getWidth() * 1.25 && sampleSize < this.fullImageSampleSize) {
                sTileWidth = this.sWidth() / ++xTiles;
                subTileWidth = sTileWidth / sampleSize;
            }
            while (subTileHeight + yTiles + 1 > maxTileDimensions.y || (double)subTileHeight > (double)this.getHeight() * 1.25 && sampleSize < this.fullImageSampleSize) {
                sTileHeight = this.sHeight() / ++yTiles;
                subTileHeight = sTileHeight / sampleSize;
            }
            ArrayList<Tile> tileGrid = new ArrayList<Tile>(xTiles * yTiles);
            for (int x = 0; x < xTiles; ++x) {
                for (int y = 0; y < yTiles; ++y) {
                    Tile tile = new Tile();
                    tile.sampleSize = sampleSize;
                    tile.visible = sampleSize == this.fullImageSampleSize;
                    tile.sRect = new Rect(x * sTileWidth, y * sTileHeight, x == xTiles - 1 ? this.sWidth() : (x + 1) * sTileWidth, y == yTiles - 1 ? this.sHeight() : (y + 1) * sTileHeight);
                    tile.vRect = new Rect(0, 0, 0, 0);
                    tile.fileSRect = new Rect(tile.sRect);
                    tileGrid.add(tile);
                }
            }
            this.tileMap.put(sampleSize, tileGrid);
            if (sampleSize == 1) break;
            sampleSize /= 2;
        }
    }

    private synchronized void onTilesInited(ImageRegionDecoder decoder, int sWidth, int sHeight, int sOrientation) {
        this.debug("onTilesInited sWidth=%d, sHeight=%d, sOrientation=%d", sWidth, sHeight, this.orientation);
        if (this.sWidth > 0 && this.sHeight > 0 && (this.sWidth != sWidth || this.sHeight != sHeight)) {
            this.reset(false);
            if (this.bitmap != null) {
                if (!this.bitmapIsCached) {
                    this.bitmap.recycle();
                }
                this.bitmap = null;
                if (this.onImageEventListener != null && this.bitmapIsCached) {
                    this.onImageEventListener.onPreviewReleased();
                }
                this.bitmapIsPreview = false;
                this.bitmapIsCached = false;
            }
        }
        this.decoder = decoder;
        this.sWidth = sWidth;
        this.sHeight = sHeight;
        this.sOrientation = sOrientation;
        this.checkReady();
        if (!this.checkImageLoaded() && this.maxTileWidth > 0 && this.maxTileWidth != Integer.MAX_VALUE && this.maxTileHeight > 0 && this.maxTileHeight != Integer.MAX_VALUE && this.getWidth() > 0 && this.getHeight() > 0) {
            this.initialiseBaseLayer(new Point(this.maxTileWidth, this.maxTileHeight));
        }
        this.invalidate();
        this.requestLayout();
    }

    private synchronized void onTileLoaded() {
        this.debug("onTileLoaded", new Object[0]);
        this.checkReady();
        this.checkImageLoaded();
        if (this.isBaseLayerReady() && this.bitmap != null) {
            if (!this.bitmapIsCached) {
                this.bitmap.recycle();
            }
            this.bitmap = null;
            if (this.onImageEventListener != null && this.bitmapIsCached) {
                this.onImageEventListener.onPreviewReleased();
            }
            this.bitmapIsPreview = false;
            this.bitmapIsCached = false;
        }
        this.invalidate();
    }

    private synchronized void onPreviewLoaded(Bitmap previewBitmap) {
        this.debug("onPreviewLoaded", new Object[0]);
        if (this.bitmap != null || this.imageLoadedSent) {
            previewBitmap.recycle();
            return;
        }
        this.bitmap = this.pRegion != null ? Bitmap.createBitmap((Bitmap)previewBitmap, (int)this.pRegion.left, (int)this.pRegion.top, (int)this.pRegion.width(), (int)this.pRegion.height()) : previewBitmap;
        this.bitmapIsPreview = true;
        if (this.checkReady()) {
            this.invalidate();
            this.requestLayout();
        }
    }

    private synchronized void onImageLoaded(Bitmap bitmap, int sOrientation, boolean bitmapIsCached) {
        this.debug("onImageLoaded", new Object[0]);
        if (this.sWidth > 0 && this.sHeight > 0 && (this.sWidth != bitmap.getWidth() || this.sHeight != bitmap.getHeight())) {
            this.reset(false);
        }
        if (this.bitmap != null && !this.bitmapIsCached) {
            this.bitmap.recycle();
        }
        if (this.bitmap != null && this.bitmapIsCached && this.onImageEventListener != null) {
            this.onImageEventListener.onPreviewReleased();
        }
        this.bitmapIsPreview = false;
        this.bitmapIsCached = bitmapIsCached;
        this.bitmap = bitmap;
        this.sWidth = bitmap.getWidth();
        this.sHeight = bitmap.getHeight();
        this.sOrientation = sOrientation;
        boolean ready = this.checkReady();
        boolean imageLoaded = this.checkImageLoaded();
        if (ready || imageLoaded) {
            this.invalidate();
            this.requestLayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @AnyThread
    private int getExifOrientation(Context context, String sourceUri) {
        int exifOrientation = 0;
        if (sourceUri.startsWith("content")) {
            try (Cursor cursor = null;){
                String[] columns = new String[]{"orientation"};
                cursor = context.getContentResolver().query(Uri.parse((String)sourceUri), columns, null, null, null);
                if (cursor == null) return exifOrientation;
                if (!cursor.moveToFirst()) return exifOrientation;
                int orientation = cursor.getInt(0);
                if (VALID_ORIENTATIONS.contains(orientation) && orientation != -1) {
                    exifOrientation = orientation;
                    return exifOrientation;
                }
                Log.w((String)TAG, (String)("Unsupported orientation: " + orientation));
                return exifOrientation;
            }
        }
        if (!sourceUri.startsWith("file:///")) return exifOrientation;
        if (sourceUri.startsWith("file:///android_asset/")) return exifOrientation;
        try {
            ExifInterface exifInterface = new ExifInterface(sourceUri.substring("file:///".length() - 1));
            int orientationAttr = exifInterface.getAttributeInt("Orientation", 1);
            if (orientationAttr == 1) return 0;
            if (orientationAttr == 0) {
                return 0;
            }
            if (orientationAttr == 6) {
                return 90;
            }
            if (orientationAttr == 3) {
                return 180;
            }
            if (orientationAttr == 8) {
                return 270;
            }
            Log.w((String)TAG, (String)("Unsupported EXIF orientation: " + orientationAttr));
            return exifOrientation;
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)"Could not get EXIF orientation of image");
        }
        return exifOrientation;
    }

    private void execute(AsyncTask<Void, Void, ?> asyncTask) {
        asyncTask.executeOnExecutor(this.executor, (Object[])new Void[0]);
    }

    private void restoreState(ImageViewState state) {
        if (state != null && VALID_ORIENTATIONS.contains(state.getOrientation())) {
            this.orientation = state.getOrientation();
            this.pendingScale = Float.valueOf(state.getScale());
            this.sPendingCenter = state.getCenter();
            this.invalidate();
        }
    }

    public void setMaxTileSize(int maxPixels) {
        this.maxTileWidth = maxPixels;
        this.maxTileHeight = maxPixels;
    }

    public void setMaxTileSize(int maxPixelsX, int maxPixelsY) {
        this.maxTileWidth = maxPixelsX;
        this.maxTileHeight = maxPixelsY;
    }

    @NonNull
    private Point getMaxBitmapDimensions(Canvas canvas) {
        return new Point(Math.min(canvas.getMaximumBitmapWidth(), this.maxTileWidth), Math.min(canvas.getMaximumBitmapHeight(), this.maxTileHeight));
    }

    private int sWidth() {
        int rotation = this.getRequiredRotation();
        if (rotation == 90 || rotation == 270) {
            return this.sHeight;
        }
        return this.sWidth;
    }

    private int sHeight() {
        int rotation = this.getRequiredRotation();
        if (rotation == 90 || rotation == 270) {
            return this.sWidth;
        }
        return this.sHeight;
    }

    @AnyThread
    private void fileSRect(Rect sRect, Rect target) {
        if (this.getRequiredRotation() == 0) {
            target.set(sRect);
        } else if (this.getRequiredRotation() == 90) {
            target.set(sRect.top, this.sHeight - sRect.right, sRect.bottom, this.sHeight - sRect.left);
        } else if (this.getRequiredRotation() == 180) {
            target.set(this.sWidth - sRect.right, this.sHeight - sRect.bottom, this.sWidth - sRect.left, this.sHeight - sRect.top);
        } else {
            target.set(this.sWidth - sRect.bottom, sRect.left, this.sWidth - sRect.top, sRect.right);
        }
    }

    @AnyThread
    private int getRequiredRotation() {
        if (this.orientation == -1) {
            return this.sOrientation;
        }
        return this.orientation;
    }

    private float distance(float x0, float x1, float y0, float y1) {
        float x = x0 - x1;
        float y = y0 - y1;
        return (float)Math.sqrt(x * x + y * y);
    }

    public void recycle() {
        this.reset(true);
        this.bitmapPaint = null;
        this.debugTextPaint = null;
        this.debugLinePaint = null;
        this.tileBgPaint = null;
    }

    private float viewToSourceX(float vx) {
        if (this.vTranslate == null) {
            return Float.NaN;
        }
        return (vx - this.vTranslate.x) / this.scale;
    }

    private float viewToSourceY(float vy) {
        if (this.vTranslate == null) {
            return Float.NaN;
        }
        return (vy - this.vTranslate.y) / this.scale;
    }

    public void viewToFileRect(Rect vRect, Rect fRect) {
        if (this.vTranslate == null || !this.readySent) {
            return;
        }
        fRect.set((int)this.viewToSourceX(vRect.left), (int)this.viewToSourceY(vRect.top), (int)this.viewToSourceX(vRect.right), (int)this.viewToSourceY(vRect.bottom));
        this.fileSRect(fRect, fRect);
        fRect.set(Math.max(0, fRect.left), Math.max(0, fRect.top), Math.min(this.sWidth, fRect.right), Math.min(this.sHeight, fRect.bottom));
        if (this.sRegion != null) {
            fRect.offset(this.sRegion.left, this.sRegion.top);
        }
    }

    public void visibleFileRect(Rect fRect) {
        if (this.vTranslate == null || !this.readySent) {
            return;
        }
        fRect.set(0, 0, this.getWidth(), this.getHeight());
        this.viewToFileRect(fRect, fRect);
    }

    @Nullable
    public final PointF viewToSourceCoord(PointF vxy) {
        return this.viewToSourceCoord(vxy.x, vxy.y, new PointF());
    }

    @Nullable
    public final PointF viewToSourceCoord(float vx, float vy) {
        return this.viewToSourceCoord(vx, vy, new PointF());
    }

    @Nullable
    public final PointF viewToSourceCoord(PointF vxy, @NonNull PointF sTarget) {
        return this.viewToSourceCoord(vxy.x, vxy.y, sTarget);
    }

    @Nullable
    public final PointF viewToSourceCoord(float vx, float vy, @NonNull PointF sTarget) {
        if (this.vTranslate == null) {
            return null;
        }
        sTarget.set(this.viewToSourceX(vx), this.viewToSourceY(vy));
        return sTarget;
    }

    private float sourceToViewX(float sx) {
        if (this.vTranslate == null) {
            return Float.NaN;
        }
        return sx * this.scale + this.vTranslate.x;
    }

    private float sourceToViewY(float sy) {
        if (this.vTranslate == null) {
            return Float.NaN;
        }
        return sy * this.scale + this.vTranslate.y;
    }

    @Nullable
    public final PointF sourceToViewCoord(PointF sxy) {
        return this.sourceToViewCoord(sxy.x, sxy.y, new PointF());
    }

    @Nullable
    public final PointF sourceToViewCoord(float sx, float sy) {
        return this.sourceToViewCoord(sx, sy, new PointF());
    }

    @Nullable
    public final PointF sourceToViewCoord(PointF sxy, @NonNull PointF vTarget) {
        return this.sourceToViewCoord(sxy.x, sxy.y, vTarget);
    }

    @Nullable
    public final PointF sourceToViewCoord(float sx, float sy, @NonNull PointF vTarget) {
        if (this.vTranslate == null) {
            return null;
        }
        vTarget.set(this.sourceToViewX(sx), this.sourceToViewY(sy));
        return vTarget;
    }

    private void sourceToViewRect(@NonNull Rect sRect, @NonNull Rect vTarget) {
        vTarget.set((int)this.sourceToViewX(sRect.left), (int)this.sourceToViewY(sRect.top), (int)this.sourceToViewX(sRect.right), (int)this.sourceToViewY(sRect.bottom));
    }

    @NonNull
    private PointF vTranslateForSCenter(float sCenterX, float sCenterY, float scale) {
        int vxCenter = this.getPaddingLeft() + (this.getWidth() - this.getPaddingRight() - this.getPaddingLeft()) / 2;
        int vyCenter = this.getPaddingTop() + (this.getHeight() - this.getPaddingBottom() - this.getPaddingTop()) / 2;
        if (this.satTemp == null) {
            this.satTemp = new ScaleAndTranslate(0.0f, new PointF(0.0f, 0.0f));
        }
        this.satTemp.scale = scale;
        this.satTemp.vTranslate.set((float)vxCenter - sCenterX * scale, (float)vyCenter - sCenterY * scale);
        this.fitToBounds(true, this.satTemp);
        return this.satTemp.vTranslate;
    }

    @NonNull
    private PointF limitedSCenter(float sCenterX, float sCenterY, float scale, @NonNull PointF sTarget) {
        PointF vTranslate = this.vTranslateForSCenter(sCenterX, sCenterY, scale);
        int vxCenter = this.getPaddingLeft() + (this.getWidth() - this.getPaddingRight() - this.getPaddingLeft()) / 2;
        int vyCenter = this.getPaddingTop() + (this.getHeight() - this.getPaddingBottom() - this.getPaddingTop()) / 2;
        float sx = ((float)vxCenter - vTranslate.x) / scale;
        float sy = ((float)vyCenter - vTranslate.y) / scale;
        sTarget.set(sx, sy);
        return sTarget;
    }

    private float minScale() {
        int vPadding = this.getPaddingBottom() + this.getPaddingTop();
        int hPadding = this.getPaddingLeft() + this.getPaddingRight();
        if (this.minimumScaleType == 2 || this.minimumScaleType == 4) {
            return Math.max((float)(this.getWidth() - hPadding) / (float)this.sWidth(), (float)(this.getHeight() - vPadding) / (float)this.sHeight());
        }
        if (this.minimumScaleType == 3 && this.minScale > 0.0f) {
            return this.minScale;
        }
        return Math.min((float)(this.getWidth() - hPadding) / (float)this.sWidth(), (float)(this.getHeight() - vPadding) / (float)this.sHeight());
    }

    private float limitedScale(float targetScale) {
        targetScale = Math.max(this.minScale(), targetScale);
        targetScale = Math.min(this.maxScale, targetScale);
        return targetScale;
    }

    private float ease(int type, long time, float from, float change, long duration) {
        switch (type) {
            case 2: {
                return this.easeInOutQuad(time, from, change, duration);
            }
            case 1: {
                return this.easeOutQuad(time, from, change, duration);
            }
        }
        throw new IllegalStateException("Unexpected easing type: " + type);
    }

    private float easeOutQuad(long time, float from, float change, long duration) {
        float progress = (float)time / (float)duration;
        return -change * progress * (progress - 2.0f) + from;
    }

    private float easeInOutQuad(long time, float from, float change, long duration) {
        float timeF = (float)time / ((float)duration / 2.0f);
        if (timeF < 1.0f) {
            return change / 2.0f * timeF * timeF + from;
        }
        return -change / 2.0f * ((timeF -= 1.0f) * (timeF - 2.0f) - 1.0f) + from;
    }

    @AnyThread
    private void debug(String message, Object ... args) {
        if (this.debug) {
            Log.d((String)TAG, (String)String.format(message, args));
        }
    }

    private int px(int px) {
        return (int)(this.density * (float)px);
    }

    public final void setRegionDecoderClass(@NonNull Class<? extends ImageRegionDecoder> regionDecoderClass) {
        if (regionDecoderClass == null) {
            throw new IllegalArgumentException("Decoder class cannot be set to null");
        }
        this.regionDecoderFactory = new CompatDecoderFactory<ImageRegionDecoder>(regionDecoderClass);
    }

    public final void setRegionDecoderFactory(@NonNull DecoderFactory<? extends ImageRegionDecoder> regionDecoderFactory) {
        if (regionDecoderFactory == null) {
            throw new IllegalArgumentException("Decoder factory cannot be set to null");
        }
        this.regionDecoderFactory = regionDecoderFactory;
    }

    public final void setBitmapDecoderClass(@NonNull Class<? extends ImageDecoder> bitmapDecoderClass) {
        if (bitmapDecoderClass == null) {
            throw new IllegalArgumentException("Decoder class cannot be set to null");
        }
        this.bitmapDecoderFactory = new CompatDecoderFactory<ImageDecoder>(bitmapDecoderClass);
    }

    public final void setBitmapDecoderFactory(@NonNull DecoderFactory<? extends ImageDecoder> bitmapDecoderFactory) {
        if (bitmapDecoderFactory == null) {
            throw new IllegalArgumentException("Decoder factory cannot be set to null");
        }
        this.bitmapDecoderFactory = bitmapDecoderFactory;
    }

    public final void getPanRemaining(RectF vTarget) {
        if (!this.isReady()) {
            return;
        }
        float scaleWidth = this.scale * (float)this.sWidth();
        float scaleHeight = this.scale * (float)this.sHeight();
        if (this.panLimit == 3) {
            vTarget.top = Math.max(0.0f, -(this.vTranslate.y - (float)(this.getHeight() / 2)));
            vTarget.left = Math.max(0.0f, -(this.vTranslate.x - (float)(this.getWidth() / 2)));
            vTarget.bottom = Math.max(0.0f, this.vTranslate.y - ((float)(this.getHeight() / 2) - scaleHeight));
            vTarget.right = Math.max(0.0f, this.vTranslate.x - ((float)(this.getWidth() / 2) - scaleWidth));
        } else if (this.panLimit == 2) {
            vTarget.top = Math.max(0.0f, -(this.vTranslate.y - (float)this.getHeight()));
            vTarget.left = Math.max(0.0f, -(this.vTranslate.x - (float)this.getWidth()));
            vTarget.bottom = Math.max(0.0f, this.vTranslate.y + scaleHeight);
            vTarget.right = Math.max(0.0f, this.vTranslate.x + scaleWidth);
        } else {
            vTarget.top = Math.max(0.0f, -this.vTranslate.y);
            vTarget.left = Math.max(0.0f, -this.vTranslate.x);
            vTarget.bottom = Math.max(0.0f, scaleHeight + this.vTranslate.y - (float)this.getHeight());
            vTarget.right = Math.max(0.0f, scaleWidth + this.vTranslate.x - (float)this.getWidth());
        }
    }

    public final void setPanLimit(int panLimit) {
        if (!VALID_PAN_LIMITS.contains(panLimit)) {
            throw new IllegalArgumentException("Invalid pan limit: " + panLimit);
        }
        this.panLimit = panLimit;
        if (this.isReady()) {
            this.fitToBounds(true);
            this.invalidate();
        }
    }

    public final void setMinimumScaleType(int scaleType) {
        if (!VALID_SCALE_TYPES.contains(scaleType)) {
            throw new IllegalArgumentException("Invalid scale type: " + scaleType);
        }
        this.minimumScaleType = scaleType;
        if (this.isReady()) {
            this.fitToBounds(true);
            this.invalidate();
        }
    }

    public final void setMaxScale(float maxScale) {
        this.maxScale = maxScale;
    }

    public final void setMinScale(float minScale) {
        this.minScale = minScale;
    }

    public final void setMinimumDpi(int dpi) {
        DisplayMetrics metrics = this.getResources().getDisplayMetrics();
        float averageDpi = (metrics.xdpi + metrics.ydpi) / 2.0f;
        this.setMaxScale(averageDpi / (float)dpi);
    }

    public final void setMaximumDpi(int dpi) {
        DisplayMetrics metrics = this.getResources().getDisplayMetrics();
        float averageDpi = (metrics.xdpi + metrics.ydpi) / 2.0f;
        this.setMinScale(averageDpi / (float)dpi);
    }

    public float getMaxScale() {
        return this.maxScale;
    }

    public final float getMinScale() {
        return this.minScale();
    }

    public void setMinimumTileDpi(int minimumTileDpi) {
        DisplayMetrics metrics = this.getResources().getDisplayMetrics();
        float averageDpi = (metrics.xdpi + metrics.ydpi) / 2.0f;
        this.minimumTileDpi = (int)Math.min(averageDpi, (float)minimumTileDpi);
        if (this.isReady()) {
            this.reset(false);
            this.invalidate();
        }
    }

    @Nullable
    public final PointF getCenter() {
        int mX = this.getWidth() / 2;
        int mY = this.getHeight() / 2;
        return this.viewToSourceCoord(mX, mY);
    }

    public final float getScale() {
        return this.scale;
    }

    public final void setScaleAndCenter(float scale, @Nullable PointF sCenter) {
        this.anim = null;
        this.pendingScale = Float.valueOf(scale);
        this.sPendingCenter = sCenter;
        this.sRequestedCenter = sCenter;
        this.invalidate();
    }

    public final void resetScaleAndCenter() {
        this.anim = null;
        this.pendingScale = Float.valueOf(this.limitedScale(0.0f));
        this.sPendingCenter = this.isReady() ? new PointF((float)(this.sWidth() / 2), (float)(this.sHeight() / 2)) : new PointF(0.0f, 0.0f);
        this.invalidate();
    }

    public final boolean isReady() {
        return this.readySent;
    }

    protected void onReady() {
    }

    public final boolean isImageLoaded() {
        return this.imageLoadedSent;
    }

    protected void onImageLoaded() {
    }

    public final int getSWidth() {
        return this.sWidth;
    }

    public final int getSHeight() {
        return this.sHeight;
    }

    public final int getOrientation() {
        return this.orientation;
    }

    public final int getAppliedOrientation() {
        return this.getRequiredRotation();
    }

    @Nullable
    public final ImageViewState getState() {
        if (this.vTranslate != null && this.sWidth > 0 && this.sHeight > 0) {
            return new ImageViewState(this.getScale(), this.getCenter(), this.getOrientation());
        }
        return null;
    }

    public final boolean isZoomEnabled() {
        return this.zoomEnabled;
    }

    public final void setZoomEnabled(boolean zoomEnabled) {
        this.zoomEnabled = zoomEnabled;
    }

    public final boolean isQuickScaleEnabled() {
        return this.quickScaleEnabled;
    }

    public final void setQuickScaleEnabled(boolean quickScaleEnabled) {
        this.quickScaleEnabled = quickScaleEnabled;
    }

    public final boolean isPanEnabled() {
        return this.panEnabled;
    }

    public final void setPanEnabled(boolean panEnabled) {
        this.panEnabled = panEnabled;
        if (!panEnabled && this.vTranslate != null) {
            this.vTranslate.x = (float)(this.getWidth() / 2) - this.scale * (float)(this.sWidth() / 2);
            this.vTranslate.y = (float)(this.getHeight() / 2) - this.scale * (float)(this.sHeight() / 2);
            if (this.isReady()) {
                this.refreshRequiredTiles(true);
                this.invalidate();
            }
        }
    }

    public final void setTileBackgroundColor(int tileBgColor) {
        if (Color.alpha((int)tileBgColor) == 0) {
            this.tileBgPaint = null;
        } else {
            this.tileBgPaint = new Paint();
            this.tileBgPaint.setStyle(Paint.Style.FILL);
            this.tileBgPaint.setColor(tileBgColor);
        }
        this.invalidate();
    }

    public final void setDoubleTapZoomScale(float doubleTapZoomScale) {
        this.doubleTapZoomScale = doubleTapZoomScale;
    }

    public final void setDoubleTapZoomDpi(int dpi) {
        DisplayMetrics metrics = this.getResources().getDisplayMetrics();
        float averageDpi = (metrics.xdpi + metrics.ydpi) / 2.0f;
        this.setDoubleTapZoomScale(averageDpi / (float)dpi);
    }

    public final void setDoubleTapZoomStyle(int doubleTapZoomStyle) {
        if (!VALID_ZOOM_STYLES.contains(doubleTapZoomStyle)) {
            throw new IllegalArgumentException("Invalid zoom style: " + doubleTapZoomStyle);
        }
        this.doubleTapZoomStyle = doubleTapZoomStyle;
    }

    public final void setDoubleTapZoomDuration(int durationMs) {
        this.doubleTapZoomDuration = Math.max(0, durationMs);
    }

    public void setExecutor(@NonNull Executor executor) {
        if (executor == null) {
            throw new NullPointerException("Executor must not be null");
        }
        this.executor = executor;
    }

    public void setEagerLoadingEnabled(boolean eagerLoadingEnabled) {
        this.eagerLoadingEnabled = eagerLoadingEnabled;
    }

    public final void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean hasImage() {
        return this.uri != null || this.bitmap != null;
    }

    public void setOnLongClickListener(View.OnLongClickListener onLongClickListener) {
        this.onLongClickListener = onLongClickListener;
    }

    public void setOnImageEventListener(OnImageEventListener onImageEventListener) {
        this.onImageEventListener = onImageEventListener;
    }

    public void setOnStateChangedListener(OnStateChangedListener onStateChangedListener) {
        this.onStateChangedListener = onStateChangedListener;
    }

    private void sendStateChanged(float oldScale, PointF oldVTranslate, int origin) {
        if (this.onStateChangedListener != null && this.scale != oldScale) {
            this.onStateChangedListener.onScaleChanged(this.scale, origin);
        }
        if (this.onStateChangedListener != null && !this.vTranslate.equals((Object)oldVTranslate)) {
            this.onStateChangedListener.onCenterChanged(this.getCenter(), origin);
        }
    }

    @Nullable
    public AnimationBuilder animateCenter(PointF sCenter) {
        if (!this.isReady()) {
            return null;
        }
        return new AnimationBuilder(sCenter);
    }

    @Nullable
    public AnimationBuilder animateScale(float scale) {
        if (!this.isReady()) {
            return null;
        }
        return new AnimationBuilder(scale);
    }

    @Nullable
    public AnimationBuilder animateScaleAndCenter(float scale, PointF sCenter) {
        if (!this.isReady()) {
            return null;
        }
        return new AnimationBuilder(scale, sCenter);
    }

    public static class DefaultOnStateChangedListener
    implements OnStateChangedListener {
        @Override
        public void onCenterChanged(PointF newCenter, int origin) {
        }

        @Override
        public void onScaleChanged(float newScale, int origin) {
        }
    }

    public static interface OnStateChangedListener {
        public void onScaleChanged(float var1, int var2);

        public void onCenterChanged(PointF var1, int var2);
    }

    public static class DefaultOnImageEventListener
    implements OnImageEventListener {
        @Override
        public void onReady() {
        }

        @Override
        public void onImageLoaded() {
        }

        @Override
        public void onPreviewLoadError(Exception e) {
        }

        @Override
        public void onImageLoadError(Exception e) {
        }

        @Override
        public void onTileLoadError(Exception e) {
        }

        @Override
        public void onPreviewReleased() {
        }
    }

    public static interface OnImageEventListener {
        public void onReady();

        public void onImageLoaded();

        public void onPreviewLoadError(Exception var1);

        public void onImageLoadError(Exception var1);

        public void onTileLoadError(Exception var1);

        public void onPreviewReleased();
    }

    public static class DefaultOnAnimationEventListener
    implements OnAnimationEventListener {
        @Override
        public void onComplete() {
        }

        @Override
        public void onInterruptedByUser() {
        }

        @Override
        public void onInterruptedByNewAnim() {
        }
    }

    public static interface OnAnimationEventListener {
        public void onComplete();

        public void onInterruptedByUser();

        public void onInterruptedByNewAnim();
    }

    public final class AnimationBuilder {
        private final float targetScale;
        private final PointF targetSCenter;
        private final PointF vFocus;
        private long duration = 500L;
        private int easing = 2;
        private int origin = 1;
        private boolean interruptible = true;
        private boolean panLimited = true;
        private OnAnimationEventListener listener;

        private AnimationBuilder(PointF sCenter) {
            this.targetScale = SubsamplingScaleImageView.this.scale;
            this.targetSCenter = sCenter;
            this.vFocus = null;
        }

        private AnimationBuilder(float scale) {
            this.targetScale = scale;
            this.targetSCenter = SubsamplingScaleImageView.this.getCenter();
            this.vFocus = null;
        }

        private AnimationBuilder(float scale, PointF sCenter) {
            this.targetScale = scale;
            this.targetSCenter = sCenter;
            this.vFocus = null;
        }

        private AnimationBuilder(float scale, PointF sCenter, PointF vFocus) {
            this.targetScale = scale;
            this.targetSCenter = sCenter;
            this.vFocus = vFocus;
        }

        @NonNull
        public AnimationBuilder withDuration(long duration) {
            this.duration = duration;
            return this;
        }

        @NonNull
        public AnimationBuilder withInterruptible(boolean interruptible) {
            this.interruptible = interruptible;
            return this;
        }

        @NonNull
        public AnimationBuilder withEasing(int easing) {
            if (!VALID_EASING_STYLES.contains(easing)) {
                throw new IllegalArgumentException("Unknown easing type: " + easing);
            }
            this.easing = easing;
            return this;
        }

        @NonNull
        public AnimationBuilder withOnAnimationEventListener(OnAnimationEventListener listener) {
            this.listener = listener;
            return this;
        }

        @NonNull
        private AnimationBuilder withPanLimited(boolean panLimited) {
            this.panLimited = panLimited;
            return this;
        }

        @NonNull
        private AnimationBuilder withOrigin(int origin) {
            this.origin = origin;
            return this;
        }

        public void start() {
            if (SubsamplingScaleImageView.this.anim != null && SubsamplingScaleImageView.this.anim.listener != null) {
                try {
                    SubsamplingScaleImageView.this.anim.listener.onInterruptedByNewAnim();
                }
                catch (Exception e) {
                    Log.w((String)TAG, (String)"Error thrown by animation listener", (Throwable)e);
                }
            }
            int vxCenter = SubsamplingScaleImageView.this.getPaddingLeft() + (SubsamplingScaleImageView.this.getWidth() - SubsamplingScaleImageView.this.getPaddingRight() - SubsamplingScaleImageView.this.getPaddingLeft()) / 2;
            int vyCenter = SubsamplingScaleImageView.this.getPaddingTop() + (SubsamplingScaleImageView.this.getHeight() - SubsamplingScaleImageView.this.getPaddingBottom() - SubsamplingScaleImageView.this.getPaddingTop()) / 2;
            float targetScale = SubsamplingScaleImageView.this.limitedScale(this.targetScale);
            PointF targetSCenter = this.panLimited ? SubsamplingScaleImageView.this.limitedSCenter(this.targetSCenter.x, this.targetSCenter.y, targetScale, new PointF()) : this.targetSCenter;
            SubsamplingScaleImageView.this.anim = new Anim();
            SubsamplingScaleImageView.this.anim.scaleStart = SubsamplingScaleImageView.this.scale;
            SubsamplingScaleImageView.this.anim.scaleEnd = targetScale;
            SubsamplingScaleImageView.this.anim.time = System.currentTimeMillis();
            SubsamplingScaleImageView.this.anim.sCenterEndRequested = targetSCenter;
            SubsamplingScaleImageView.this.anim.sCenterStart = SubsamplingScaleImageView.this.getCenter();
            SubsamplingScaleImageView.this.anim.sCenterEnd = targetSCenter;
            SubsamplingScaleImageView.this.anim.vFocusStart = SubsamplingScaleImageView.this.sourceToViewCoord(targetSCenter);
            SubsamplingScaleImageView.this.anim.vFocusEnd = new PointF((float)vxCenter, (float)vyCenter);
            SubsamplingScaleImageView.this.anim.duration = this.duration;
            SubsamplingScaleImageView.this.anim.interruptible = this.interruptible;
            SubsamplingScaleImageView.this.anim.easing = this.easing;
            SubsamplingScaleImageView.this.anim.origin = this.origin;
            SubsamplingScaleImageView.this.anim.time = System.currentTimeMillis();
            SubsamplingScaleImageView.this.anim.listener = this.listener;
            if (this.vFocus != null) {
                float vTranslateXEnd = this.vFocus.x - targetScale * ((Anim)((SubsamplingScaleImageView)SubsamplingScaleImageView.this).anim).sCenterStart.x;
                float vTranslateYEnd = this.vFocus.y - targetScale * ((Anim)((SubsamplingScaleImageView)SubsamplingScaleImageView.this).anim).sCenterStart.y;
                ScaleAndTranslate satEnd = new ScaleAndTranslate(targetScale, new PointF(vTranslateXEnd, vTranslateYEnd));
                SubsamplingScaleImageView.this.fitToBounds(true, satEnd);
                SubsamplingScaleImageView.this.anim.vFocusEnd = new PointF(this.vFocus.x + (((ScaleAndTranslate)satEnd).vTranslate.x - vTranslateXEnd), this.vFocus.y + (((ScaleAndTranslate)satEnd).vTranslate.y - vTranslateYEnd));
            }
            SubsamplingScaleImageView.this.invalidate();
        }
    }

    private static class ScaleAndTranslate {
        private float scale;
        private final PointF vTranslate;

        private ScaleAndTranslate(float scale, PointF vTranslate) {
            this.scale = scale;
            this.vTranslate = vTranslate;
        }
    }

    private static class Anim {
        private float scaleStart;
        private float scaleEnd;
        private PointF sCenterStart;
        private PointF sCenterEnd;
        private PointF sCenterEndRequested;
        private PointF vFocusStart;
        private PointF vFocusEnd;
        private long duration = 500L;
        private boolean interruptible = true;
        private int easing = 2;
        private int origin = 1;
        private long time = System.currentTimeMillis();
        private OnAnimationEventListener listener;

        private Anim() {
        }
    }

    private static class Tile {
        private Rect sRect;
        private int sampleSize;
        private Bitmap bitmap;
        private boolean loading;
        private boolean visible;
        private Rect vRect;
        private Rect fileSRect;

        private Tile() {
        }
    }

    private static class BitmapLoadTask
    extends AsyncTask<Void, Void, Integer> {
        private final WeakReference<SubsamplingScaleImageView> viewRef;
        private final WeakReference<Context> contextRef;
        private final WeakReference<DecoderFactory<? extends ImageDecoder>> decoderFactoryRef;
        private final Uri source;
        private final boolean preview;
        private Bitmap bitmap;
        private Exception exception;

        BitmapLoadTask(SubsamplingScaleImageView view, Context context, DecoderFactory<? extends ImageDecoder> decoderFactory, Uri source, boolean preview) {
            this.viewRef = new WeakReference<SubsamplingScaleImageView>(view);
            this.contextRef = new WeakReference<Context>(context);
            this.decoderFactoryRef = new WeakReference<DecoderFactory<? extends ImageDecoder>>(decoderFactory);
            this.source = source;
            this.preview = preview;
        }

        protected Integer doInBackground(Void ... params) {
            try {
                String sourceUri = this.source.toString();
                Context context = (Context)this.contextRef.get();
                DecoderFactory decoderFactory = (DecoderFactory)this.decoderFactoryRef.get();
                SubsamplingScaleImageView view = (SubsamplingScaleImageView)((Object)this.viewRef.get());
                if (context != null && decoderFactory != null && view != null) {
                    view.debug("BitmapLoadTask.doInBackground", new Object[0]);
                    this.bitmap = ((ImageDecoder)decoderFactory.make()).decode(context, this.source);
                    return view.getExifOrientation(context, sourceUri);
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Failed to load bitmap", (Throwable)e);
                this.exception = e;
            }
            catch (OutOfMemoryError e) {
                Log.e((String)TAG, (String)"Failed to load bitmap - OutOfMemoryError", (Throwable)e);
                this.exception = new RuntimeException(e);
            }
            return null;
        }

        protected void onPostExecute(Integer orientation) {
            SubsamplingScaleImageView subsamplingScaleImageView = (SubsamplingScaleImageView)((Object)this.viewRef.get());
            if (subsamplingScaleImageView != null) {
                if (this.bitmap != null && orientation != null) {
                    if (this.preview) {
                        subsamplingScaleImageView.onPreviewLoaded(this.bitmap);
                    } else {
                        subsamplingScaleImageView.onImageLoaded(this.bitmap, orientation, false);
                    }
                } else if (this.exception != null && subsamplingScaleImageView.onImageEventListener != null) {
                    if (this.preview) {
                        subsamplingScaleImageView.onImageEventListener.onPreviewLoadError(this.exception);
                    } else {
                        subsamplingScaleImageView.onImageEventListener.onImageLoadError(this.exception);
                    }
                }
            }
        }
    }

    private static class TileLoadTask
    extends AsyncTask<Void, Void, Bitmap> {
        private final WeakReference<SubsamplingScaleImageView> viewRef;
        private final WeakReference<ImageRegionDecoder> decoderRef;
        private final WeakReference<Tile> tileRef;
        private Exception exception;

        TileLoadTask(SubsamplingScaleImageView view, ImageRegionDecoder decoder, Tile tile) {
            this.viewRef = new WeakReference<SubsamplingScaleImageView>(view);
            this.decoderRef = new WeakReference<ImageRegionDecoder>(decoder);
            this.tileRef = new WeakReference<Tile>(tile);
            tile.loading = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected Bitmap doInBackground(Void ... params) {
            try {
                SubsamplingScaleImageView view = (SubsamplingScaleImageView)((Object)this.viewRef.get());
                ImageRegionDecoder decoder = (ImageRegionDecoder)this.decoderRef.get();
                Tile tile = (Tile)this.tileRef.get();
                if (decoder != null && tile != null && view != null && decoder.isReady() && tile.visible) {
                    view.debug("TileLoadTask.doInBackground, tile.sRect=%s, tile.sampleSize=%d", new Object[]{tile.sRect, tile.sampleSize});
                    view.decoderLock.readLock().lock();
                    try {
                        if (decoder.isReady()) {
                            view.fileSRect(tile.sRect, tile.fileSRect);
                            if (view.sRegion != null) {
                                tile.fileSRect.offset(((SubsamplingScaleImageView)view).sRegion.left, ((SubsamplingScaleImageView)view).sRegion.top);
                            }
                            Bitmap bitmap = decoder.decodeRegion(tile.fileSRect, tile.sampleSize);
                            return bitmap;
                        }
                        tile.loading = false;
                        return null;
                    }
                    finally {
                        view.decoderLock.readLock().unlock();
                    }
                }
                if (tile == null) return null;
                tile.loading = false;
                return null;
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Failed to decode tile", (Throwable)e);
                this.exception = e;
                return null;
            }
            catch (OutOfMemoryError e) {
                Log.e((String)TAG, (String)"Failed to decode tile - OutOfMemoryError", (Throwable)e);
                this.exception = new RuntimeException(e);
            }
            return null;
        }

        protected void onPostExecute(Bitmap bitmap) {
            SubsamplingScaleImageView subsamplingScaleImageView = (SubsamplingScaleImageView)((Object)this.viewRef.get());
            Tile tile = (Tile)this.tileRef.get();
            if (subsamplingScaleImageView != null && tile != null) {
                if (bitmap != null) {
                    tile.bitmap = bitmap;
                    tile.loading = false;
                    subsamplingScaleImageView.onTileLoaded();
                } else if (this.exception != null && subsamplingScaleImageView.onImageEventListener != null) {
                    subsamplingScaleImageView.onImageEventListener.onTileLoadError(this.exception);
                }
            }
        }
    }

    private static class TilesInitTask
    extends AsyncTask<Void, Void, int[]> {
        private final WeakReference<SubsamplingScaleImageView> viewRef;
        private final WeakReference<Context> contextRef;
        private final WeakReference<DecoderFactory<? extends ImageRegionDecoder>> decoderFactoryRef;
        private final Uri source;
        private ImageRegionDecoder decoder;
        private Exception exception;

        TilesInitTask(SubsamplingScaleImageView view, Context context, DecoderFactory<? extends ImageRegionDecoder> decoderFactory, Uri source) {
            this.viewRef = new WeakReference<SubsamplingScaleImageView>(view);
            this.contextRef = new WeakReference<Context>(context);
            this.decoderFactoryRef = new WeakReference<DecoderFactory<? extends ImageRegionDecoder>>(decoderFactory);
            this.source = source;
        }

        protected int[] doInBackground(Void ... params) {
            try {
                String sourceUri = this.source.toString();
                Context context = (Context)this.contextRef.get();
                DecoderFactory decoderFactory = (DecoderFactory)this.decoderFactoryRef.get();
                SubsamplingScaleImageView view = (SubsamplingScaleImageView)((Object)this.viewRef.get());
                if (context != null && decoderFactory != null && view != null) {
                    view.debug("TilesInitTask.doInBackground", new Object[0]);
                    this.decoder = (ImageRegionDecoder)decoderFactory.make();
                    Point dimensions = this.decoder.init(context, this.source);
                    int sWidth = dimensions.x;
                    int sHeight = dimensions.y;
                    int exifOrientation = view.getExifOrientation(context, sourceUri);
                    if (view.sRegion != null) {
                        ((SubsamplingScaleImageView)view).sRegion.left = Math.max(0, ((SubsamplingScaleImageView)view).sRegion.left);
                        ((SubsamplingScaleImageView)view).sRegion.top = Math.max(0, ((SubsamplingScaleImageView)view).sRegion.top);
                        ((SubsamplingScaleImageView)view).sRegion.right = Math.min(sWidth, ((SubsamplingScaleImageView)view).sRegion.right);
                        ((SubsamplingScaleImageView)view).sRegion.bottom = Math.min(sHeight, ((SubsamplingScaleImageView)view).sRegion.bottom);
                        sWidth = view.sRegion.width();
                        sHeight = view.sRegion.height();
                    }
                    return new int[]{sWidth, sHeight, exifOrientation};
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Failed to initialise bitmap decoder", (Throwable)e);
                this.exception = e;
            }
            return null;
        }

        protected void onPostExecute(int[] xyo) {
            SubsamplingScaleImageView view = (SubsamplingScaleImageView)((Object)this.viewRef.get());
            if (view != null) {
                if (this.decoder != null && xyo != null && xyo.length == 3) {
                    view.onTilesInited(this.decoder, xyo[0], xyo[1], xyo[2]);
                } else if (this.exception != null && view.onImageEventListener != null) {
                    view.onImageEventListener.onImageLoadError(this.exception);
                }
            }
        }
    }
}

