/*
 * Decompiled with CFR 0.152.
 */
package com.datatheorem.android.trustkit.utils;

import android.content.Context;
import android.content.SharedPreferences;
import androidx.annotation.NonNull;
import androidx.preference.PreferenceManager;
import com.datatheorem.android.trustkit.utils.TrustKitLog;
import java.util.UUID;

public class VendorIdentifier {
    private static final String TRUSTKIT_VENDOR_ID = "TRUSTKIT_VENDOR_ID";

    @NonNull
    public static String getOrCreate(@NonNull Context appContext) {
        SharedPreferences trustKitSharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)appContext);
        String appVendorId = trustKitSharedPreferences.getString(TRUSTKIT_VENDOR_ID, "");
        if (appVendorId.equals("")) {
            TrustKitLog.i("Generating new vendor identifier...");
            appVendorId = UUID.randomUUID().toString();
            SharedPreferences.Editor editor = trustKitSharedPreferences.edit();
            editor.putString(TRUSTKIT_VENDOR_ID, appVendorId);
            editor.apply();
        }
        return appVendorId;
    }
}

