/*
 * Decompiled with CFR 0.152.
 */
package com.datatheorem.android.trustkit.reporting;

import android.text.format.DateFormat;
import androidx.annotation.NonNull;
import com.datatheorem.android.trustkit.config.PublicKeyPin;
import com.datatheorem.android.trustkit.pinning.PinningValidationResult;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PinningFailureReport
implements Serializable {
    private static final String APP_PLATFORM = "ANDROID";
    private static final String trustKitVersion = "1.1.4";
    @NonNull
    private final String appBundleId;
    @NonNull
    private final String appVersion;
    @NonNull
    private final String appVendorId;
    @NonNull
    private final PinningValidationResult validationResult;
    @NonNull
    private final String serverHostname;
    private final int serverPort;
    @NonNull
    private final String notedHostname;
    private final boolean includeSubdomains;
    private final boolean enforcePinning;
    @NonNull
    private final List<String> servedCertificateChainAsPem;
    @NonNull
    private final List<String> validatedCertificateChainAsPem;
    @NonNull
    private final Date dateTime;
    @NonNull
    private final Set<PublicKeyPin> knownPins;

    PinningFailureReport(@NonNull String appBundleId, @NonNull String appVersion, @NonNull String appVendorId, @NonNull String hostname, int port, @NonNull String notedHostname, boolean includeSubdomains, boolean enforcePinning, @NonNull List<String> servedCertificateChain, @NonNull List<String> validatedCertificateChain, @NonNull Date dateTime, @NonNull Set<PublicKeyPin> knownPins, @NonNull PinningValidationResult validationResult) {
        this.appBundleId = appBundleId;
        this.appVersion = appVersion;
        this.appVendorId = appVendorId;
        this.serverHostname = hostname;
        this.serverPort = port;
        this.notedHostname = notedHostname;
        this.includeSubdomains = includeSubdomains;
        this.enforcePinning = enforcePinning;
        this.servedCertificateChainAsPem = servedCertificateChain;
        this.validatedCertificateChainAsPem = validatedCertificateChain;
        this.dateTime = dateTime;
        this.knownPins = knownPins;
        this.validationResult = validationResult;
    }

    JSONObject toJson() {
        JSONObject jsonReport = new JSONObject();
        try {
            jsonReport.put("app-bundle-id", (Object)this.appBundleId);
            jsonReport.put("app-version", (Object)String.valueOf(this.appVersion));
            jsonReport.put("app-vendor-id", (Object)this.appVendorId);
            jsonReport.put("app-platform", (Object)APP_PLATFORM);
            jsonReport.put("trustkit-version", (Object)trustKitVersion);
            jsonReport.put("hostname", (Object)this.serverHostname);
            jsonReport.put("port", this.serverPort);
            jsonReport.put("noted-hostname", (Object)this.notedHostname);
            jsonReport.put("include-subdomains", this.includeSubdomains);
            jsonReport.put("enforce-pinning", this.enforcePinning);
            jsonReport.put("validation-result", this.validationResult.ordinal());
            jsonReport.put("date-time", (Object)DateFormat.format((CharSequence)"yyyy-MM-dd'T'HH:mm:ssZ", (Date)this.dateTime));
            JSONArray ValidatedCertificateChainAsJson = new JSONArray();
            for (String string : this.validatedCertificateChainAsPem) {
                ValidatedCertificateChainAsJson.put((Object)string);
            }
            jsonReport.put("validated-certificate-chain", (Object)ValidatedCertificateChainAsJson);
            JSONArray ServedCertificateChainAsJson = new JSONArray();
            for (String validatedCertificate : this.servedCertificateChainAsPem) {
                ServedCertificateChainAsJson.put((Object)validatedCertificate);
            }
            jsonReport.put("served-certificate-chain", (Object)ServedCertificateChainAsJson);
            JSONArray jSONArray = new JSONArray();
            for (PublicKeyPin knownPin : this.knownPins) {
                jSONArray.put((Object)("pin-sha256=\"" + knownPin.toString() + "\""));
            }
            jsonReport.put("known-pins", (Object)jSONArray);
        }
        catch (JSONException ex) {
            throw new IllegalStateException("JSON error for report: " + this.toString());
        }
        return jsonReport;
    }

    public String toString() {
        try {
            return this.toJson().toString(2);
        }
        catch (JSONException e) {
            return this.toJson().toString();
        }
    }

    @NonNull
    public String getNotedHostname() {
        return this.notedHostname;
    }

    @NonNull
    public String getServerHostname() {
        return this.serverHostname;
    }

    @NonNull
    List<String> getValidatedCertificateChainAsPem() {
        return this.validatedCertificateChainAsPem;
    }

    @NonNull
    public PinningValidationResult getValidationResult() {
        return this.validationResult;
    }

    int getServerPort() {
        return this.serverPort;
    }
}

