/*
 * Decompiled with CFR 0.152.
 */
package com.datatheorem.android.trustkit.reporting;

import android.os.AsyncTask;
import android.util.Base64;
import androidx.annotation.RequiresApi;
import com.datatheorem.android.trustkit.pinning.SystemTrustManager;
import com.datatheorem.android.trustkit.reporting.PinningFailureReport;
import com.datatheorem.android.trustkit.utils.TrustKitLog;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

@RequiresApi(api=16)
class BackgroundReporterTask
extends AsyncTask<Object, Void, Integer> {
    private static final SSLSocketFactory systemSocketFactory = BackgroundReporterTask.getSystemSSLSocketFactory();

    BackgroundReporterTask() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Integer doInBackground(Object ... params) {
        Integer lastResponseCode = null;
        PinningFailureReport report = (PinningFailureReport)params[0];
        for (int i = 1; i < params.length; ++i) {
            URL reportUri = (URL)params[i];
            HttpURLConnection connection = null;
            try {
                connection = (HttpURLConnection)reportUri.openConnection();
                connection.setRequestMethod("POST");
                connection.setRequestProperty("Content-Type", "application/json");
                connection.setDoOutput(true);
                connection.setChunkedStreamingMode(0);
                if (reportUri.getUserInfo() != null) {
                    String basicAuth = "Basic " + new String(Base64.encode((byte[])reportUri.getUserInfo().getBytes(), (int)0));
                    connection.setRequestProperty("Authorization", basicAuth);
                }
                if (connection instanceof HttpsURLConnection) {
                    HttpsURLConnection httpsConnection = (HttpsURLConnection)connection;
                    httpsConnection.setSSLSocketFactory(systemSocketFactory);
                }
                connection.connect();
                BufferedOutputStream stream = new BufferedOutputStream(connection.getOutputStream());
                ((OutputStream)stream).write(report.toJson().toString().getBytes("UTF-8"));
                ((OutputStream)stream).flush();
                ((OutputStream)stream).close();
                lastResponseCode = connection.getResponseCode();
                continue;
            }
            catch (IOException e) {
                TrustKitLog.i("Background upload - task completed with error:" + e.getMessage());
                continue;
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
        }
        return lastResponseCode;
    }

    private static SSLSocketFactory getSystemSSLSocketFactory() {
        SSLContext context;
        try {
            context = SSLContext.getInstance("TLS");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Should never happen");
        }
        if (context == null) {
            throw new IllegalStateException("Should never happen");
        }
        try {
            context.init(null, new TrustManager[]{SystemTrustManager.getInstance()}, null);
        }
        catch (KeyManagementException e) {
            throw new IllegalStateException("Should never happen");
        }
        return context.getSocketFactory();
    }
}

