/*
 * Decompiled with CFR 0.152.
 */
package com.datatheorem.android.trustkit.pinning;

import androidx.annotation.NonNull;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class SystemTrustManager {
    private static final X509TrustManager systemTrustManager = SystemTrustManager.getSystemTrustManager();

    @NonNull
    public static X509TrustManager getInstance() {
        return systemTrustManager;
    }

    private static X509TrustManager getSystemTrustManager() {
        TrustManagerFactory trustManagerFactory;
        X509TrustManager systemTrustManager = null;
        try {
            trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Should never happen");
        }
        try {
            trustManagerFactory.init((KeyStore)null);
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException("Should never happen");
        }
        for (TrustManager trustManager : trustManagerFactory.getTrustManagers()) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            systemTrustManager = (X509TrustManager)trustManager;
        }
        if (systemTrustManager == null) {
            throw new IllegalStateException("Should never happen");
        }
        return systemTrustManager;
    }
}

