/*
 * Decompiled with CFR 0.152.
 */
package com.datatheorem.android.trustkit.pinning;

import android.net.http.X509TrustManagerExtensions;
import android.os.Build;
import androidx.annotation.NonNull;
import com.datatheorem.android.trustkit.TrustKit;
import com.datatheorem.android.trustkit.config.DomainPinningPolicy;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509TrustManager;

class OkHttpRootTrustManager
implements X509TrustManager {
    private final ThreadLocal<String> mServerHostname = new ThreadLocal();

    OkHttpRootTrustManager() {
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        TrustKit.getInstance().getTrustManager(this.mServerHostname.get()).checkClientTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        String host = this.mServerHostname.get();
        DomainPinningPolicy serverConfig = TrustKit.getInstance().getConfiguration().getPolicyForHostname(host);
        X509TrustManager trustManager = TrustKit.getInstance().getTrustManager(host);
        if (serverConfig == null && Build.VERSION.SDK_INT >= 17) {
            new X509TrustManagerExtensions(trustManager).checkServerTrusted(chain, authType, host);
        } else {
            trustManager.checkServerTrusted(chain, authType);
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }

    void setServerHostname(@NonNull String serverHostname) {
        this.mServerHostname.set(serverHostname);
    }
}

