/*
 * Decompiled with CFR 0.152.
 */
package com.datatheorem.android.trustkit.pinning;

import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.datatheorem.android.trustkit.pinning.OkHttp3PinningInterceptor;
import com.datatheorem.android.trustkit.pinning.OkHttpRootTrustManager;
import com.datatheorem.android.trustkit.pinning.SystemTrustManager;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Interceptor;

public class OkHttp3Helper {
    private static X509TrustManager trustManager = Build.VERSION.SDK_INT < 17 ? SystemTrustManager.getInstance() : new OkHttpRootTrustManager();

    @NonNull
    public static SSLSocketFactory getSSLSocketFactory() {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new X509TrustManager[]{trustManager}, null);
            return sslContext.getSocketFactory();
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new IllegalStateException("SSLSocketFactory creation failed");
        }
    }

    @NonNull
    @RequiresApi(api=17)
    public static Interceptor getPinningInterceptor() {
        return new OkHttp3PinningInterceptor((OkHttpRootTrustManager)trustManager);
    }

    @NonNull
    public static X509TrustManager getTrustManager() {
        return trustManager;
    }
}

