/*
 * Decompiled with CFR 0.152.
 */
package com.datatheorem.android.trustkit.pinning;

import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Set;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

class DebugOverridesTrustManager {
    DebugOverridesTrustManager() {
    }

    public static X509TrustManager getInstance(Set<Certificate> debugCaCerts) throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException {
        X509TrustManager debugTrustManager = null;
        KeyStore systemKeyStore = KeyStore.getInstance("AndroidCAStore");
        systemKeyStore.load(null, null);
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(null, null);
        Enumeration<String> aliases = systemKeyStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            X509Certificate cert = (X509Certificate)systemKeyStore.getCertificate(alias);
            keyStore.setCertificateEntry(alias, cert);
        }
        for (Certificate caCert : debugCaCerts) {
            String alias = "debug: " + ((X509Certificate)caCert).getSubjectDN().getName();
            keyStore.setCertificateEntry(alias, caCert);
        }
        String tmfAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(tmfAlgorithm);
        trustManagerFactory.init(keyStore);
        trustManagerFactory.getTrustManagers();
        for (TrustManager trustManager : trustManagerFactory.getTrustManagers()) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            debugTrustManager = (X509TrustManager)trustManager;
        }
        if (debugTrustManager == null) {
            throw new IllegalStateException("Should never happen");
        }
        return debugTrustManager;
    }
}

