/*
 * Decompiled with CFR 0.152.
 */
package com.datatheorem.android.trustkit.config;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.datatheorem.android.trustkit.config.ConfigurationException;
import com.datatheorem.android.trustkit.config.DomainPinningPolicy;
import com.datatheorem.android.trustkit.config.TrustKitConfiguration;
import com.datatheorem.android.trustkit.utils.TrustKitLog;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

class TrustKitConfigurationParser {
    TrustKitConfigurationParser() {
    }

    @NonNull
    public static TrustKitConfiguration fromXmlPolicy(@NonNull Context context, @NonNull XmlPullParser parser) throws XmlPullParserException, IOException, CertificateException {
        ArrayList<DomainPinningPolicy.Builder> builderList = new ArrayList<DomainPinningPolicy.Builder>();
        DebugOverridesTag debugOverridesTag = null;
        int eventType = parser.getEventType();
        while (eventType != 1) {
            if (eventType == 2) {
                if ("domain-config".equals(parser.getName())) {
                    builderList.addAll(TrustKitConfigurationParser.readDomainConfig(parser, null));
                } else if ("debug-overrides".equals(parser.getName())) {
                    debugOverridesTag = TrustKitConfigurationParser.readDebugOverrides(context, parser);
                }
            }
            eventType = parser.next();
        }
        HashSet<DomainPinningPolicy> domainConfigSet = new HashSet<DomainPinningPolicy>();
        for (DomainPinningPolicy.Builder builder : builderList) {
            DomainPinningPolicy policy = builder.build();
            if (policy == null) continue;
            domainConfigSet.add(policy);
        }
        TrustKitConfiguration config = debugOverridesTag != null ? new TrustKitConfiguration(domainConfigSet, debugOverridesTag.overridePins, debugOverridesTag.debugCaCertificates) : new TrustKitConfiguration(domainConfigSet);
        return config;
    }

    private static List<DomainPinningPolicy.Builder> readDomainConfig(XmlPullParser parser, DomainPinningPolicy.Builder parentBuilder) throws XmlPullParserException, IOException {
        parser.require(2, null, "domain-config");
        DomainPinningPolicy.Builder builder = new DomainPinningPolicy.Builder().setParent(parentBuilder);
        ArrayList<DomainPinningPolicy.Builder> builderList = new ArrayList<DomainPinningPolicy.Builder>();
        builderList.add(builder);
        int eventType = parser.next();
        while (eventType != 3 || !"domain-config".equals(parser.getName())) {
            if (eventType == 2) {
                if ("domain-config".equals(parser.getName())) {
                    builderList.addAll(TrustKitConfigurationParser.readDomainConfig(parser, builder));
                } else if ("domain".equals(parser.getName())) {
                    DomainTag domainTag = TrustKitConfigurationParser.readDomain(parser);
                    builder.setHostname(domainTag.hostname).setShouldIncludeSubdomains(domainTag.includeSubdomains);
                } else if ("pin-set".equals(parser.getName())) {
                    PinSetTag pinSetTag = TrustKitConfigurationParser.readPinSet(parser);
                    builder.setPublicKeyHashes(pinSetTag.pins).setExpirationDate(pinSetTag.expirationDate);
                } else if ("trustkit-config".equals(parser.getName())) {
                    TrustkitConfigTag trustkitTag = TrustKitConfigurationParser.readTrustkitConfig(parser);
                    builder.setReportUris(trustkitTag.reportUris).setShouldEnforcePinning(trustkitTag.enforcePinning).setShouldDisableDefaultReportUri(trustkitTag.disableDefaultReportUri);
                }
            }
            eventType = parser.next();
        }
        return builderList;
    }

    @NonNull
    private static PinSetTag readPinSet(@NonNull XmlPullParser parser) throws IOException, XmlPullParserException {
        parser.require(2, null, "pin-set");
        PinSetTag pinSetTag = new PinSetTag();
        pinSetTag.pins = new HashSet<String>();
        String expirationDate = parser.getAttributeValue(null, "expiration");
        if (expirationDate != null) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
                sdf.setLenient(false);
                Date date = sdf.parse(expirationDate);
                if (date == null) {
                    throw new ConfigurationException("Invalid expiration date in pin-set");
                }
                pinSetTag.expirationDate = date;
            }
            catch (ParseException e) {
                throw new ConfigurationException("Invalid expiration date in pin-set");
            }
        }
        int eventType = parser.next();
        while (eventType != 3 || !"pin-set".equals(parser.getName())) {
            if (eventType == 2 && "pin".equals(parser.getName())) {
                String digest = parser.getAttributeValue(null, "digest");
                if (digest == null || !digest.equals("SHA-256")) {
                    throw new IllegalArgumentException("Unexpected digest value: " + digest);
                }
                pinSetTag.pins.add(parser.nextText());
            }
            eventType = parser.next();
        }
        return pinSetTag;
    }

    @NonNull
    private static TrustkitConfigTag readTrustkitConfig(@NonNull XmlPullParser parser) throws IOException, XmlPullParserException {
        String disableDefaultReportUri;
        parser.require(2, null, "trustkit-config");
        TrustkitConfigTag result = new TrustkitConfigTag();
        HashSet<String> reportUris = new HashSet<String>();
        String enforcePinning = parser.getAttributeValue(null, "enforcePinning");
        if (enforcePinning != null) {
            result.enforcePinning = Boolean.parseBoolean(enforcePinning);
        }
        if ((disableDefaultReportUri = parser.getAttributeValue(null, "disableDefaultReportUri")) != null) {
            result.disableDefaultReportUri = Boolean.parseBoolean(disableDefaultReportUri);
        }
        int eventType = parser.next();
        while (eventType != 3 || !"trustkit-config".equals(parser.getName())) {
            if (eventType == 2 && "report-uri".equals(parser.getName())) {
                reportUris.add(parser.nextText());
            }
            eventType = parser.next();
        }
        result.reportUris = reportUris;
        return result;
    }

    @NonNull
    private static DomainTag readDomain(@NonNull XmlPullParser parser) throws IOException, XmlPullParserException {
        parser.require(2, null, "domain");
        DomainTag result = new DomainTag();
        String includeSubdomains = parser.getAttributeValue(null, "includeSubdomains");
        if (includeSubdomains != null) {
            result.includeSubdomains = Boolean.parseBoolean(includeSubdomains);
        }
        result.hostname = parser.nextText();
        return result;
    }

    @NonNull
    private static DebugOverridesTag readDebugOverrides(@NonNull Context context, @NonNull XmlPullParser parser) throws CertificateException, IOException, XmlPullParserException {
        parser.require(2, null, "debug-overrides");
        DebugOverridesTag result = new DebugOverridesTag();
        Boolean lastOverridePinsEncountered = null;
        HashSet<Certificate> debugCaCertificates = new HashSet<Certificate>();
        int eventType = parser.next();
        while (eventType != 3 || !"trust-anchors".equals(parser.getName())) {
            if (eventType == 2 && "certificates".equals(parser.getName())) {
                boolean currentOverridePins = Boolean.parseBoolean(parser.getAttributeValue(null, "overridePins"));
                if (lastOverridePinsEncountered != null && lastOverridePinsEncountered != currentOverridePins) {
                    lastOverridePinsEncountered = false;
                    TrustKitLog.w("Warning: different values for overridePins are set in the policy but TrustKit only supports one value; using overridePins=false for all connections");
                } else {
                    lastOverridePinsEncountered = currentOverridePins;
                }
                String caPathFromUser = parser.getAttributeValue(null, "src").trim();
                caPathFromUser = TrustKitConfigurationParser.formatCertPathResourceWhenId(context, caPathFromUser);
                if (!TextUtils.isEmpty((CharSequence)caPathFromUser) && !caPathFromUser.equals("user") && !caPathFromUser.equals("system") && caPathFromUser.startsWith("@raw")) {
                    InputStream stream = context.getResources().openRawResource(context.getResources().getIdentifier(caPathFromUser.split("/")[1], "raw", context.getPackageName()));
                    debugCaCertificates.add(CertificateFactory.getInstance("X.509").generateCertificate(stream));
                } else {
                    TrustKitLog.i("No <debug-overrides> certificates found by TrustKit. Please check your @raw folder (TrustKit doesn't support system and user installed certificates).");
                }
            }
            eventType = parser.next();
        }
        if (lastOverridePinsEncountered != null) {
            result.overridePins = lastOverridePinsEncountered;
        }
        if (debugCaCertificates.size() > 0) {
            result.debugCaCertificates = debugCaCertificates;
        }
        return result;
    }

    private static String formatCertPathResourceWhenId(@NonNull Context context, String caPathFromUser) {
        if (TextUtils.isDigitsOnly((CharSequence)caPathFromUser.replace("@", ""))) {
            caPathFromUser = "@" + context.getResources().getResourceName(Integer.parseInt(caPathFromUser.replace("@", ""))).replace(context.getPackageName() + ":", "");
        }
        return caPathFromUser;
    }

    private static class DebugOverridesTag {
        boolean overridePins = false;
        Set<Certificate> debugCaCertificates = null;

        private DebugOverridesTag() {
        }
    }

    private static class DomainTag {
        Boolean includeSubdomains = null;
        String hostname = null;

        private DomainTag() {
        }
    }

    private static class PinSetTag {
        Date expirationDate = null;
        Set<String> pins = null;

        private PinSetTag() {
        }
    }

    private static class TrustkitConfigTag {
        Boolean enforcePinning = false;
        Boolean disableDefaultReportUri;
        Set<String> reportUris;

        private TrustkitConfigTag() {
        }
    }
}

