/*
 * Decompiled with CFR 0.152.
 */
package com.datatheorem.android.trustkit.config;

import android.util.Base64;
import androidx.annotation.NonNull;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;

public final class PublicKeyPin {
    @NonNull
    private final String pin;

    public PublicKeyPin(@NonNull Certificate certificate) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Should never happen");
        }
        digest.reset();
        byte[] spki = certificate.getPublicKey().getEncoded();
        byte[] spkiHash = digest.digest(spki);
        this.pin = Base64.encodeToString((byte[])spkiHash, (int)0).trim();
    }

    public PublicKeyPin(@NonNull String spkiPin) {
        byte[] spkiSha256Hash = Base64.decode((String)spkiPin, (int)0);
        if (spkiSha256Hash.length != 32) {
            throw new IllegalArgumentException("Invalid pin: length is not 32 bytes");
        }
        this.pin = spkiPin.trim();
    }

    public boolean equals(Object arg0) {
        return arg0 instanceof PublicKeyPin && arg0.toString().equals(this.toString());
    }

    public int hashCode() {
        return this.pin.hashCode();
    }

    public String toString() {
        return this.pin;
    }
}

