/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.simulacron.server.token;

import com.datastax.oss.simulacron.common.cluster.ClusterSpec;
import com.datastax.oss.simulacron.common.cluster.DataCenterSpec;
import com.datastax.oss.simulacron.common.cluster.NodeSpec;
import com.datastax.oss.simulacron.server.token.TokenAssigner;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

public class SplitTokenAssigner
extends TokenAssigner {
    private Map<String, String> tokens = new HashMap<String, String>();

    public SplitTokenAssigner(ClusterSpec clusterSpec) {
        this.createTokens(clusterSpec);
    }

    private void createTokens(ClusterSpec clusterSpec) {
        int dcPos = 0;
        int nPos = 0;
        for (DataCenterSpec dataCenter : clusterSpec.getDataCenters()) {
            long dcOffset = dcPos * 100;
            BigInteger nodeBaseBig = BigInteger.valueOf(2L).pow(64).divide(BigInteger.valueOf(dataCenter.getNodes().size()));
            long nodeBase = nodeBaseBig.longValue();
            for (NodeSpec node : dataCenter.getNodes()) {
                long nodeOffset = Long.MIN_VALUE + (long)nPos * nodeBase;
                String tokenStr = "" + (nodeOffset + dcOffset);
                this.tokens.put(node.resolveId(), tokenStr);
                ++nPos;
            }
            ++dcPos;
        }
    }

    @Override
    String getTokensInternal(NodeSpec nodeSpec) {
        return this.tokens.get(nodeSpec.resolveId());
    }
}

