/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.simulacron.server;

import com.datastax.oss.protocol.internal.Frame;
import com.datastax.oss.simulacron.common.cluster.AbstractNode;
import com.datastax.oss.simulacron.common.stubbing.Prime;
import com.datastax.oss.simulacron.common.stubbing.StubMapping;
import com.datastax.oss.simulacron.server.BoundNode;
import com.datastax.oss.simulacron.server.InternalStubWrapper;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;

public class StubStore {
    private final CopyOnWriteArrayList<StubMapping> stubMappings = new CopyOnWriteArrayList();

    public void register(StubMapping mapping) {
        this.stubMappings.add(mapping);
    }

    public void registerInternal(Prime prime) {
        this.stubMappings.add((StubMapping)new InternalStubWrapper(prime));
    }

    public int clear() {
        int size = this.stubMappings.size();
        this.stubMappings.clear();
        return size;
    }

    public Optional<StubMapping> find(BoundNode node, Frame frame) {
        return this.stubMappings.stream().filter(s -> s.matches((AbstractNode)node, frame)).findFirst();
    }
}

