/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.simulacron.server;

import com.datastax.oss.protocol.internal.Compressor;
import com.datastax.oss.protocol.internal.FrameCodec;
import com.datastax.oss.protocol.internal.PrimitiveCodec;
import com.datastax.oss.simulacron.common.cluster.AbstractNode;
import com.datastax.oss.simulacron.common.cluster.ClusterSpec;
import com.datastax.oss.simulacron.common.cluster.DataCenterSpec;
import com.datastax.oss.simulacron.common.cluster.NodeSpec;
import com.datastax.oss.simulacron.common.stubbing.EmptyReturnMetadataHandler;
import com.datastax.oss.simulacron.common.stubbing.PeerMetadataHandler;
import com.datastax.oss.simulacron.common.stubbing.StubMapping;
import com.datastax.oss.simulacron.server.AddressResolver;
import com.datastax.oss.simulacron.server.BindNodeException;
import com.datastax.oss.simulacron.server.BoundCluster;
import com.datastax.oss.simulacron.server.BoundDataCenter;
import com.datastax.oss.simulacron.server.BoundNode;
import com.datastax.oss.simulacron.server.ByteBufCodec;
import com.datastax.oss.simulacron.server.CompletableFutures;
import com.datastax.oss.simulacron.server.FrameDecoder;
import com.datastax.oss.simulacron.server.FrameEncoder;
import com.datastax.oss.simulacron.server.RequestHandler;
import com.datastax.oss.simulacron.server.ServerOptions;
import com.datastax.oss.simulacron.server.StubStore;
import com.datastax.oss.simulacron.server.token.RandomTokenAssigner;
import com.datastax.oss.simulacron.server.token.SplitTokenAssigner;
import com.datastax.oss.simulacron.server.token.TokenAssigner;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.flush.FlushConsolidationHandler;
import io.netty.util.AttributeKey;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timer;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public final class Server
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(Server.class);
    static final AttributeKey<BoundNode> HANDLER = AttributeKey.valueOf((String)"NODE");
    private static final FrameCodec<ByteBuf> frameCodec = FrameCodec.defaultServer((PrimitiveCodec)new ByteBufCodec(), (Compressor)Compressor.none());
    final ServerBootstrap serverBootstrap;
    private final AddressResolver addressResolver;
    private final long bindTimeoutInNanos;
    final StubStore stubStore;
    final Timer timer;
    private final boolean customTimer;
    private final AtomicLong clusterCounter = new AtomicLong();
    private final Map<Long, BoundCluster> clusters = new ConcurrentHashMap<Long, BoundCluster>();
    private final boolean activityLogging;
    final EventLoopGroup eventLoopGroup;
    private final boolean customEventLoop;
    private final AtomicReference<CompletionStage<Void>> closeFuture = new AtomicReference();

    Server(AddressResolver addressResolver, EventLoopGroup eventLoopGroup, boolean customEventLoop, Timer timer, boolean customTimer, long bindTimeoutInNanos, StubStore stubStore, boolean activityLogging, ServerBootstrap serverBootstrap) {
        this.addressResolver = addressResolver;
        this.timer = timer;
        this.customTimer = customTimer;
        this.eventLoopGroup = eventLoopGroup;
        this.customEventLoop = customEventLoop;
        this.serverBootstrap = serverBootstrap;
        this.bindTimeoutInNanos = bindTimeoutInNanos;
        this.stubStore = stubStore;
        this.activityLogging = activityLogging;
    }

    private Server(AddressResolver addressResolver, EventLoopGroup eventLoopGroup, Class<? extends ServerChannel> channelClass, boolean customEventLoop, Timer timer, boolean customTimer, long bindTimeoutInNanos, StubStore stubStore, boolean activityLogging) {
        this(addressResolver, eventLoopGroup, customEventLoop, timer, customTimer, bindTimeoutInNanos, stubStore, activityLogging, ((ServerBootstrap)new ServerBootstrap().group(eventLoopGroup).channel(channelClass)).childHandler((ChannelHandler)new Initializer()));
    }

    public boolean isClosed() {
        return this.closeFuture.get() != null;
    }

    <T> CompletionStage<T> failByClose() {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(new IllegalStateException("Server is closed"));
        return future;
    }

    private BoundCluster boundCluster(ClusterSpec cluster) {
        long clusterId = cluster.getId() == null ? this.clusterCounter.getAndIncrement() : cluster.getId().longValue();
        return new BoundCluster(cluster, clusterId, this);
    }

    public BoundCluster register(ClusterSpec.Builder builder) {
        return CompletableFutures.getUninterruptibly(this.registerAsync(builder));
    }

    public CompletionStage<BoundCluster> registerAsync(ClusterSpec.Builder builder) {
        return this.registerAsync(builder.build(), ServerOptions.DEFAULT);
    }

    public BoundCluster register(ClusterSpec cluster) {
        return CompletableFutures.getUninterruptibly(this.registerAsync(cluster));
    }

    public CompletionStage<BoundCluster> registerAsync(ClusterSpec cluster) {
        return this.registerAsync(cluster, ServerOptions.DEFAULT);
    }

    public BoundCluster register(ClusterSpec cluster, ServerOptions serverOptions) {
        return CompletableFutures.getUninterruptibly(this.registerAsync(cluster, serverOptions));
    }

    public CompletionStage<BoundCluster> registerAsync(ClusterSpec cluster, ServerOptions serverOptions) {
        if (this.isClosed()) {
            return this.failByClose();
        }
        BoundCluster c = this.boundCluster(cluster);
        ArrayList<CompletableFuture<BoundNode>> bindFutures = new ArrayList<CompletableFuture<BoundNode>>();
        boolean activityLogging = serverOptions.isActivityLoggingEnabled() != null ? serverOptions.isActivityLoggingEnabled() : this.activityLogging;
        TokenAssigner tokenAssignment = cluster.getNumberOfTokens() == 1 ? new SplitTokenAssigner(cluster) : new RandomTokenAssigner(cluster.getNumberOfTokens());
        for (DataCenterSpec dataCenter : cluster.getDataCenters()) {
            BoundDataCenter dc = new BoundDataCenter(dataCenter, c);
            for (NodeSpec node : dataCenter.getNodes()) {
                String tokenStr = tokenAssignment.getTokens(node);
                SocketAddress socketAddress = node.getAddress() != null ? node.getAddress() : (SocketAddress)this.addressResolver.get();
                bindFutures.add(this.bindInternal(node, c, dc, tokenStr, socketAddress, activityLogging).toCompletableFuture());
            }
        }
        this.clusters.put(c.getId(), c);
        ArrayList<BoundNode> nodes = new ArrayList<BoundNode>(bindFutures.size());
        Throwable exception = null;
        boolean timedOut = false;
        long start = System.nanoTime();
        for (CompletableFuture completableFuture : bindFutures) {
            try {
                if (timedOut) {
                    BoundNode node = completableFuture.getNow(null);
                    if (node != null) {
                        nodes.add(node);
                    }
                } else {
                    nodes.add((BoundNode)completableFuture.get(this.bindTimeoutInNanos, TimeUnit.NANOSECONDS));
                }
                if (System.nanoTime() - start <= this.bindTimeoutInNanos) continue;
                timedOut = true;
            }
            catch (TimeoutException te) {
                timedOut = true;
                exception = te;
            }
            catch (Exception e) {
                exception = e.getCause();
            }
        }
        if (exception != null) {
            Throwable e = exception;
            List<CompletableFuture> list = nodes.stream().map(this::close).collect(Collectors.toList());
            CompletableFuture<BoundCluster> future = new CompletableFuture<BoundCluster>();
            CompletableFuture.allOf(list.toArray(new CompletableFuture[0])).handle((v, ex) -> {
                this.clusters.remove(c.getId());
                future.completeExceptionally(e);
                return v;
            });
            return future;
        }
        return CompletableFuture.allOf(bindFutures.toArray(new CompletableFuture[0])).thenApply(__ -> c);
    }

    public BoundCluster unregister(BoundNode node) {
        return CompletableFutures.getUninterruptibly(this.unregisterAsync(node));
    }

    public CompletionStage<BoundCluster> unregisterAsync(BoundNode node) {
        if (this.isClosed()) {
            return this.failByClose();
        }
        if (node.getCluster() == null) {
            CompletableFuture<BoundCluster> future = new CompletableFuture<BoundCluster>();
            future.completeExceptionally(new IllegalArgumentException("Node has no parent Cluster"));
            return future;
        }
        return this.unregisterAsync(((BoundCluster)node.getCluster()).getId());
    }

    public BoundCluster unregister(BoundCluster cluster) {
        return CompletableFutures.getUninterruptibly(this.unregisterAsync(cluster));
    }

    public CompletionStage<BoundCluster> unregisterAsync(BoundCluster cluster) {
        return this.unregisterAsync(cluster.getId());
    }

    public BoundCluster unregister(Long clusterId) {
        return CompletableFutures.getUninterruptibly(this.unregisterAsync(clusterId));
    }

    public CompletionStage<BoundCluster> unregisterAsync(Long clusterId) {
        if (this.isClosed()) {
            return this.failByClose();
        }
        CompletableFuture<BoundCluster> future = new CompletableFuture<BoundCluster>();
        if (clusterId == null) {
            future.completeExceptionally(new IllegalArgumentException("Null id provided"));
        } else {
            BoundCluster foundCluster = this.clusters.remove(clusterId);
            ArrayList<CompletableFuture<BoundNode>> closeFutures = new ArrayList<CompletableFuture<BoundNode>>();
            if (foundCluster != null) {
                for (BoundDataCenter dataCenter : foundCluster.getDataCenters()) {
                    for (BoundNode node : dataCenter.getNodes()) {
                        closeFutures.add(this.close(node));
                    }
                }
                CompletableFuture.allOf(closeFutures.toArray(new CompletableFuture[0])).whenComplete((__, ex) -> {
                    if (ex != null) {
                        future.completeExceptionally((Throwable)ex);
                    } else {
                        future.complete(foundCluster);
                    }
                });
            } else {
                future.completeExceptionally(new IllegalArgumentException("ClusterSpec not found."));
            }
        }
        return future;
    }

    public Integer unregisterAll() {
        return CompletableFutures.getUninterruptibly(this.unregisterAllAsync());
    }

    public CompletionStage<Integer> unregisterAllAsync() {
        if (this.isClosed()) {
            return this.failByClose();
        }
        List<CompletableFuture> futures = this.clusters.keySet().stream().map(this::unregisterAsync).map(CompletionStage::toCompletableFuture).collect(Collectors.toList());
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenApply(__ -> futures.size());
    }

    public BoundNode register(NodeSpec.Builder builder) {
        return CompletableFutures.getUninterruptibly(this.registerAsync(builder));
    }

    public CompletionStage<BoundNode> registerAsync(NodeSpec.Builder builder) {
        return this.registerAsync(builder.build());
    }

    public BoundNode register(NodeSpec node) {
        return CompletableFutures.getUninterruptibly(this.registerAsync(node));
    }

    public CompletionStage<BoundNode> registerAsync(NodeSpec node) {
        return this.registerAsync(node, ServerOptions.DEFAULT);
    }

    public BoundNode register(NodeSpec node, ServerOptions serverOptions) {
        return CompletableFutures.getUninterruptibly(this.registerAsync(node, serverOptions));
    }

    public CompletionStage<BoundNode> registerAsync(NodeSpec node, ServerOptions serverOptions) {
        if (this.isClosed()) {
            return this.failByClose();
        }
        if (node.getDataCenter() != null) {
            CompletableFuture<BoundNode> future = new CompletableFuture<BoundNode>();
            future.completeExceptionally(new IllegalArgumentException("Node belongs to a Cluster, should be standalone."));
            return future;
        }
        Long clusterId = this.clusterCounter.getAndIncrement();
        BoundCluster dummyCluster = this.boundCluster(((ClusterSpec.Builder)((ClusterSpec.Builder)ClusterSpec.builder().withId(clusterId)).withName("dummy")).build());
        BoundDataCenter dummyDataCenter = new BoundDataCenter(dummyCluster);
        this.clusters.put(clusterId, dummyCluster);
        boolean activityLogging = serverOptions.isActivityLoggingEnabled() != null ? serverOptions.isActivityLoggingEnabled() : this.activityLogging;
        SocketAddress address = node.getAddress() != null ? node.getAddress() : (SocketAddress)this.addressResolver.get();
        return this.bindInternal(node, dummyCluster, dummyDataCenter, node.resolvePeerInfo("tokens", String.class).orElse("0"), address, activityLogging);
    }

    public BoundCluster getCluster(long id) {
        return this.clusters.get(id);
    }

    public Collection<BoundCluster> getClusters() {
        return this.clusters.values();
    }

    private CompletionStage<BoundNode> bindInternal(NodeSpec refNode, BoundCluster cluster, BoundDataCenter parent, String token, SocketAddress address, boolean activityLogging) {
        HashMap<String, String> newPeerInfo = new HashMap<String, String>(refNode.getPeerInfo());
        newPeerInfo.put("tokens", token);
        CompletableFuture<BoundNode> f = new CompletableFuture<BoundNode>();
        ChannelFuture bindFuture = this.serverBootstrap.bind(address);
        bindFuture.addListener((GenericFutureListener)((ChannelFutureListener)channelFuture -> {
            if (channelFuture.isSuccess()) {
                BoundNode node = new BoundNode(address, refNode, newPeerInfo, cluster, parent, this, this.timer, channelFuture.channel(), activityLogging);
                logger.info("Bound Node {} to {}", (Object)node.resolveId(), (Object)channelFuture.channel());
                channelFuture.channel().attr(HANDLER).set((Object)node);
                f.complete(node);
            } else {
                f.completeExceptionally(new BindNodeException((AbstractNode)refNode, address, channelFuture.cause()));
            }
        }));
        return f;
    }

    private CompletableFuture<BoundNode> close(BoundNode node) {
        logger.debug("Closing Node {} on {}.", (Object)node.resolveId(), node.channel);
        return node.stopAsync().thenApply(n -> {
            logger.debug("Releasing {} back to address resolver so it may be reused.", (Object)node.getAddress());
            this.addressResolver.release(node.getAddress());
            return node;
        }).toCompletableFuture();
    }

    private static Optional<EventLoopGroup> epollEventLoopGroup(ThreadFactory threadFactory) {
        if (Epoll.isAvailable()) {
            return Optional.of(new EpollEventLoopGroup(0, threadFactory));
        }
        return Optional.empty();
    }

    private static Class<? extends ServerChannel> epollClass() {
        return EpollServerSocketChannel.class;
    }

    public static Builder builder() {
        return new Builder();
    }

    public CompletionStage<Void> closeAsync() {
        if (this.isClosed()) {
            return this.closeFuture.get();
        }
        return this.closeFuture.updateAndGet(current -> {
            if (current != null) {
                return current;
            }
            return this.unregisterAllAsync().thenCompose(i -> {
                if (!this.customTimer) {
                    this.timer.stop();
                }
                if (!this.customEventLoop) {
                    Future future = this.eventLoopGroup.shutdownGracefully(0L, 1L, TimeUnit.SECONDS);
                    CompletableFuture<Void> f = CompletableFuture.supplyAsync(() -> Server.lambda$null$6((java.util.concurrent.Future)future));
                    return f;
                }
                CompletableFuture<Object> future = new CompletableFuture<Object>();
                future.complete(null);
                return future;
            });
        });
    }

    @Override
    public void close() {
        CompletableFutures.getUninterruptibly(this.closeAsync());
    }

    private static /* synthetic */ Void lambda$null$6(java.util.concurrent.Future future) {
        try {
            future.get();
            return null;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    static class Initializer
    extends ChannelInitializer<Channel> {
        Initializer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void initChannel(Channel channel) throws Exception {
            ChannelPipeline pipeline = channel.pipeline();
            BoundNode node = (BoundNode)channel.parent().attr(HANDLER).get();
            node.clientChannelGroup.add((Object)channel);
            MDC.put((String)"node", (String)node.getId().toString());
            try {
                logger.debug("Got new connection {}", (Object)channel);
                pipeline.addLast(new ChannelHandler[]{new FlushConsolidationHandler()}).addLast("decoder", (ChannelHandler)new FrameDecoder(node.getFrameCodec())).addLast("encoder", (ChannelHandler)new FrameEncoder(node.getFrameCodec())).addLast("requestHandler", (ChannelHandler)new RequestHandler(node));
            }
            finally {
                MDC.remove((String)"node");
            }
        }
    }

    public static class Builder {
        private AddressResolver addressResolver = AddressResolver.defaultResolver;
        private static long DEFAULT_BIND_TIMEOUT_IN_NANOS = TimeUnit.NANOSECONDS.convert(10L, TimeUnit.SECONDS);
        private long bindTimeoutInNanos = DEFAULT_BIND_TIMEOUT_IN_NANOS;
        private Timer timer;
        private StubStore stubStore;
        private boolean activityLogging = true;
        private boolean multipleNodesPerIp = false;
        private EventLoopGroup eventLoopGroup;
        private Class<? extends ServerChannel> channelClass;

        Builder() {
        }

        public Builder withBindTimeout(long time, TimeUnit timeUnit) {
            this.bindTimeoutInNanos = TimeUnit.NANOSECONDS.convert(time, timeUnit);
            return this;
        }

        public Builder withAddressResolver(AddressResolver addressResolver) {
            this.addressResolver = addressResolver;
            return this;
        }

        public Builder withEventLoopGroup(EventLoopGroup eventLoopGroup, Class<? extends ServerChannel> clazz) {
            this.eventLoopGroup = eventLoopGroup;
            this.channelClass = clazz;
            return this;
        }

        public Builder withTimer(Timer timer) {
            this.timer = timer;
            return this;
        }

        public Builder withStubStore(StubStore stubStore) {
            this.stubStore = stubStore;
            return this;
        }

        public Builder withActivityLoggingEnabled(boolean enabled) {
            this.activityLogging = enabled;
            return this;
        }

        public Builder withMultipleNodesPerIp(boolean enabled) {
            this.multipleNodesPerIp = enabled;
            if (enabled) {
                this.addressResolver = AddressResolver.nodePerPortResolver;
            }
            return this;
        }

        public Server build() {
            Timer timer;
            if (this.stubStore == null) {
                this.stubStore = new StubStore();
                this.stubStore.register((StubMapping)new PeerMetadataHandler(this.multipleNodesPerIp));
                this.stubStore.register((StubMapping)new EmptyReturnMetadataHandler("SELECT * FROM system_schema.keyspaces"));
                this.stubStore.register((StubMapping)new EmptyReturnMetadataHandler("SELECT * FROM system_schema.views"));
                this.stubStore.register((StubMapping)new EmptyReturnMetadataHandler("SELECT * FROM system_schema.tables"));
                this.stubStore.register((StubMapping)new EmptyReturnMetadataHandler("SELECT * FROM system_schema.columns"));
                this.stubStore.register((StubMapping)new EmptyReturnMetadataHandler("SELECT * FROM system_schema.indexes"));
                this.stubStore.register((StubMapping)new EmptyReturnMetadataHandler("SELECT * FROM system_schema.triggers"));
                this.stubStore.register((StubMapping)new EmptyReturnMetadataHandler("SELECT * FROM system_schema.types"));
                this.stubStore.register((StubMapping)new EmptyReturnMetadataHandler("SELECT * FROM system_schema.functions"));
                this.stubStore.register((StubMapping)new EmptyReturnMetadataHandler("SELECT * FROM system_schema.aggregates"));
                this.stubStore.register((StubMapping)new EmptyReturnMetadataHandler("SELECT * FROM system_schema.views"));
                this.stubStore.register((StubMapping)new EmptyReturnMetadataHandler("SELECT * FROM system.schema_keyspaces"));
                this.stubStore.register((StubMapping)new EmptyReturnMetadataHandler("SELECT * FROM system.schema_columnfamilies"));
                this.stubStore.register((StubMapping)new EmptyReturnMetadataHandler("SELECT * FROM system.schema_columns"));
                this.stubStore.register((StubMapping)new EmptyReturnMetadataHandler("SELECT * FROM system.schema_triggers"));
                this.stubStore.register((StubMapping)new EmptyReturnMetadataHandler("SELECT * FROM system.schema_usertypes"));
                this.stubStore.register((StubMapping)new EmptyReturnMetadataHandler("SELECT * FROM system.schema_functions"));
                this.stubStore.register((StubMapping)new EmptyReturnMetadataHandler("SELECT * FROM system.schema_aggregates"));
                this.stubStore.register((StubMapping)new EmptyReturnMetadataHandler("SELECT * FROM system_virtual_schema.keyspaces"));
                this.stubStore.register((StubMapping)new EmptyReturnMetadataHandler("SELECT * FROM system_virtual_schema.columns"));
                this.stubStore.register((StubMapping)new EmptyReturnMetadataHandler("SELECT * FROM system_virtual_schema.tables"));
            }
            if ((timer = this.timer) == null) {
                DefaultThreadFactory f = new DefaultThreadFactory("simulacron-timer");
                timer = new HashedWheelTimer((ThreadFactory)f);
            }
            EventLoopGroup eventLoopGroup = this.eventLoopGroup;
            Class<NioServerSocketChannel> channelClass = this.channelClass;
            if (eventLoopGroup == null) {
                DefaultThreadFactory f = new DefaultThreadFactory("simulacron-io-worker");
                try {
                    Class.forName("io.netty.channel.epoll.Epoll");
                    Optional epollEventLoop = Server.epollEventLoopGroup((ThreadFactory)f);
                    if (epollEventLoop.isPresent()) {
                        logger.debug("Detected epoll support, using EpollEventLoopGroup");
                        eventLoopGroup = (EventLoopGroup)epollEventLoop.get();
                        channelClass = Server.epollClass();
                    } else {
                        logger.debug("Could not load native transport (epoll), using NioEventLoopGroup");
                        eventLoopGroup = new NioEventLoopGroup(0, (ThreadFactory)f);
                        channelClass = NioServerSocketChannel.class;
                    }
                }
                catch (ClassNotFoundException ce) {
                    logger.debug("netty-transport-native-epoll not on classpath, using NioEventLoopGroup");
                    eventLoopGroup = new NioEventLoopGroup(0, (ThreadFactory)f);
                    channelClass = NioServerSocketChannel.class;
                }
            }
            return new Server(this.addressResolver, eventLoopGroup, channelClass, this.eventLoopGroup != null, timer, this.timer != null, this.bindTimeoutInNanos, this.stubStore, this.activityLogging);
        }
    }
}

