/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.simulacron.server;

import com.datastax.oss.simulacron.server.AddressResolver;
import com.datastax.oss.simulacron.server.InetSocketAddressComparator;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Queue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;

public class NodePerPortResolver
implements AddressResolver {
    private final AtomicReference<InetSocketAddress> ip;
    private final int startingPortPerIp;
    private final Queue<InetSocketAddress> releasedAddresses = new PriorityBlockingQueue<InetSocketAddress>(10, InetSocketAddressComparator.INSTANCE);

    public NodePerPortResolver() {
        this(defaultStartingIp, 49152);
    }

    public NodePerPortResolver(int startingPortPerIp) {
        this(defaultStartingIp, startingPortPerIp);
    }

    public NodePerPortResolver(byte[] startingAddress, int startingPortPerIp) {
        byte[] ipAddr = new byte[4];
        System.arraycopy(startingAddress, 0, ipAddr, 0, 4);
        this.ip = new AtomicReference<InetSocketAddress>(new InetSocketAddress(AddressResolver.Inet4Resolver.inetAddress(ipAddr), startingPortPerIp));
        this.startingPortPerIp = startingPortPerIp;
        AddressResolver.Inet4Resolver.checkAddressPresence(ipAddr, 1);
    }

    @Override
    public SocketAddress get() {
        int port;
        InetSocketAddress newAddress;
        InetSocketAddress addr;
        InetSocketAddress address = this.releasedAddresses.poll();
        if (address != null) {
            return address;
        }
        while (!this.ip.compareAndSet(addr, newAddress = (port = (addr = this.ip.get()).getPort() + 1) > 65535 ? new InetSocketAddress(AddressResolver.Inet4Resolver.inetAddress(AddressResolver.Inet4Resolver.nextAddressBytes(addr.getAddress().getAddress())), this.startingPortPerIp) : new InetSocketAddress(addr.getAddress(), port))) {
        }
        return addr;
    }
}

