/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.simulacron.server;

import com.datastax.oss.protocol.internal.FrameCodec;
import com.datastax.oss.protocol.internal.ProtocolV3ServerCodecs;
import com.datastax.oss.protocol.internal.ProtocolV4ServerCodecs;
import com.datastax.oss.protocol.internal.ProtocolV5ServerCodecs;
import com.datastax.oss.simulacron.common.cluster.NodeProperties;
import com.datastax.oss.simulacron.server.FrameCodecWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FrameCodecUtils {
    private static final Logger logger = LoggerFactory.getLogger(FrameCodecUtils.class);
    private static final List<Integer> defaultProtocolVersions = new ArrayList<Integer>();
    private static final String PROTOCOL_VERSIONS = "protocol_versions";
    private static final FrameCodecWrapper defaultFrameCodec;

    FrameCodecUtils() {
    }

    static Optional<FrameCodecWrapper> buildFrameCodec(NodeProperties topic) {
        if (topic.getPeerInfo().containsKey(PROTOCOL_VERSIONS)) {
            List protocolVersions = (List)topic.resolvePeerInfo(PROTOCOL_VERSIONS, defaultProtocolVersions);
            return Optional.of(FrameCodecUtils.buildFrameCodec(new TreeSet<Integer>(protocolVersions)));
        }
        if (topic.getCassandraVersion() != null && !topic.isPeerInfoPresent(PROTOCOL_VERSIONS)) {
            if (topic.getCassandraVersion().startsWith("4.")) {
                return Optional.of(FrameCodecUtils.buildFrameCodec(3, 4, 5));
            }
            if (topic.getCassandraVersion().startsWith("3.0") || topic.getCassandraVersion().startsWith("2.2")) {
                return Optional.of(FrameCodecUtils.buildFrameCodec(3, 4));
            }
            if (topic.getCassandraVersion().startsWith("2.1")) {
                return Optional.of(FrameCodecUtils.buildFrameCodec(3));
            }
            logger.warn("Could not resolve supported protocol versions from cassandra version " + topic.getCassandraVersion());
        }
        return Optional.empty();
    }

    static FrameCodecWrapper defaultFrameCodec() {
        return defaultFrameCodec;
    }

    static FrameCodecWrapper buildFrameCodec(Integer ... protocolVersions) {
        TreeSet<Integer> versions = new TreeSet<Integer>(Arrays.asList(protocolVersions));
        return FrameCodecUtils.buildFrameCodec(versions);
    }

    static FrameCodecWrapper buildFrameCodec(Set<Integer> protocolVersions) {
        if (protocolVersions.equals(defaultProtocolVersions)) {
            return defaultFrameCodec;
        }
        ArrayList<Object> codecGroups = new ArrayList<Object>();
        block5: for (int protocolVersion : protocolVersions) {
            switch (protocolVersion) {
                case 3: {
                    codecGroups.add(new ProtocolV3ServerCodecs());
                    continue block5;
                }
                case 4: {
                    codecGroups.add(new ProtocolV4ServerCodecs());
                    continue block5;
                }
                case 5: {
                    codecGroups.add(new ProtocolV5ServerCodecs());
                    continue block5;
                }
            }
            logger.warn("Unknown protocol versions '{}' provided, ignoring.", (Object)protocolVersion);
        }
        return new FrameCodecWrapper(protocolVersions, codecGroups.toArray(new FrameCodec.CodecGroup[codecGroups.size()]));
    }

    static {
        defaultProtocolVersions.add(3);
        defaultProtocolVersions.add(4);
        defaultFrameCodec = new FrameCodecWrapper(new TreeSet<Integer>(defaultProtocolVersions), new FrameCodec.CodecGroup[]{new ProtocolV3ServerCodecs(), new ProtocolV4ServerCodecs()});
    }
}

