/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.simulacron.server;

import com.datastax.oss.simulacron.common.cluster.ConnectionReport;
import com.datastax.oss.simulacron.common.cluster.NodeProperties;
import com.datastax.oss.simulacron.common.cluster.QueryLog;
import com.datastax.oss.simulacron.common.cluster.QueryLogReport;
import com.datastax.oss.simulacron.common.stubbing.CloseType;
import com.datastax.oss.simulacron.common.stubbing.Prime;
import com.datastax.oss.simulacron.common.stubbing.PrimeDsl;
import com.datastax.oss.simulacron.common.stubbing.StubMapping;
import com.datastax.oss.simulacron.server.BoundCluster;
import com.datastax.oss.simulacron.server.BoundNode;
import com.datastax.oss.simulacron.server.CompletableFutures;
import com.datastax.oss.simulacron.server.FrameCodecWrapper;
import com.datastax.oss.simulacron.server.RejectScope;
import com.datastax.oss.simulacron.server.Server;
import com.datastax.oss.simulacron.server.StubStore;
import com.datastax.oss.simulacron.server.listener.QueryListener;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public interface BoundTopic<C extends ConnectionReport, Q extends QueryLogReport>
extends AutoCloseable,
NodeProperties {
    @JsonIgnore
    public StubStore getStubStore();

    default public void prime(Prime prime) {
        this.getStubStore().register((StubMapping)prime);
    }

    default public void prime(PrimeDsl.PrimeBuilder prime) {
        this.prime(prime.build());
    }

    public int clearPrimes(boolean var1);

    default public BoundCluster unregister() {
        return CompletableFutures.getUninterruptibly(this.unregisterAsync());
    }

    public CompletionStage<BoundCluster> unregisterAsync();

    @JsonIgnore
    public C getConnections();

    default public C closeConnections(CloseType closeType) {
        return (C)((ConnectionReport)CompletableFutures.getUninterruptibly(this.closeConnectionsAsync(closeType)));
    }

    public CompletionStage<C> closeConnectionsAsync(CloseType var1);

    default public C closeConnection(SocketAddress connection, CloseType closeType) {
        return (C)((ConnectionReport)CompletableFutures.getUninterruptibly(this.closeConnectionAsync(connection, closeType)));
    }

    public CompletionStage<C> closeConnectionAsync(SocketAddress var1, CloseType var2);

    @JsonIgnore
    public Collection<BoundNode> getNodes();

    default public CompletionStage<Void> forEachNode(Function<BoundNode, CompletionStage<Void>> fun) {
        return CompletableFuture.allOf(this.getNodes().stream().map(i -> ((CompletionStage)fun.apply((BoundNode)i)).toCompletableFuture()).collect(Collectors.toList()).toArray(new CompletableFuture[0])).thenApply(v -> null);
    }

    default public void stop() {
        CompletableFutures.getUninterruptibly(this.stopAsync());
    }

    default public CompletionStage<Void> stopAsync() {
        return this.rejectConnectionsAsync(0, RejectScope.STOP);
    }

    default public void rejectConnections(int after, RejectScope rejectScope) {
        CompletableFutures.getUninterruptibly(this.rejectConnectionsAsync(after, rejectScope));
    }

    default public CompletionStage<Void> rejectConnectionsAsync(int after, RejectScope rejectScope) {
        return this.forEachNode(n -> n.rejectConnectionsAsync(after, rejectScope));
    }

    default public void acceptConnections() {
        CompletableFutures.getUninterruptibly(this.acceptConnectionsAsync());
    }

    default public CompletionStage<Void> acceptConnectionsAsync() {
        return this.forEachNode(BoundNode::acceptConnectionsAsync);
    }

    default public void start() {
        CompletableFutures.getUninterruptibly(this.startAsync());
    }

    default public CompletionStage<Void> startAsync() {
        return this.acceptConnectionsAsync();
    }

    @JsonIgnore
    public Q getLogs();

    @JsonIgnore
    public Q getLogs(boolean var1);

    default public void clearLogs() {
        this.getNodes().forEach(BoundNode::clearLogs);
    }

    default public void registerQueryListener(QueryListener queryListener) {
        this.registerQueryListener(queryListener, false);
    }

    default public void registerQueryListener(QueryListener queryListener, boolean after) {
        this.registerQueryListener(queryListener, after, BoundNode.ALWAYS_TRUE);
    }

    public void registerQueryListener(QueryListener var1, boolean var2, Predicate<QueryLog> var3);

    @JsonIgnore
    public Server getServer();

    @JsonIgnore
    public FrameCodecWrapper getFrameCodec();

    @Override
    default public void close() {
        try {
            this.unregister();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

